/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.finalkombat2.enemigos;

import WelderTools.WeeldSprite;
import com.kitmaker.finalkombat2.Game;
import com.kitmaker.finalkombat2.Gfx;
import com.kitmaker.finalkombat2.Player;
import com.kitmaker.finalkombat2.SP;
import com.kitmaker.finalkombat2.enemigos.Bullet;
import com.kitmaker.finalkombat2.enemigos.Enemy;
import javax.microedition.lcdui.Graphics;

public class Basico2
extends Enemy {
    private int strength;
    private int width;
    private int height;
    private boolean facingRight;
    private int state = 0;
    private final int IDLE;
    private final int PREPARING;
    private final int AIM;
    private final int SHOOT;
    private final int MELEE;
    private final int HITTED;
    private final int DEATH;
    private int shootAttackDistance;
    private int meleeAttackDistance;
    private int sightDistanceY;
    private int actionDelay;
    private int time;
    private int blinkTimer;
    private boolean blink;
    private boolean alive;
    private boolean bNearPlayer;
    private boolean hitted;
    private boolean wasApunting;
    private int tiempoApunting;
    private Bullet[] bulletPool = new Bullet[5];
    private final int HIT_PUSH_DISTANCE;
    private String eBasicoPngPath = "/eBasico2.png";
    private String eBasicoAnuPath = "/eBasico2.anu";
    private static final int BULLET_ADJUST_X = 0;
    private static final int BULLET_ADJUST_Y = 0;

    public Basico2(int _ID, int _posX, int _posY) {
        this.IDLE = 0;
        this.PREPARING = 1;
        this.AIM = 2;
        this.SHOOT = 3;
        this.MELEE = 4;
        this.HITTED = 5;
        this.DEATH = 6;
        this.HIT_PUSH_DISTANCE = 8;
        for (int i = 0; i < this.bulletPool.length; ++i) {
            this.bulletPool[i] = new Bullet(_posX, _posY, true, false);
        }
        this.hitted = false;
        this.health = 4;
        this.strength = 10;
        this.width = 32;
        this.height = 64;
        this.facingRight = true;
        this.shootAttackDistance = 208;
        this.meleeAttackDistance = 48;
        this.sightDistanceY = 32;
        this.actionDelay = 1200;
        this.state = 0;
        this.posX = _posX;
        this.posY = _posY - this.height + 32;
        this.enemySprite = new WeeldSprite(_ID, new String[]{this.eBasicoPngPath, "/fx_01.png", "/fx_05.png"}, this.eBasicoAnuPath, _posX, _posY, Gfx.totalWeeldSprite);
        this.enemySprite.loadPoolImage();
        this.blink = true;
        this.alive = true;
        this.wasApunting = false;
        this.tiempoApunting = 0;
        this.enemySprite.setAnimation(this.state, true);
        this.time = (int)System.currentTimeMillis();
    }

    public void updateIA() {
        this.runStopframesByHit();
        this.enemySprite.update();
        this.CheckAnimation();
        if (this.state < 6) {
            this.Flip();
            if (!Game.isInTheGetho) {
                this.Behavior();
            } else if (this.enemySprite.getAnimation() != 0) {
                this.enemySprite.setAnimation(0, true);
            }
            if (this.m_iHittedCount < Player.ms_lPlayeHitCount) {
                this.CheckPlayerHit();
            }
        }
    }

    public void updateBullet() {
        for (int i = 0; i < this.bulletPool.length; ++i) {
            if (!this.bulletPool[i].isAlive()) continue;
            this.bulletPool[i].update();
        }
    }

    private void Behavior() {
        if (this.state != 4 && this.state != 5) {
            if (this.PlayerSight() && !Game.checkWallBetweenPLayer(this.posX + (this.width >> 1), this.posY, this.height, this.width)) {
                this.Attack();
            } else {
                this.state = 0;
                this.wasApunting = false;
                this.tiempoApunting = 0;
            }
        }
    }

    private void Attack() {
        this.wasApunting = true;
        if (Math.abs(Player.getX() - this.posX) > this.meleeAttackDistance) {
            switch (this.state) {
                case 0: {
                    this.state = 1;
                    break;
                }
                case 2: {
                    if (Player.isDead() || (int)System.currentTimeMillis() - this.time <= this.actionDelay) break;
                    this.time = (int)System.currentTimeMillis();
                    for (int i = 0; i < this.bulletPool.length; ++i) {
                        if (this.bulletPool[i].isAlive()) continue;
                        if (this.facingRight) {
                            this.bulletPool[i].setPosX(this.posX + 56 + 0);
                            this.bulletPool[i].setPosY(this.posY + 16 - 0);
                        } else {
                            this.bulletPool[i].setPosX(this.posX - 16 - 0);
                            this.bulletPool[i].setPosY(this.posY + 16 - 0);
                        }
                        this.bulletPool[i].setDirection(this.facingRight);
                        this.bulletPool[i].setAlive(true);
                        break;
                    }
                    this.state = 3;
                }
            }
        } else if (Player.getY() + Player.getHeight() > this.posY && Player.getY() < this.posY + this.height && (int)System.currentTimeMillis() - this.time > this.actionDelay) {
            this.state = 4;
        }
    }

    private boolean PlayerSight() {
        if (Player.isPlayerJumping()) {
            if (this.facingRight) {
                return Player.getX() < this.posX + this.shootAttackDistance && Player.getX() > this.posX - (this.shootAttackDistance >> 1) && Player.getY() + Player.getHeight() > this.posY - (this.height >> 1) && Player.getY() < this.posY + this.height;
            }
            return Player.getX() > this.posX - this.shootAttackDistance && Player.getX() < this.posX + (this.shootAttackDistance >> 1) && Player.getY() + Player.getHeight() > this.posY - (this.height >> 1) && Player.getY() < this.posY + this.height;
        }
        if (this.facingRight) {
            return Player.getX() < this.posX + this.shootAttackDistance && Player.getX() > this.posX - (this.shootAttackDistance >> 1) && Player.getY() + Player.getHeight() > this.posY && Player.getY() < this.posY + this.height;
        }
        return Player.getX() > this.posX - this.shootAttackDistance && Player.getX() < this.posX + (this.shootAttackDistance >> 1) && Player.getY() + Player.getHeight() > this.posY && Player.getY() < this.posY + this.height;
    }

    private boolean checkCollision() {
        if (this.posX < Player.getX() + Player.getWidth() + (Player.getWidth() >> 1) && this.posX + this.width > Player.getX() - (Player.getWidth() >> 1) && this.posY < Player.getY() + (Player.getHeight() >> 2) && this.posY + this.height > Player.getY() + (Player.getHeight() >> 2)) {
            if (this.posX + (this.getWidth() >> 1) > Player.getX() + (Player.getWidth() >> 1)) {
                return Player.getOrientation();
            }
            return !Player.getOrientation();
        }
        return false;
    }

    private void CheckAnimation() {
        switch (this.state) {
            case 0: {
                if (this.enemySprite.getAnimation() == 0) break;
                this.enemySprite.setAnimation(0, true);
                break;
            }
            case 1: {
                if (this.enemySprite.getAnimation() != 1) {
                    this.enemySprite.setAnimation(1, false);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.state = 2;
                break;
            }
            case 2: {
                if (this.enemySprite.getAnimation() == 2) break;
                this.enemySprite.setAnimation(2, true);
                break;
            }
            case 3: {
                if (this.enemySprite.getAnimation() != 3) {
                    this.enemySprite.setAnimation(3, false);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.time = (int)System.currentTimeMillis();
                this.state = 2;
                break;
            }
            case 4: {
                if (this.enemySprite.getAnimation() != 4) {
                    this.enemySprite.setAnimation(4, false);
                }
                if (this.enemySprite.getCurrentFrame() == 4) {
                    this.attackPlayer(this.strength);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.time = (int)System.currentTimeMillis();
                this.state = 0;
                break;
            }
            case 5: {
                if (this.enemySprite.getAnimation() != 5) {
                    this.enemySprite.setAnimation(5, false);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.state = 0;
                break;
            }
            case 6: {
                if (this.enemySprite.getAnimation() != 6) {
                    this.enemySprite.setAnimation(6, false);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.blinkTimer = (int)((long)this.blinkTimer + SP.dt);
                if (SP.isFastDevice) {
                    boolean bl = this.blink = !this.blink;
                }
                if (this.blinkTimer <= 800) break;
                this.alive = false;
            }
        }
    }

    private void Flip() {
        if (Player.getX() > this.posX && !this.facingRight) {
            this.enemySprite.setSpriteOrientation((byte)0);
            this.facingRight = true;
        } else if (Player.getX() < this.posX && this.facingRight) {
            this.enemySprite.setSpriteOrientation((byte)1);
            this.facingRight = false;
        }
    }

    public void paint(Graphics g) {
        this.enemySprite.setDrawPosition(this.posX + (this.width >> 1) - Game.getScrollX() + this.m_iHittedExtraX, this.posY + this.height - Game.getScrollY());
        if (this.blink) {
            this.enemySprite.drawFrame(g);
        }
    }

    public void paintBullet(Graphics g) {
        for (int i = 0; i < this.bulletPool.length; ++i) {
            if (!this.bulletPool[i].isAlive()) continue;
            this.bulletPool[i].paint(g);
        }
    }

    public void SubstractHealth(int _amount) {
        if (this.health > 0) {
            this.health -= _amount;
            this.state = 5;
        }
        if (this.health <= 0) {
            this.health = 0;
            this.state = 6;
        }
    }

    private void HitReceived(int _hitStr) {
        if ((this.facingRight != Player.getOrientation() || Math.abs(Player.getX() - this.getPosX()) < 16) && (this.canPlayerHit() || Player.getAnimation() == 15 && Player.getAnimation() != 13)) {
            if (_hitStr > 0) {
                this.SubstractHealth(_hitStr);
                Game.setQuake(_hitStr * 10);
                Player.colisionFist(_hitStr, true, false);
            }
            this.hitted = true;
            if (this.alive) {
                this.initStopframesByHit(_hitStr);
            }
        }
    }

    private void hitReceivedBigFist(int _hitStr) {
        if (this.canPlayerHit()) {
            if (_hitStr > 0) {
                this.SubstractHealth(_hitStr);
                Game.setQuake(_hitStr * 10);
                Player.colisionFist(_hitStr, true, false);
            }
            this.PushEnemy(8);
            this.hitted = true;
            if (this.alive) {
                this.initStopframesByHit(_hitStr);
            }
        }
    }

    private boolean canPlayerHit() {
        return Player.getX() + Player.getWidth() + (Player.getAttackDistance() << 1) > this.posX && Player.getX() - (Player.getAttackDistance() << 1) < this.posX + this.width && Math.abs(Player.getY() + Player.getHeight() - (this.posY + this.height)) <= Player.getHeight();
    }

    private void CheckPlayerHit() {
        switch (Player.getAnimation()) {
            case 2: 
            case 3: 
            case 4: {
                if (Player.getFrame() != 1) break;
                this.HitReceived(1);
                break;
            }
            case 13: {
                if (Player.getFrame() != 3) break;
                this.HitReceived(3);
                break;
            }
            case 6: {
                if (!this.checkCollision()) break;
                int rnd = Gfx.random(100);
                if (rnd < 70) {
                    this.HitReceived(1);
                    Player.isChuckNorris = true;
                } else if (rnd > 70 && rnd < 80) {
                    this.state = 4;
                    Player.lessLife(this.strength, this.facingRight, true, false);
                }
                Player.patadaAerea = false;
                SP.pressFire = false;
                Player.jumping = false;
            }
        }
        if (Player.getAnimation() == 15) {
            if (Player.getOrientation()) {
                if (this.getPosX() > Player.getX() && this.getPosY() > Player.getY() - Player.getHeight() && this.getPosY() < Player.getY() + Player.getHeight() && Player.getFrame() > 16) {
                    this.SubstractHealth(10);
                    this.PushEnemy(8);
                    this.hitted = true;
                }
            } else if (this.getPosX() < Player.getX() + Player.getWidth() && this.getPosY() > Player.getY() - Player.getHeight() && this.getPosY() < Player.getY() + Player.getHeight() && Player.getFrame() > 16) {
                this.SubstractHealth(10);
                this.PushEnemy(8);
                this.hitted = true;
            }
        }
    }

    private void PushEnemy(int _pushStr) {
        switch (Game.getTileX(this.posX, this.posY, this.width, this.height, !this.facingRight, false)) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                if (this.facingRight) {
                    this.posX -= _pushStr;
                    break;
                }
                this.posX += _pushStr;
            }
        }
    }

    public int getAnimation() {
        return this.state;
    }

    public void setAnimation(int animation) {
        this.state = animation;
    }

    public boolean isFacingRight() {
        return this.facingRight;
    }

    public void setFacingRight(boolean facingRight) {
        this.facingRight = facingRight;
    }

    public int getHealth() {
        return this.health;
    }

    public void setHealth(int health) {
        this.health = health;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getPosX() {
        return this.posX;
    }

    public void setPosX(int posX) {
        this.posX = posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public void setPosY(int posY) {
        this.posY = posY;
    }

    public int getStrength() {
        return this.strength;
    }

    public void setStrength(int strength) {
        this.strength = strength;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getState() {
        return this.state;
    }

    public boolean getNear() {
        if (!this.alive) {
            return false;
        }
        return this.bNearPlayer;
    }

    public boolean isNearPlayer() {
        if (!this.alive) {
            return false;
        }
        if (Math.abs(this.posX - Player.getX()) < 240 && Math.abs(this.posY - Player.getY()) < 320 + this.getHeight()) {
            this.bNearPlayer = true;
            return true;
        }
        this.bNearPlayer = false;
        return false;
    }

    public void DeleteMotionWeelderData() {
        try {
            this.enemySprite.unloadPoolImage();
            this.enemySprite.unloadSpriteData();
            this.enemySprite = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void attackPlayer(int _strong) {
        if (this.state == 4 && this.posX < Player.getX() + Player.getWidth() + Player.getWidth() && this.posX + this.width > Player.getX() - (Player.getWidth() >> 1) && Player.getY() + Player.getHeight() > this.posY && Player.getY() < this.posY + this.height && Player.getAnimation() != 2 && Player.getAnimation() != 3 && Player.getAnimation() != 4 && Player.getAnimation() != 6 && Player.getAnimation() != 13 && Player.getAnimation() != 15 && Player.getAnimation() != 5) {
            Player.lessLife(_strong, this.facingRight, false, false);
        }
    }
}

