/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.finalkombat2.trampas;

import com.kitmaker.finalkombat2.Game;
import com.kitmaker.finalkombat2.Gfx;
import com.kitmaker.finalkombat2.Player;
import javax.microedition.lcdui.Graphics;

public class Sierra {
    private int strength = 8;
    private int posX;
    private int posY;
    private int width = Gfx.sierra.getWidth();
    private int height = Gfx.sierra.getHeight();
    private int typeOfMovement;
    private boolean facingUp;
    private int moveSpeed;
    private boolean bNearPlayer;
    private final int HORIZONTAL;
    private final int VERTICAL_LEFT;
    private final int VERTICAL_RIGHT;
    private final int HORIZONTAL_UP;

    public Sierra(int _posX, int _posY, int _direction) {
        this.HORIZONTAL = 0;
        this.VERTICAL_LEFT = 1;
        this.VERTICAL_RIGHT = 2;
        this.HORIZONTAL_UP = 3;
        this.posX = _posX;
        if (_direction == 2) {
            this.posX = _posX + 32 - this.width;
        }
        this.posY = _posY - this.height + 32;
        this.facingUp = true;
        this.moveSpeed = 2;
        this.typeOfMovement = _direction;
    }

    public void updateIA() {
        if (!Player.isInmune()) {
            this.attackPlayer(this.strength);
        }
        switch (this.typeOfMovement) {
            case 0: {
                if (Game.isPlattform(Game.getTileX(this.posX, this.posY, this.width, this.height, this.facingUp, true))) {
                    this.Move();
                } else {
                    this.Flip();
                }
                if (!Game.isWall(Game.getTileX(this.posX, this.posY - 32, this.width, this.height, this.facingUp, true))) break;
                this.Flip();
                break;
            }
            case 1: {
                switch (Game.getTileY(this.posX - 32, this.posY, this.width, this.height, this.facingUp)) {
                    case 0: 
                    case 15: 
                    case 16: 
                    case 17: {
                        this.Flip();
                        break;
                    }
                    default: {
                        this.Move();
                    }
                }
                switch (Game.getTileY(this.posX, this.posY, this.width, this.height, this.facingUp)) {
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        this.Flip();
                    }
                }
                break;
            }
            case 2: {
                switch (Game.getTileY(this.posX + 32, this.posY + 8, this.width, this.height, this.facingUp)) {
                    case 0: 
                    case 15: 
                    case 16: 
                    case 17: {
                        this.Flip();
                        break;
                    }
                    default: {
                        this.Move();
                    }
                }
                switch (Game.getTileY(this.posX, this.posY + 8, this.width, this.height, this.facingUp)) {
                    case 2: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        this.Flip();
                    }
                }
                break;
            }
            case 3: {
                if (Game.isPlattform(Game.getTileXSierraUp(this.posX, this.posY - 64, this.width, this.height, this.facingUp))) {
                    this.Move();
                } else {
                    this.Flip();
                }
                if (!Game.isWall(Game.getTileX(this.posX, this.posY - 32, this.width, this.height, this.facingUp, true))) break;
                this.Flip();
            }
        }
    }

    private void Move() {
        switch (this.typeOfMovement) {
            case 0: 
            case 3: {
                if (this.facingUp) {
                    this.posX += this.moveSpeed;
                    break;
                }
                this.posX -= this.moveSpeed;
                break;
            }
            case 1: 
            case 2: {
                if (this.facingUp) {
                    this.posY -= this.moveSpeed;
                    break;
                }
                this.posY += this.moveSpeed;
            }
        }
    }

    private void Flip() {
        this.facingUp = !this.facingUp;
    }

    public void paint(Graphics g) {
        g.setColor(0, 255, 0);
        switch (this.typeOfMovement) {
            case 0: {
                g.setClip(this.posX - Game.getScrollX(), this.posY + 4 - Game.getScrollY(), this.width, this.height);
                Gfx.sierra.setPosition(this.posX - Game.getScrollX(), this.posY + (this.height >> 1) + 4 - Game.getScrollY());
                Gfx.sierra.paint(g);
                g.setClip(0, 0, 240, 320);
                break;
            }
            case 1: {
                g.setClip(this.posX - Game.getScrollX(), this.posY - Game.getScrollY(), this.width, this.height);
                Gfx.sierra.setPosition(this.posX - (this.width >> 1) - Game.getScrollX(), this.posY - Game.getScrollY());
                Gfx.sierra.paint(g);
                g.setClip(0, 0, 240, 320);
                break;
            }
            case 2: {
                g.setClip(this.posX - Game.getScrollX(), this.posY - Game.getScrollY(), this.width, this.height);
                Gfx.sierra.setPosition(this.posX + (this.width >> 1) - Game.getScrollX(), this.posY - Game.getScrollY());
                Gfx.sierra.paint(g);
                g.setClip(0, 0, 240, 320);
                break;
            }
            case 3: {
                g.setClip(this.posX - Game.getScrollX(), this.posY - Game.getScrollY(), this.width, this.height);
                Gfx.sierra.setPosition(this.posX - Game.getScrollX(), this.posY + (this.height >> 1) - 32 - Game.getScrollY());
                Gfx.sierra.paint(g);
                g.setClip(0, 0, 240, 320);
            }
        }
    }

    public boolean isFacingRight() {
        return this.facingUp;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMoveSpeed() {
        return this.moveSpeed;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getStrength() {
        return this.strength;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean getNear() {
        return this.bNearPlayer;
    }

    public boolean isNearPlayer() {
        if (Math.abs(this.posX - Player.getX()) < 240 && Math.abs(this.posY - Player.getY()) < 240) {
            this.bNearPlayer = true;
            return true;
        }
        this.bNearPlayer = false;
        return false;
    }

    private void attackPlayer(int _strong) {
        if (Math.abs(this.posX - Player.getX()) < Player.getWidth() && Math.abs(this.posY - Player.getY()) < Player.getHeight()) {
            switch (this.typeOfMovement) {
                case 0: {
                    if (Player.getY() + Player.getHeight() + Player.getAceleration() < this.posY + (this.getHeight() >> 1) || Player.getY() >= this.posY + this.getHeight()) break;
                    boolean direction = false;
                    direction = this.posX + (this.getWidth() >> 1) < Player.getX() + (Player.getWidth() >> 1);
                    if (this.posY + this.getHeight() == Player.getY() + Player.getHeight() && Player.getAnimation() != 5) {
                        Player.lessLife(_strong, direction, false, false);
                    } else {
                        Player.lessLife(_strong, direction, true, false);
                    }
                    if (Player.isInmune()) break;
                    Game.setQuake(this.strength);
                    break;
                }
                case 3: {
                    if (Player.getY() >= this.posY + (this.getHeight() >> 1)) break;
                    boolean direction = false;
                    direction = this.posX + (this.getWidth() >> 1) < Player.getX() + (Player.getWidth() >> 1);
                    if (this.posY + this.getHeight() == Player.getY() + Player.getHeight() && Player.getAnimation() != 5) {
                        Player.lessLife(_strong, direction, false, false);
                    } else {
                        Player.lessLife(_strong, direction, true, false);
                    }
                    if (Player.isInmune()) break;
                    Game.setQuake(this.strength);
                    break;
                }
                case 1: {
                    if (Player.getAnimation() == 17 || !Game.colision(this.posX, this.posY, this.getWidth() >> 1, this.getHeight(), Player.getX(), Player.getY(), Player.getWidth(), Player.getHeight())) break;
                    Player.lessLife(_strong, true, true, false);
                    break;
                }
                case 2: {
                    if (Player.getAnimation() == 17 || !Game.colision(this.posX + (this.getWidth() >> 1), this.posY, this.getHeight() >> 1, this.getHeight(), Player.getX(), Player.getY(), Player.getWidth(), Player.getHeight())) break;
                    Player.lessLife(_strong, false, true, false);
                }
            }
        }
    }
}

