/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.finalkombat2.trampas;

import com.kitmaker.finalkombat2.Game;
import com.kitmaker.finalkombat2.Gfx;
import com.kitmaker.finalkombat2.Player;
import javax.microedition.lcdui.Graphics;

public class Mina {
    private int strength = 1;
    private int posX;
    private int posY;
    private int width = Gfx.mina.getWidth();
    private int height = Gfx.mina.getHeight();
    private boolean bNearPlayer;
    private int time;
    private int actualFrame = 0;
    private int activationDistanceX;
    private int activationDistanceY;
    private int explodeDistanceX;
    private int explodeDistanceY;
    private int activationTime;
    private int explosionFrame = 0;
    private int explosionWidth;
    private int explosionHeight;
    private boolean alive = true;
    private int state = 0;
    private final int OFF;
    private final int ACTIVE;
    private final int ON;
    private final int EXPLODE;

    public Mina(int _posX, int _posY) {
        this.OFF = 0;
        this.ACTIVE = 1;
        this.ON = 2;
        this.EXPLODE = 3;
        this.posX = _posX + 16 - (this.width >> 1);
        this.posY = _posY + 32 - this.height;
        this.time = (int)System.currentTimeMillis();
        this.activationDistanceX = 64;
        this.activationDistanceY = 64;
        this.explodeDistanceX = 32;
        this.explodeDistanceY = 32;
        this.activationTime = 1000;
        this.explosionWidth = Gfx.explosion.getWidth();
        this.explosionHeight = Gfx.explosion.getHeight();
    }

    public void updateIA() {
        this.CheckPlayerPos();
    }

    public void paint(Graphics g) {
        block0 : switch (this.state) {
            case 0: {
                Gfx.mina.setPosition(this.posX - Game.getScrollX(), this.posY + 4 - Game.getScrollY());
                Gfx.mina.setFrame(1);
                Gfx.mina.paint(g);
                break;
            }
            case 1: {
                Gfx.mina.setPosition(this.posX - Game.getScrollX(), this.posY + 4 - Game.getScrollY());
                Gfx.mina.setFrame(0);
                Gfx.mina.paint(g);
                break;
            }
            case 2: {
                Gfx.mina.setPosition(this.posX - Game.getScrollX(), this.posY + 4 - Game.getScrollY());
                switch (this.actualFrame) {
                    case 0: {
                        this.actualFrame = 1;
                        break;
                    }
                    case 1: {
                        this.actualFrame = 0;
                    }
                }
                Gfx.mina.setFrame(this.actualFrame);
                Gfx.mina.paint(g);
                break;
            }
            case 3: {
                Gfx.explosion.setPosition(this.posX - this.width - Game.getScrollX(), this.posY - (this.explosionHeight >> 1) - Game.getScrollY());
                Gfx.explosion.setFrame(this.explosionFrame);
                Gfx.explosion.paint(g);
                switch (this.explosionFrame) {
                    case 0: {
                        this.explosionFrame = 1;
                        this.attackPlayer(20);
                        break block0;
                    }
                    case 1: {
                        this.explosionFrame = 2;
                        break block0;
                    }
                    case 2: {
                        this.explosionFrame = 3;
                        break block0;
                    }
                    case 3: {
                        this.alive = false;
                    }
                }
            }
        }
    }

    private void CheckPlayerPos() {
        if (this.state != 3 && Math.abs(Player.getX() - this.posX) < this.activationDistanceX && Math.abs(Player.getX() - this.posX) > this.explodeDistanceX && Math.abs(Player.getY() - this.posY) <= this.activationDistanceY && Math.abs(Player.getY() - this.posY) > this.explodeDistanceY) {
            this.state = 1;
        } else if (this.state != 2 && this.state != 3 && Math.abs(Player.getX() - this.posX) < this.explodeDistanceX && Math.abs(Player.getY() - this.posY) <= this.activationDistanceY) {
            this.state = 2;
            this.time = (int)System.currentTimeMillis();
        } else if (this.state != 3 && (Math.abs(Player.getX() - this.posX) > this.explodeDistanceX || Math.abs(Player.getY() + Player.getHeight() - this.posY) > this.height)) {
            this.state = 0;
        }
        if (this.state == 2 && (int)System.currentTimeMillis() - this.time > this.activationTime) {
            this.state = 3;
        }
    }

    public int getHeight() {
        return this.height;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getStrength() {
        return this.strength;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean getNear() {
        if (!this.alive) {
            return this.alive;
        }
        return this.bNearPlayer;
    }

    public boolean isNearPlayer() {
        if (!this.alive) {
            return this.alive;
        }
        if (Math.abs(this.posX - Player.getX()) < 240 && Math.abs(this.posY - Player.getY()) < 320 + this.getHeight()) {
            this.bNearPlayer = true;
            return true;
        }
        this.bNearPlayer = false;
        return false;
    }

    private void attackPlayer(int _strong) {
        if (Math.abs(this.posX - Player.getX()) < Player.getWidth() << 1 && Math.abs(this.posY - Player.getY()) < Player.getHeight() << 1) {
            boolean direction = false;
            direction = this.posX + (this.getWidth() >> 1) < Player.getX() + (Player.getWidth() >> 1);
            Player.lessLife(_strong, direction, true, false);
            Game.setQuake(_strong);
        }
    }
}

