/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.finalkombat2.trampas;

import com.kitmaker.finalkombat2.Game;
import com.kitmaker.finalkombat2.Gfx;
import com.kitmaker.finalkombat2.Player;
import javax.microedition.lcdui.Graphics;

public class Laser {
    private int strength;
    private int posX;
    private int posY;
    private int width;
    private int height;
    private boolean bNearPlayer;
    private int laserLength;
    private int time;
    private int actionDelay;
    private int actualFrame = 0;
    private boolean blinked = true;
    private boolean horizontal = false;
    private boolean permanent = true;
    private int state;
    private final int OFF;
    private final int START;
    private final int ON;

    public Laser(int _posX, int _posY, boolean _permanent, boolean _horizontal) {
        this.OFF = 0;
        this.START = 1;
        this.ON = 2;
        this.permanent = _permanent;
        this.state = this.permanent ? 2 : 0;
        this.horizontal = _horizontal;
        this.strength = 1;
        this.width = Gfx.laser_top.getWidth();
        this.height = Gfx.laser_top.getHeight();
        this.posX = _posX + 16 - (this.width >> 1);
        this.posY = _posY;
        this.laserLength = !this.horizontal ? 32 * Game.getLimitLaserY(this.posX, this.posY, this.width) : 32 * Game.getLimitLaserX(this.posX, this.posY, this.width);
        this.time = (int)System.currentTimeMillis();
        this.actionDelay = 1000;
    }

    public void updateIA() {
        this.LaserOnOff();
    }

    public void paint(Graphics g) {
        switch (this.state) {
            case 0: {
                if (!this.horizontal) {
                    Gfx.laser_top.setFrame(0);
                    Gfx.laser_bottom.setFrame(0);
                    Gfx.laser_top.setPosition(this.posX - Game.getScrollX(), this.posY - Game.getScrollY());
                    Gfx.laser_top.paint(g);
                    Gfx.laser_bottom.setPosition(this.posX - Game.getScrollX(), this.posY - this.height + this.laserLength + 4 - Game.getScrollY());
                    Gfx.laser_bottom.paint(g);
                    break;
                }
                Gfx.laser_left.setFrame(0);
                Gfx.laser_right.setFrame(0);
                Gfx.laser_left.setPosition(this.posX - Game.getScrollX(), this.posY - Game.getScrollY());
                Gfx.laser_left.paint(g);
                Gfx.laser_right.setPosition(this.posX + this.laserLength - this.width - Game.getScrollX(), this.posY - Game.getScrollY());
                Gfx.laser_right.paint(g);
                break;
            }
            case 1: {
                switch (this.actualFrame) {
                    case 0: {
                        this.actualFrame = 1;
                        break;
                    }
                    case 1: {
                        this.actualFrame = 0;
                    }
                }
                if (!this.horizontal) {
                    Gfx.laser_top.setFrame(this.actualFrame);
                    Gfx.laser_bottom.setFrame(this.actualFrame);
                    Gfx.laser_top.setPosition(this.posX - Game.getScrollX(), this.posY - Game.getScrollY());
                    Gfx.laser_top.paint(g);
                    Gfx.laser_bottom.setPosition(this.posX - Game.getScrollX(), this.posY - this.height + this.laserLength + 4 - Game.getScrollY());
                    Gfx.laser_bottom.paint(g);
                    break;
                }
                Gfx.laser_left.setFrame(this.actualFrame);
                Gfx.laser_right.setFrame(this.actualFrame);
                Gfx.laser_left.setPosition(this.posX - Game.getScrollX(), this.posY - Game.getScrollY());
                Gfx.laser_left.paint(g);
                Gfx.laser_right.setPosition(this.posX + this.laserLength - this.width - Game.getScrollX(), this.posY - Game.getScrollY());
                Gfx.laser_right.paint(g);
                break;
            }
            case 2: {
                this.DrawLaser(g);
                if (!this.horizontal) {
                    Gfx.laser_top.setFrame(1);
                    Gfx.laser_bottom.setFrame(1);
                    Gfx.laser_top.setPosition(this.posX - Game.getScrollX(), this.posY - Game.getScrollY());
                    Gfx.laser_top.paint(g);
                    Gfx.laser_bottom.setPosition(this.posX - Game.getScrollX(), this.posY - this.height + this.laserLength + 4 - Game.getScrollY());
                    Gfx.laser_bottom.paint(g);
                    break;
                }
                Gfx.laser_left.setFrame(1);
                Gfx.laser_right.setFrame(1);
                Gfx.laser_left.setPosition(this.posX - Game.getScrollX(), this.posY - Game.getScrollY());
                Gfx.laser_left.paint(g);
                Gfx.laser_right.setPosition(this.posX + this.laserLength - this.width - Game.getScrollX(), this.posY - Game.getScrollY());
                Gfx.laser_right.paint(g);
            }
        }
    }

    private void DrawLaser(Graphics g) {
        g.setColor(255, 0, 0);
        if (!this.horizontal) {
            g.fillRect(this.posX + (this.width >> 1) - (this.width >> 4) - Game.getScrollX(), this.posY - Game.getScrollY(), (this.width >> 3) + (this.width >> 5), this.laserLength);
            if (this.blinked) {
                g.setColor(255, 200, 200);
                g.fillRect(this.posX + (this.width >> 1) - (this.width >> 5) - Game.getScrollX(), this.posY - Game.getScrollY(), this.width >> 4, this.laserLength);
                this.blinked = false;
            } else {
                this.blinked = true;
            }
        } else {
            g.fillRect(this.posX - Game.getScrollX(), this.posY + (this.height >> 1) - (this.height >> 4) - Game.getScrollY(), this.laserLength, (this.height >> 3) + (this.height >> 5));
            if (this.blinked) {
                g.setColor(255, 200, 200);
                g.fillRect(this.posX - Game.getScrollX(), this.posY + (this.height >> 1) - (this.height >> 5) - Game.getScrollY(), this.laserLength, this.height >> 4);
                this.blinked = false;
            } else {
                this.blinked = true;
            }
        }
    }

    private void LaserOnOff() {
        if (!this.permanent && (int)System.currentTimeMillis() - this.time > this.actionDelay) {
            this.time = (int)System.currentTimeMillis();
            switch (this.state) {
                case 0: {
                    this.state = 1;
                    break;
                }
                case 1: {
                    this.state = 2;
                    break;
                }
                case 2: {
                    this.state = 0;
                }
            }
        }
        if (this.state == 2) {
            this.attackPlayer(10);
        }
    }

    public int getHeight() {
        return this.height;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getStrength() {
        return this.strength;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean getNear() {
        return this.bNearPlayer;
    }

    public boolean isNearPlayer() {
        if (Math.abs(this.posX - Player.getX()) < 480 && Math.abs(this.posY - Player.getY()) < 640) {
            this.bNearPlayer = true;
            return true;
        }
        this.bNearPlayer = false;
        return false;
    }

    private void attackPlayer(int _strong) {
        if (!this.horizontal) {
            if (Math.abs(this.posX + (this.width >> 1) - (Player.getX() + (Player.getWidth() >> 1))) < this.width - this.width / 4 && Player.getY() + Player.getHeight() > this.posY && Player.getY() < this.posY + this.laserLength) {
                if (this.permanent) {
                    boolean direction = false;
                    direction = this.posX + (this.getWidth() >> 1) < Player.getX() + (Player.getWidth() >> 1);
                    if (this.permanent && !Player.youMustDie) {
                        Player.youMustDie = true;
                        Player.bufferLife = 0L;
                        Player.inmune = false;
                    }
                    Player.lessLife(_strong, direction, true, false);
                } else if (Player.getAnimation() != 17) {
                    boolean direction = false;
                    direction = this.posX + (this.getWidth() >> 1) < Player.getX() + (Player.getWidth() >> 1);
                    if (this.permanent && !Player.youMustDie) {
                        Player.youMustDie = true;
                        Player.bufferLife = 0L;
                        Player.inmune = false;
                    }
                    Player.lessLife(_strong, direction, true, false);
                }
            }
        } else if (Player.getY() + Player.getHeight() > this.posY + (this.height >> 1) && Player.getY() < this.posY + this.height && Player.getX() + Player.getWidth() > this.posX && Player.getX() < this.posX + this.laserLength && Player.getAnimation() != 17) {
            if (this.permanent && !Player.youMustDie) {
                Player.youMustDie = true;
                Player.bufferLife = 0L;
                Player.inmune = false;
            }
            Player.lessLife(_strong, !Player.getOrientation(), true, false);
        }
    }
}

