/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.boss;

import WelderTools.WeeldSprite;
import com.kitmaker.finalkombat2.Game;
import com.kitmaker.finalkombat2.Gfx;
import com.kitmaker.finalkombat2.Player;
import com.kitmaker.finalkombat2.enemigos.Enemy;
import javax.microedition.lcdui.Graphics;

public class Spider
extends Enemy {
    private int width;
    private int height;
    private int reactionDistanceX;
    private int reactionDistanceY;
    private int initialPosX;
    private int initialPosY;
    private int groundPosY;
    private int moveSpeed;
    private int laserLength;
    private int laserWidth;
    private int time;
    private int reaction_time;
    private int phase_state;
    private final int PHASE_START;
    private final int PHASE_PROCESING;
    private final int PHASE_ENDED;
    private boolean blinked = false;
    private int phase;
    private int previous_phase;
    private final int PHASE_A;
    private final int PHASE_B;
    private final int PHASE_C;
    private final int PHASE_D;
    private int state;
    public static final int IDLE = 0;
    public static final int MOVING_LEGS = 1;
    public static final int TWIST_START = 2;
    public static final int TWIST = 3;
    public static final int LASER_START = 4;
    public static final int LASER = 5;
    public static final int HITTED = 6;
    public static final int DEAD = 7;
    private int fixXlaser;
    private String spiderPngPath = "/spider.png";
    private String spiderAnuPath = "/spider.anu";
    private int hitLeftX;
    private int hitCenterX;
    private int hitRightX;
    private int direction = 0;
    private final int LEFT;
    private final int RIGHT;
    private final int CENTER;
    private int loopCount = 0;
    private int twist_phase = 0;
    private final int UP;
    private final int DOWN;
    private final int SEARCH_PLAYER;

    public Spider(int _ID, int _posX, int _posY) {
        this.PHASE_START = 0;
        this.PHASE_PROCESING = 1;
        this.PHASE_ENDED = 2;
        this.PHASE_A = 0;
        this.PHASE_B = 1;
        this.PHASE_C = 2;
        this.PHASE_D = 3;
        this.LEFT = 1;
        this.RIGHT = 2;
        this.CENTER = 0;
        this.UP = 2;
        this.DOWN = 1;
        this.SEARCH_PLAYER = 0;
        this.posX = _posX;
        this.posY = _posY;
        this.width = 64;
        this.height = 32;
        this.state = 0;
        this.health = 4;
        this.hitCenterX = this.GetPivotX() - 32;
        this.hitLeftX = this.hitCenterX - 224;
        this.hitRightX = this.hitCenterX + 224;
        this.initialPosX = this.hitCenterX;
        this.initialPosY = this.posY;
        this.reactionDistanceX = 256;
        this.reactionDistanceY = 160;
        this.enemySprite = new WeeldSprite(_ID, new String[]{this.spiderPngPath, "/fx_01.png", "/fx_03.png"}, this.spiderAnuPath, _posX, _posY, Gfx.totalWeeldSprite);
        this.enemySprite.loadPoolImage();
        this.enemySprite.setAnimation(0, true);
        this.moveSpeed = 3;
        this.reaction_time = 600;
        this.groundPosY = this.initialPosY + 96;
        this.phase = 0;
        this.laserLength = 132;
        this.laserWidth = this.width >> 5;
        this.phase_state = 0;
        this.previous_phase = this.phase = 0;
    }

    public void UpdateIA() {
        this.runStopframesByHit();
        this.enemySprite.update();
        if (this.PlayerIsInBossArea()) {
            this.CheckAnimation();
            if (this.state != 6 && this.state != 7) {
                if (!Player.isDead()) {
                    this.Behavior();
                } else if (this.enemySprite.getAnimation() != 0) {
                    this.enemySprite.setAnimation(0, true);
                }
            }
            if (this.CheckCollisionWithPlayer() && this.state != 6 && this.state != 7) {
                Player.lessLife(18, Player.getOrientation(), true, false);
            }
            this.PlayerHitBoss();
        } else if (this.enemySprite.getAnimation() != 0) {
            this.enemySprite.setAnimation(0, true);
        }
        while (Player.getX() > 1088) {
            Player.moveX(-1);
        }
    }

    private void CheckAnimation() {
        switch (this.state) {
            case 0: {
                if (this.enemySprite.getAnimation() == 0) break;
                this.enemySprite.setAnimation(0, true);
                break;
            }
            case 1: {
                if (this.enemySprite.getAnimation() == 1) break;
                this.enemySprite.setAnimation(1, true);
                break;
            }
            case 2: {
                if (this.enemySprite.getAnimation() != 2) {
                    this.enemySprite.setAnimation(2, false);
                }
                this.MoveUp();
                if (!this.enemySprite.loopFinished()) break;
                this.state = 3;
                break;
            }
            case 3: {
                if (this.enemySprite.getAnimation() == 3) break;
                this.enemySprite.setAnimation(3, true);
                break;
            }
            case 4: {
                if (this.enemySprite.getAnimation() != 4) {
                    this.enemySprite.setAnimation(4, false);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.state = 5;
                break;
            }
            case 5: {
                if (this.enemySprite.getAnimation() == 5) break;
                this.enemySprite.setAnimation(5, true);
                break;
            }
            case 6: {
                if (this.enemySprite.getAnimation() != 6) {
                    this.enemySprite.setAnimation(6, false);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.state = 0;
                break;
            }
            case 7: {
                if (this.enemySprite.getAnimation() != 7) {
                    this.enemySprite.setAnimation(7, false);
                }
                this.MoveDown();
                if (!this.enemySprite.loopFinished() || (int)System.currentTimeMillis() - this.time <= 0) break;
                Game.isInTheGetho = true;
            }
        }
    }

    private void Behavior() {
        switch (this.health) {
            case 4: {
                block7 : switch (this.phase) {
                    case 0: {
                        switch (this.phase_state) {
                            case 0: {
                                if (!this.Reposition()) {
                                    this.direction = 0;
                                    break;
                                }
                                this.phase_state = 1;
                                break;
                            }
                            case 1: {
                                this.PhaseA();
                                break;
                            }
                            case 2: {
                                this.previous_phase = this.phase;
                                this.phase = 3;
                                this.phase_state = 0;
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (this.phase_state) {
                            case 0: {
                                if (!this.Reposition()) {
                                    this.direction = 1;
                                    break block7;
                                }
                                this.phase_state = 1;
                                break block7;
                            }
                            case 1: {
                                this.PhaseD();
                                break block7;
                            }
                            case 2: {
                                this.phase_state = 0;
                                this.previous_phase = this.phase;
                                this.phase = 0;
                            }
                        }
                    }
                }
                break;
            }
            case 3: {
                block21 : switch (this.phase) {
                    case 0: {
                        switch (this.phase_state) {
                            case 0: {
                                if (!this.Reposition()) {
                                    this.direction = 0;
                                    break;
                                }
                                this.phase_state = 1;
                                break;
                            }
                            case 1: {
                                this.PhaseA();
                                break;
                            }
                            case 2: {
                                this.previous_phase = this.phase;
                                this.phase = 1;
                                this.phase_state = 0;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (this.phase_state) {
                            case 0: {
                                if (!this.Reposition()) {
                                    this.loopCount = 0;
                                    this.direction = 1;
                                    break;
                                }
                                this.phase_state = 1;
                                break;
                            }
                            case 1: {
                                this.MoveDown();
                                if (this.loopCount < 4) {
                                    this.PhaseB();
                                    break;
                                }
                                this.phase_state = 2;
                                break;
                            }
                            case 2: {
                                this.phase_state = 0;
                                this.previous_phase = this.phase;
                                this.phase = 3;
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (this.phase_state) {
                            case 0: {
                                if (!this.Reposition()) {
                                    this.direction = 1;
                                    break block21;
                                }
                                this.phase_state = 1;
                                break block21;
                            }
                            case 1: {
                                this.PhaseD();
                                break block21;
                            }
                            case 2: {
                                this.phase_state = 0;
                                this.direction = 0;
                                this.previous_phase = this.phase;
                                this.phase = 0;
                            }
                        }
                    }
                }
                break;
            }
            case 2: {
                block41 : switch (this.phase) {
                    case 0: {
                        switch (this.phase_state) {
                            case 0: {
                                if (!this.Reposition()) {
                                    this.direction = 0;
                                    break;
                                }
                                this.phase_state = 1;
                                break;
                            }
                            case 1: {
                                this.PhaseA();
                                break;
                            }
                            case 2: {
                                if (this.previous_phase == 1) {
                                    this.previous_phase = this.phase;
                                    this.phase = 3;
                                } else {
                                    this.previous_phase = this.phase;
                                    this.phase = 1;
                                }
                                this.phase_state = 0;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (this.phase_state) {
                            case 0: {
                                if (!this.Reposition()) {
                                    this.loopCount = 0;
                                    this.direction = 1;
                                    break;
                                }
                                this.phase_state = 1;
                                break;
                            }
                            case 1: {
                                this.MoveDown();
                                if (this.loopCount < 4) {
                                    this.PhaseB();
                                    break;
                                }
                                this.phase_state = 2;
                                break;
                            }
                            case 2: {
                                this.phase_state = 0;
                                this.previous_phase = this.phase;
                                this.phase = 0;
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (this.phase_state) {
                            case 0: {
                                if (!this.Reposition()) {
                                    this.direction = 1;
                                    break block41;
                                }
                                this.phase_state = 1;
                                break block41;
                            }
                            case 1: {
                                this.PhaseD();
                                break block41;
                            }
                            case 2: {
                                this.phase_state = 0;
                                this.direction = 0;
                                this.previous_phase = this.phase;
                                this.phase = 0;
                            }
                        }
                    }
                }
                break;
            }
            case 1: {
                block61 : switch (this.phase) {
                    case 0: {
                        switch (this.phase_state) {
                            case 0: {
                                if (!this.Reposition()) {
                                    this.direction = 0;
                                    break;
                                }
                                this.phase_state = 1;
                                break;
                            }
                            case 1: {
                                this.PhaseA();
                                break;
                            }
                            case 2: {
                                this.previous_phase = this.phase;
                                this.phase = 1;
                                this.phase_state = 0;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (this.phase_state) {
                            case 0: {
                                if (!this.Reposition()) {
                                    this.loopCount = 0;
                                    this.direction = 1;
                                    break;
                                }
                                this.phase_state = 1;
                                break;
                            }
                            case 1: {
                                this.MoveDown();
                                if (this.loopCount < 4) {
                                    this.PhaseB();
                                    break;
                                }
                                this.phase_state = 2;
                                break;
                            }
                            case 2: {
                                this.phase_state = 0;
                                if (this.previous_phase == 2) {
                                    this.previous_phase = this.phase;
                                    this.phase = 3;
                                    break;
                                }
                                this.previous_phase = this.phase;
                                this.phase = 2;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (this.phase_state) {
                            case 0: {
                                if (!this.Reposition()) {
                                    this.loopCount = 0;
                                    break;
                                }
                                this.phase_state = 1;
                                break;
                            }
                            case 1: {
                                if (this.loopCount < 3) {
                                    this.PhaseC();
                                    break;
                                }
                                this.phase_state = 2;
                                break;
                            }
                            case 2: {
                                this.phase_state = 0;
                                this.previous_phase = this.phase;
                                this.phase = 1;
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (this.phase_state) {
                            case 0: {
                                if (!this.Reposition()) {
                                    this.direction = 1;
                                    break block61;
                                }
                                this.phase_state = 1;
                                break block61;
                            }
                            case 1: {
                                this.PhaseD();
                                break block61;
                            }
                            case 2: {
                                this.phase_state = 0;
                                this.direction = 0;
                                this.previous_phase = this.phase;
                                this.phase = 0;
                            }
                        }
                    }
                }
                break;
            }
            case 0: {
                this.state = 7;
            }
        }
    }

    private void PhaseA() {
        this.state = 1;
        if (this.phase != 0) {
            this.phase = 0;
        }
        switch (this.direction) {
            case 0: {
                if (this.GetPivotX() > this.hitCenterX) {
                    this.MoveUp();
                    this.posX -= this.moveSpeed;
                    break;
                }
                this.MoveDown();
                if (this.posY != this.groundPosY) break;
                this.direction = 1;
                break;
            }
            case 1: {
                if (this.GetPivotX() > this.hitLeftX) {
                    this.MoveUp();
                    this.posX -= this.moveSpeed;
                    break;
                }
                this.MoveDown();
                if (this.posY != this.groundPosY) break;
                this.direction = 2;
                break;
            }
            case 2: {
                if (this.GetPivotX() < this.hitRightX) {
                    this.MoveUp();
                    this.posX += this.moveSpeed;
                    break;
                }
                this.MoveDown();
                if (this.posY != this.groundPosY) break;
                this.direction = 0;
                this.phase_state = 2;
            }
        }
    }

    private void PhaseB() {
        this.state = 1;
        if (this.phase != 1) {
            this.phase = 1;
        }
        switch (this.direction) {
            case 2: {
                if (this.GetPivotX() < this.hitRightX) {
                    this.posX += this.moveSpeed;
                    break;
                }
                ++this.loopCount;
                this.direction = 1;
                break;
            }
            case 1: {
                if (this.GetPivotX() > this.hitLeftX) {
                    this.posX -= this.moveSpeed;
                }
                if (this.GetPivotX() > this.hitLeftX) break;
                this.direction = 2;
                ++this.loopCount;
            }
        }
    }

    private void PhaseC() {
        if (this.phase != 2) {
            this.phase = 2;
        }
        block0 : switch (this.state) {
            default: {
                this.state = 2;
                break;
            }
            case 3: {
                switch (this.twist_phase) {
                    case 0: {
                        this.MoveUp();
                        if (Math.abs(this.GetPivotX() - (Player.getX() + (Player.getWidth() >> 1))) > 12) {
                            this.posX = Gfx.lerp(this.posX, Player.getX(), 12);
                            break block0;
                        }
                        this.twist_phase = 1;
                        this.time = (int)System.currentTimeMillis();
                        break block0;
                    }
                    case 1: {
                        if ((int)System.currentTimeMillis() - this.time <= this.reaction_time) break block0;
                        if (this.posY != this.groundPosY) {
                            this.MoveDown();
                            break block0;
                        }
                        this.twist_phase = 2;
                        break block0;
                    }
                    case 2: {
                        if (this.posY != this.initialPosY) {
                            this.MoveUp();
                            break block0;
                        }
                        ++this.loopCount;
                        this.twist_phase = 0;
                    }
                }
            }
        }
    }

    private void PhaseD() {
        if (this.phase != 3) {
            this.phase = 3;
        }
        block0 : switch (this.direction) {
            case 2: {
                if (this.GetPivotX() < this.hitRightX) {
                    this.posX += this.moveSpeed;
                    break;
                }
                this.direction = 1;
                break;
            }
            case 1: {
                switch (this.state) {
                    default: {
                        this.state = 4;
                        break block0;
                    }
                    case 5: 
                }
                if (this.GetPivotX() > this.hitLeftX) {
                    this.posX = this.moveSpeed / 3 > 0 ? (this.posX -= this.moveSpeed / 3) : --this.posX;
                }
                if (this.GetPivotX() > this.hitLeftX) break;
                this.phase_state = 2;
            }
        }
    }

    public void Paint(Graphics g) {
        if (this.state == 5) {
            this.DrawLaser(g);
        }
        this.enemySprite.setDrawPosition(this.posX + 16 - Game.getScrollX() + this.m_iHittedExtraX, this.posY + 32 - Game.getScrollY());
        this.enemySprite.drawFrame(g);
    }

    private boolean PlayerIsInBossArea() {
        return Math.abs(this.initialPosX - Player.getX()) < this.reactionDistanceX && Math.abs(this.initialPosY - (Player.getY() + Player.getHeight())) <= this.reactionDistanceY;
    }

    private boolean Reposition() {
        this.state = 0;
        if (this.posX != this.hitRightX || this.posY != this.initialPosY) {
            this.posX = Gfx.lerp(this.posX, this.hitRightX, 9);
            this.MoveUp();
            return false;
        }
        return true;
    }

    public void DeleteMotionWeelderData() {
        try {
            this.enemySprite.unloadPoolImage();
            this.enemySprite.unloadSpriteData();
            this.enemySprite = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int GetPivotX() {
        return this.posX + 16 + this.fixXlaser;
    }

    private int GetPivotY() {
        return this.posY;
    }

    private boolean CheckCollisionWithPlayer() {
        if (this.state == 5) {
            return Math.abs(this.GetPivotX() - (Player.getX() + (Player.getWidth() >> 1))) <= this.laserWidth << 2 && Math.abs(this.GetPivotY() - (Player.getY() + (Player.getHeight() >> 1))) < this.laserLength;
        }
        if (this.state == 3) {
            return Math.abs(this.GetPivotX() - (Player.getX() + (Player.getWidth() >> 1))) < this.width >> 1 && Math.abs(this.GetPivotY() - (Player.getY() + (Player.getHeight() >> 1))) < this.height;
        }
        return Math.abs(this.GetPivotX() - (Player.getX() + (Player.getWidth() >> 1))) < (this.width >> 1) + (this.width >> 2) && Math.abs(this.GetPivotY() - (Player.getY() + (Player.getHeight() >> 1))) < (this.height >> 1) + (this.height >> 2);
    }

    private void PlayerHitBoss() {
        if (this.m_iHittedCount < Player.ms_lPlayeHitCount && this.state == 5 && Math.abs(this.GetPivotX() - (Player.getX() + (Player.getWidth() >> 1))) < (this.width >> 1) + (this.width >> 2) && Math.abs(this.GetPivotY() - (Player.getY() + (Player.getHeight() >> 1))) < (this.height >> 1) + this.height && Player.getAnimation() == 6) {
            this.phase = 0;
            this.previous_phase = -1;
            this.phase_state = 0;
            this.SubstractHealth(1);
            return;
        }
    }

    private void SubstractHealth(int amount) {
        this.health -= amount;
        Player.colisionFist(amount, true, true);
        Game.setQuake(35);
        if (this.health > 0) {
            this.state = 6;
        } else {
            this.isDead = true;
            this.time = (int)System.currentTimeMillis();
            Game.time = (int)System.currentTimeMillis();
            this.state = 7;
        }
        this.initStopframesByHit(amount);
    }

    private void MoveUp() {
        this.posY = this.state == 3 ? Gfx.lerp(this.posY, this.initialPosY, 10) : Gfx.lerp(this.posY, this.initialPosY, 16);
    }

    private void MoveDown() {
        this.posY = this.state == 3 ? Gfx.lerp(this.posY, this.groundPosY, 16) : Gfx.lerp(this.posY, this.groundPosY, 10);
    }

    private void DrawLaser(Graphics g) {
        g.setColor(255, 0, 0);
        g.fillRect(this.GetPivotX() + this.laserWidth / 3 - this.laserWidth - Game.getScrollX(), this.GetPivotY() - Game.getScrollY(), this.laserWidth << 1, this.laserLength);
        if (this.blinked) {
            g.setColor(255, 200, 200);
            g.fillRect(this.GetPivotX() - Game.getScrollX(), this.GetPivotY() - Game.getScrollY(), this.laserWidth >> 1, this.laserLength);
            this.blinked = false;
        } else {
            this.blinked = true;
        }
    }
}

