/*
 * Decompiled with CFR 0.152.
 */
package org.kson.me;

import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.kson.me.KSONException;
import org.kson.me.KSONObject;
import org.kson.me.KSONTokener;

public class KSONArray {
    private Vector myArrayList;

    public KSONArray() {
        this.myArrayList = new Vector();
    }

    public KSONArray(KSONTokener x) throws KSONException {
        this();
        if (x.nextClean() != '[') {
            throw x.syntaxError("A JSONArray text must start with '['");
        }
        if (x.nextClean() == ']') {
            return;
        }
        x.back();
        block4: while (true) {
            if (x.nextClean() == ',') {
                x.back();
                this.myArrayList.addElement(null);
            } else {
                x.back();
                this.myArrayList.addElement(x.nextValue());
            }
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == ']') {
                        return;
                    }
                    x.back();
                    continue block4;
                }
                case ']': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or ']'");
    }

    public KSONArray(String string) throws KSONException {
        this(new KSONTokener(string));
    }

    public KSONArray(Vector collection) {
        if (collection == null) {
            this.myArrayList = new Vector();
        } else {
            int size = collection.size();
            this.myArrayList = new Vector(size);
            for (int i = 0; i < size; ++i) {
                this.myArrayList.addElement(collection.elementAt(i));
            }
        }
    }

    public Object get(int index) throws KSONException {
        Object o = this.opt(index);
        if (o == null) {
            throw new KSONException("JSONArray[" + index + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(int index) throws KSONException {
        Object o = this.get(index);
        if (o.equals(KSONObject.FALSE) || o instanceof String && ((String)o).toLowerCase().equals("false")) {
            return false;
        }
        if (o.equals(KSONObject.TRUE) || o instanceof String && ((String)o).toLowerCase().equals("true")) {
            return true;
        }
        throw new KSONException("JSONArray[" + index + "] is not a Boolean.");
    }

    public KSONArray getJSONArray(int index) throws KSONException {
        Object o = this.get(index);
        if (o instanceof KSONArray) {
            return (KSONArray)o;
        }
        throw new KSONException("JSONArray[" + index + "] is not a JSONArray.");
    }

    public KSONObject getJSONObject(int index) throws KSONException {
        Object o = this.get(index);
        if (o instanceof KSONObject) {
            return (KSONObject)o;
        }
        throw new KSONException("JSONArray[" + index + "] is not a JSONObject.");
    }

    public String getString(int index) throws KSONException {
        return this.get(index).toString();
    }

    public boolean isNull(int index) {
        return KSONObject.NULL.equals(this.opt(index));
    }

    public String join(String separator) throws KSONException {
        int len = this.length();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(KSONObject.valueToString(this.myArrayList.elementAt(i)));
        }
        return sb.toString();
    }

    public int length() {
        return this.myArrayList.size();
    }

    public Object opt(int index) {
        return index < 0 || index >= this.length() ? null : this.myArrayList.elementAt(index);
    }

    public boolean optBoolean(int index) {
        return this.optBoolean(index, false);
    }

    public boolean optBoolean(int index, boolean defaultValue) {
        try {
            return this.getBoolean(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public KSONArray optJSONArray(int index) {
        Object o = this.opt(index);
        return o instanceof KSONArray ? (KSONArray)o : null;
    }

    public KSONObject optJSONObject(int index) {
        Object o = this.opt(index);
        return o instanceof KSONObject ? (KSONObject)o : null;
    }

    public String optString(int index) {
        return this.optString(index, "");
    }

    public String optString(int index, String defaultValue) {
        Object o = this.opt(index);
        return o != null ? o.toString() : defaultValue;
    }

    public KSONArray put(boolean value) {
        this.put(value ? KSONObject.TRUE : KSONObject.FALSE);
        return this;
    }

    public KSONArray put(Vector value) {
        this.put(new KSONArray(value));
        return this;
    }

    public KSONArray put(int value) {
        this.put(new Integer(value));
        return this;
    }

    public KSONArray put(long value) {
        this.put(new Long(value));
        return this;
    }

    public KSONArray put(Object value) {
        this.myArrayList.addElement(value);
        return this;
    }

    public KSONArray put(int index, boolean value) throws KSONException {
        this.put(index, value ? KSONObject.TRUE : KSONObject.FALSE);
        return this;
    }

    public KSONArray put(int index, Vector value) throws KSONException {
        this.put(index, new KSONArray(value));
        return this;
    }

    public KSONArray put(int index, int value) throws KSONException {
        this.put(index, new Integer(value));
        return this;
    }

    public KSONArray put(int index, long value) throws KSONException {
        this.put(index, new Long(value));
        return this;
    }

    public KSONArray put(int index, Object value) throws KSONException {
        KSONObject.testValidity(value);
        if (index < 0) {
            throw new KSONException("JSONArray[" + index + "] not found.");
        }
        if (index < this.length()) {
            this.myArrayList.setElementAt(value, index);
        } else {
            while (index != this.length()) {
                this.put(KSONObject.NULL);
            }
            this.put(value);
        }
        return this;
    }

    public KSONObject toJSONObject(KSONArray names) throws KSONException {
        if (names == null || names.length() == 0 || this.length() == 0) {
            return null;
        }
        KSONObject jo = new KSONObject();
        for (int i = 0; i < names.length(); ++i) {
            jo.put(names.getString(i), this.opt(i));
        }
        return jo;
    }

    public String toString() {
        try {
            return '[' + this.join(",") + ']';
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString(int indentFactor) throws KSONException {
        return this.toString(indentFactor, 0);
    }

    String toString(int indentFactor, int indent) throws KSONException {
        int len = this.length();
        if (len == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer("[");
        if (len == 1) {
            sb.append(KSONObject.valueToString(this.myArrayList.elementAt(0), indentFactor, indent));
        } else {
            int i;
            int newindent = indent + indentFactor;
            sb.append('\n');
            for (i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(",\n");
                }
                for (int j = 0; j < newindent; ++j) {
                    sb.append(' ');
                }
                sb.append(KSONObject.valueToString(this.myArrayList.elementAt(i), indentFactor, newindent));
            }
            sb.append('\n');
            for (i = 0; i < indent; ++i) {
                sb.append(' ');
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public Writer write(Writer writer) throws KSONException {
        try {
            boolean b = false;
            int len = this.length();
            writer.write(91);
            for (int i = 0; i < len; ++i) {
                Object v;
                if (b) {
                    writer.write(44);
                }
                if ((v = this.myArrayList.elementAt(i)) instanceof KSONObject) {
                    ((KSONObject)v).write(writer);
                } else if (v instanceof KSONArray) {
                    ((KSONArray)v).write(writer);
                } else {
                    writer.write(KSONObject.valueToString(v));
                }
                b = true;
            }
            writer.write(93);
            return writer;
        }
        catch (IOException e) {
            throw new KSONException(e);
        }
    }
}

