/*
 * Decompiled with CFR 0.152.
 */
package kitmaker.online.score.api;

public class KitConException
extends Throwable {
    private int errorCode;
    public static final KitConnectionTypeValue DEMAND_INSTALL_CODE = new KitConnectionTypeValue(1);
    public static final KitConnectionTypeValue SUBMIT_SCORE = new KitConnectionTypeValue(2);
    public static final KitConnectionTypeValue REQUEST_RANKING = new KitConnectionTypeValue(3);
    public static final KitConnectionTypeValue SUBMIT_SCORE_DETAILS = new KitConnectionTypeValue(4);
    public static final KitConnectionTypeValue REQUEST_RANKING_DETAILS = new KitConnectionTypeValue(5);
    public static final KitConnectionTypeValue SYSTEM_PROBLEM = new KitConnectionTypeValue(0);

    public KitConException() {
        this.errorCode = -1;
    }

    public KitConException(KitConnectionTypeValue connection, String code) {
        try {
            int low = Integer.parseInt(code);
            this.errorCode = connection.connectionType() * 100 + low;
        }
        catch (NumberFormatException e) {
            this.errorCode = -1;
        }
    }

    public void printStackTrace() {
        System.err.println(this.getError() + "\tCode: " + this.errorCode);
        super.printStackTrace();
    }

    public String getMessage() {
        return this.getError();
    }

    private String getError() {
        switch (this.errorCode) {
            case 0: {
                return "Tool still not initiated. Did you forget to call 'KitHttpManager.init(KitScore, MIDlet)";
            }
            case 1: {
                return "Tried to initiate the KitHttpManager class with a null object that implements a KitScore interface.";
            }
            case 2: {
                return "Tried to initiate the KitHttpManager class with a null MIDlet object.";
            }
            case 3: {
                return "Warning, no family value found. Check 'scr.dat' file. Used 'nofamily' as default value.";
            }
            case 4: {
                return "Configuration file not found. Have you updated build-impl.xml in order to generate the src.dat file during compilation?";
            }
            case 5: {
                return "Warning, defult configuration found. The gameCode was setup to 'test_000'. Remember to modify this value when publishing the game.";
            }
            case 6: {
                return "Incoherent configuration. Mode 'RELEASED' and game code 'test_000' found. Check the project configuration parameters. Use 'RELEASED' mode only in publishing phase.";
            }
            case 101: 
            case 202: 
            case 302: {
                return "Empty gamecode parameter.";
            }
            case 102: 
            case 203: 
            case 303: {
                return "Error in gamecode format. Game code must be integer.";
            }
            case 103: {
                return "Empty gameversion parameter.";
            }
            case 104: 
            case 204: {
                return "Empty language parameter.";
            }
            case 105: 
            case 205: {
                return "Empty totalgames parameter.";
            }
            case 106: {
                return "Empty family parameter.";
            }
            case 108: {
                return "Invalid first execution date (yyyy-mm-dd hh:mm:ss).";
            }
            case 109: {
                return "Invalid JSON additional data.";
            }
            case 110: 
            case 210: {
                return "Database error.";
            }
            case 201: 
            case 301: {
                return "Empty installationcode parameter.";
            }
            case 206: {
                return "Empty name parameter.";
            }
            case 207: {
                return "Error in avatar format. Avatar must be integer.";
            }
            case 208: {
                return "Empty bestscoretable1 parameter.";
            }
            case 209: 
            case 309: {
                return "Database error. Installation code does not exist.";
            }
            case 304: {
                return "Empty results parameter";
            }
            case 305: {
                return "Error in gettable1 format. Its value must be 'yes' or 'no'.";
            }
            case 306: {
                return "Error in gettable2 format. Its value must be 'yes' or 'no'.";
            }
            case 307: {
                return "Error in gettable3 format. Its value must be 'yes' or 'no'.";
            }
            case 308: {
                return "Error in getcurrentposition format. Its value must be 'yes' or 'no'.";
            }
            case 310: {
                return "Error in gettable4 format. Its value must be 'yes' or 'no'.";
            }
            case 311: {
                return "Error in gettable5 format. Its value must be 'yes' or 'no'.";
            }
            case 400: {
                return "Submitting configuration information not found. Did you forget to prepare the submitting score process?";
            }
            case 500: {
                return "Requesting configuration information not found. Did you forget to prepare the requesting ranking process?";
            }
        }
        return "Unknown error";
    }

    public static class KitConnectionTypeValue {
        private int code;

        private KitConnectionTypeValue() {
            this.code = 0;
        }

        private KitConnectionTypeValue(int newLang) {
            this.code = newLang;
        }

        private KitConnectionTypeValue(KitConnectionTypeValue otherCode) {
            this.code = otherCode.code;
        }

        private void assign(KitConnectionTypeValue otherCode) {
            this.code = otherCode.code;
        }

        private int connectionType() {
            return this.code;
        }
    }
}

