/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.finalkombat2.enemigos;

import WelderTools.WeeldSprite;
import com.kitmaker.finalkombat2.Game;
import com.kitmaker.finalkombat2.Gfx;
import com.kitmaker.finalkombat2.Player;
import javax.microedition.lcdui.Graphics;

public class Bomba {
    private int posX;
    private int posY;
    private int width = 32;
    private int height = 32;
    private int state = 0;
    private int idRecolected;
    private boolean bNearPlayer = false;
    private final int ACTIVE;
    private final int INACTIVE;
    private WeeldSprite eBomba;
    private String eBombaPngPath = "/bomba.png";
    private String eBombaAnuPath = "/bomba.anu";

    public Bomba(int _ID, int _posX, int _posY, int _idRecolected, boolean _actived) {
        this.ACTIVE = 0;
        this.INACTIVE = 1;
        this.state = _actived ? 0 : 1;
        this.bNearPlayer = false;
        this.posX = _posX;
        this.posY = _posY - this.height + 32;
        this.eBomba = new WeeldSprite(_ID, new String[]{this.eBombaPngPath, "/fx_02.png"}, this.eBombaAnuPath, _posX, _posY, Gfx.totalWeeldSprite);
        this.eBomba.loadPoolImage();
        this.eBomba.setAnimation(this.state, true);
        this.idRecolected = _idRecolected;
    }

    public void updateIA() {
        switch (this.state) {
            case 0: {
                this.eBomba.update();
                this.isCollision();
                if (this.eBomba.getAnimation() == 0) break;
                this.eBomba.setAnimation(0, true);
                break;
            }
            case 1: {
                if (this.eBomba.getAnimation() == 1) break;
                this.eBomba.setAnimation(1, true);
            }
        }
    }

    public void paint(Graphics g) {
        this.eBomba.setDrawPosition(this.posX + (this.width >> 1) - Game.getScrollX(), this.posY + this.height - Game.getScrollY() + 4);
        this.eBomba.drawFrame(g);
    }

    public int getAnimation() {
        return this.state;
    }

    public void setAnimation(int animation) {
        this.state = animation;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getPosX() {
        return this.posX;
    }

    public void setPosX(int posX) {
        this.posX = posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public void setPosY(int posY) {
        this.posY = posY;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getState() {
        return this.state;
    }

    public boolean getNear() {
        return this.bNearPlayer;
    }

    public boolean isNearPlayer() {
        if (Math.abs(this.posX - Player.getX()) < 240 && Math.abs(this.posY - Player.getY()) < 320 + this.getHeight()) {
            this.bNearPlayer = true;
            return true;
        }
        this.bNearPlayer = false;
        return false;
    }

    public void isCollision() {
        if (Game.colision(this.posX, this.posY, this.width, this.height, Player.getX(), Player.getY(), Player.getWidth(), Player.getHeight())) {
            this.state = 1;
            ++Game.numberBombs;
            this.saveBombs();
        }
    }

    public void DeleteMotionWeelderData() {
        try {
            this.eBomba.unloadPoolImage();
            this.eBomba.unloadSpriteData();
            this.eBomba = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getIdPosition(int _id, int _numBombsLevel) {
        int numBomb = _numBombsLevel;
        if (numBomb == 0) {
            numBomb = 10000;
        }
        switch (_id) {
            case 0: {
                numBomb += 1000;
                break;
            }
            case 1: {
                numBomb += 100;
                break;
            }
            case 2: {
                numBomb += 10;
                break;
            }
            case 3: {
                ++numBomb;
            }
        }
        return numBomb;
    }

    private void saveBombs() {
        Game.bufferBombs = this.getIdPosition(this.idRecolected, Game.bufferBombs);
    }
}

