/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.finalkombat2.enemigos;

import WelderTools.WeeldSprite;
import com.kitmaker.finalkombat2.Game;
import com.kitmaker.finalkombat2.Gfx;
import com.kitmaker.finalkombat2.Player;
import com.kitmaker.finalkombat2.SP;
import com.kitmaker.finalkombat2.enemigos.Enemy;
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class Basico
extends Enemy {
    private int strength;
    private int width;
    private int height;
    private boolean facingRight;
    private int moveSpeed;
    private int state = 0;
    private final int BLOCK;
    private final int WALK;
    private final int HITTED;
    private final int ATTACK;
    private final int IDLE;
    private final int DEAD;
    private final int DEAD_ON_FLOOR;
    private int attackDistance;
    private int sightDistanceX;
    private int sightDistanceY;
    private Random random;
    private int actionDelay;
    private int blockRate;
    private int time;
    private int blinkTimer;
    private boolean blink;
    private boolean alive;
    private int stunnedTime;
    private boolean bNearPlayer;
    private boolean hitted = false;
    private int timeBlockAfterPatadaAerea;
    private boolean forceBlockAnim;
    private final int HIT_PUSH_DISTANCE;
    private String eBasicoPngPath = "/eBasico.png";
    private String eBasicoAnuPath = "/eBasico.anu";
    private int deltaYDead;
    private int aceleration;
    private int posYfloor;
    private boolean isJumpingDown;
    private boolean enemyCanHitAnim;

    public Basico(int _ID, int _posX, int _posY) {
        this.BLOCK = 0;
        this.WALK = 1;
        this.HITTED = 2;
        this.ATTACK = 3;
        this.IDLE = 5;
        this.DEAD = 6;
        this.DEAD_ON_FLOOR = 7;
        this.HIT_PUSH_DISTANCE = 8;
        this.health = 3;
        this.strength = 10;
        this.width = 32;
        this.height = 54;
        this.facingRight = true;
        this.moveSpeed = 2;
        this.attackDistance = 32;
        this.sightDistanceX = 256;
        this.sightDistanceY = 16;
        this.blockRate = 50;
        this.actionDelay = 500;
        this.state = 5;
        this.posX = _posX;
        this.posY = _posY - this.height + 32;
        this.enemySprite = new WeeldSprite(_ID, new String[]{this.eBasicoPngPath, "/fx_01.png"}, this.eBasicoAnuPath, _posX, _posY, Gfx.totalWeeldSprite);
        this.enemySprite.loadPoolImage();
        this.stunnedTime = 150;
        this.blink = true;
        this.alive = true;
        this.timeBlockAfterPatadaAerea = 0;
        this.enemySprite.setAnimation(this.state, true);
        this.time = (int)System.currentTimeMillis();
        if (this.random == null) {
            this.random = new Random();
        }
        this.posYfloor = this.posY;
        this.enemyCanHitAnim = false;
    }

    public void updateIA() {
        this.runStopframesByHit();
        if (this.timeBlockAfterPatadaAerea > 0) {
            this.timeBlockAfterPatadaAerea = (int)((long)this.timeBlockAfterPatadaAerea + SP.dt);
            if (this.timeBlockAfterPatadaAerea > this.actionDelay) {
                this.timeBlockAfterPatadaAerea = 0;
            }
        }
        this.enemySprite.update();
        this.CheckAnimation();
        if (this.state < 6) {
            this.Flip();
            if (!Game.isInTheGetho) {
                this.Behavior();
            } else if (this.enemySprite.getAnimation() != 5) {
                this.enemySprite.setAnimation(5, true);
                this.state = 5;
            }
            if (this.m_iHittedCount < Player.ms_lPlayeHitCount) {
                this.CheckPlayerHit();
            }
        }
    }

    private void Behavior() {
        if (this.state != 3 && this.state != 2) {
            if (Game.isPlattform(Game.getTileX(this.posX, this.posY, this.width, this.height, this.facingRight, false))) {
                if (this.PlayerSight()) {
                    if (this.state != 0 && Math.abs(Player.getX() - this.posX) > this.attackDistance) {
                        this.Walk();
                    } else if (this.posY + this.height >= Player.getY() + Player.getHeight() && this.posY + this.height < Player.getY() + Player.getHeight() + (Player.getHeight() >> 1)) {
                        this.BlockOrAttack();
                    } else {
                        this.Walk();
                    }
                } else {
                    this.state = 5;
                }
            } else if (this.posY + this.height == Player.getY() + Player.getHeight() && Math.abs(this.posX - Player.getX()) < 32) {
                this.BlockOrAttack();
            } else {
                this.state = 5;
            }
        }
    }

    private boolean checkCollision() {
        if (this.posX < Player.getX() + Player.getWidth() + (Player.getWidth() >> 1) && this.posX + this.width > Player.getX() - (Player.getWidth() >> 1) && Player.getY() < this.posY + this.height && Player.getY() + (Player.getHeight() >> 1) > this.posY) {
            if (this.posX + (this.getWidth() >> 1) > Player.getX() + (Player.getWidth() >> 1)) {
                return Player.getOrientation();
            }
            return !Player.getOrientation();
        }
        return false;
    }

    private boolean PlayerSight() {
        return Math.abs(Player.getX() - this.posX) < this.sightDistanceX && Math.abs(Player.getY() + Player.getHeight() - (this.posY + this.height)) < this.sightDistanceY && Player.getY() + Player.getHeight() <= this.posY + this.height;
    }

    private void CheckAnimation() {
        if (this.timeBlockAfterPatadaAerea > 0) {
            this.state = 0;
        }
        switch (this.state) {
            case 0: {
                if (this.enemySprite.getAnimation() == 0) break;
                this.enemySprite.setAnimation(0, false);
                break;
            }
            case 1: {
                if (this.enemySprite.getAnimation() == 1) break;
                this.enemySprite.setAnimation(1, true);
                break;
            }
            case 2: {
                if (this.enemySprite.getAnimation() != 2) {
                    this.enemySprite.setAnimation(2, false);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.state = 5;
                break;
            }
            case 3: {
                if (this.enemySprite.getAnimation() != 3) {
                    this.enemySprite.setAnimation(3, false);
                }
                if (this.enemySprite.getCurrentFrame() >= 1) {
                    this.enemyCanHitAnim = true;
                }
                if (this.state == 3 && this.enemyCanHitAnim) {
                    this.attackPlayer(this.strength);
                }
                if (!this.enemySprite.loopFinished()) break;
                this.state = 5;
                this.enemyCanHitAnim = false;
                break;
            }
            case 6: {
                if (Player.ms_lPlayeStopTime != 0) break;
                if (this.getPosY() <= this.posYfloor) {
                    if (this.enemySprite.getAnimation() != 6) {
                        this.enemySprite.setAnimation(6, false);
                        this.setPosY(this.posY - 2);
                    }
                    this.setPosY(this.posY - this.deltaYDead);
                    if (!this.isJumpingDown) {
                        this.deltaYDead += 2 - this.aceleration;
                        ++this.aceleration;
                        if (this.deltaYDead > 0) break;
                        this.isJumpingDown = true;
                        this.aceleration = 1;
                        break;
                    }
                    this.deltaYDead -= this.aceleration;
                    ++this.aceleration;
                    break;
                }
                this.setPosY(this.posYfloor + 1);
                if (this.enemySprite.getAnimation() != 7) {
                    this.enemySprite.setAnimation(7, false);
                }
                this.blinkTimer = (int)((long)this.blinkTimer + SP.dt);
                if (this.blinkTimer > 1000) {
                    this.blink = SP.isFastDevice ? !this.blink : SP.isModule(SP.isPaintingScreen);
                }
                if (this.blinkTimer <= 1800) break;
                this.alive = false;
                break;
            }
            case 5: {
                if (this.enemySprite.getAnimation() == 5) break;
                this.enemySprite.setAnimation(5, true);
            }
        }
        if (this.hitted && Player.getAnimation() != 6) {
            this.hitted = false;
        }
    }

    private void BlockOrAttack() {
        if ((int)System.currentTimeMillis() - this.time > this.actionDelay) {
            this.time = (int)System.currentTimeMillis();
            if (Math.abs(this.random.nextInt()) % 100 < this.blockRate) {
                this.state = 0;
                this.actionDelay = 2000;
                this.blockRate = 10;
            } else {
                this.state = 3;
                this.actionDelay = 1000;
                this.blockRate = 40;
            }
        } else if (this.state == 1) {
            this.state = 5;
        }
        if (this.state == 3 && this.enemyCanHitAnim) {
            this.attackPlayer(this.strength);
        }
        if (this.state == 0 && (int)System.currentTimeMillis() - this.time > this.actionDelay) {
            this.enemySprite.update();
            if (this.enemySprite.loopFinished()) {
                this.state = 5;
            }
        }
    }

    private void Walk() {
        this.state = 1;
        this.posX = this.facingRight ? (this.posX += this.moveSpeed) : (this.posX -= this.moveSpeed);
    }

    private void Flip() {
        if (Player.getX() > this.posX && !this.facingRight) {
            this.enemySprite.setSpriteOrientation((byte)0);
            this.facingRight = true;
        } else if (Player.getX() < this.posX && this.facingRight) {
            this.enemySprite.setSpriteOrientation((byte)1);
            this.facingRight = false;
        }
    }

    public void paint(Graphics g) {
        if (this.forceBlockAnim) {
            this.enemySprite.setAnimation(0, false);
        }
        this.enemySprite.setDrawPosition(this.posX + (this.width >> 1) - Game.getScrollX() + this.m_iHittedExtraX, this.posY + this.height - Game.getScrollY());
        if (this.blink) {
            this.enemySprite.drawFrame(g);
        }
        this.forceBlockAnim = false;
    }

    public void SubstractHealth(int _amount) {
        if (this.health > 0) {
            this.health -= _amount;
            this.state = 2;
        }
        if (this.health <= 0) {
            this.health = 0;
            this.state = 6;
        }
    }

    private void HitReceived(int _hitStr) {
        if (this.facingRight != Player.getOrientation() && this.canPlayerHit()) {
            if (_hitStr > 0) {
                this.SubstractHealth(_hitStr);
                Game.setQuake(_hitStr * 10);
                Player.colisionFist(_hitStr, true, false);
            }
            this.PushEnemy(8);
            this.hitted = true;
            if (this.alive) {
                this.initStopframesByHit(_hitStr);
            }
        }
    }

    private boolean canPlayerHit() {
        return this.posX + this.width + Player.getAttackDistance() > Player.getX() && this.posX - Player.getAttackDistance() < Player.getX() + Player.getWidth() && Math.abs(Player.getY() + Player.getHeight() - (this.posY + this.height)) < this.height;
    }

    private void PushEnemy(int _pushStr) {
        if (this.state == 2) {
            switch (Game.getTileX(this.posX, this.posY, this.width, this.height, !this.facingRight, false)) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    if (this.facingRight) {
                        this.posX -= _pushStr;
                        break;
                    }
                    this.posX += _pushStr;
                }
            }
        }
    }

    private void CheckPlayerHit() {
        switch (Player.getAnimation()) {
            case 2: 
            case 3: 
            case 4: {
                if (this.facingRight == Player.getOrientation()) break;
                if (this.state == 0 && Player.getAnimation() != 13) {
                    if (Player.getFrame() == 1) {
                        if (Player.getOrientation()) {
                            Player.moveX(-3);
                        } else {
                            Player.moveX(2);
                        }
                    }
                    this.forceBlockAnim = true;
                    return;
                }
                if (Player.getFrame() != 1) break;
                this.HitReceived(1);
                break;
            }
            case 13: {
                if (Player.getFrame() != 3) break;
                this.HitReceived(3);
                if (!this.canPlayerHit()) break;
                this.enemySprite.setAnimation(2, false);
                break;
            }
            case 6: {
                if (!this.checkCollision()) break;
                int rnd = Math.abs(this.random.nextInt()) % 100;
                if (rnd < 70) {
                    if (this.enemySprite.getAnimation() != 0) {
                        this.HitReceived(1);
                    }
                } else {
                    this.state = 0;
                    this.timeBlockAfterPatadaAerea = 1;
                }
                Player.patadaAerea = false;
            }
        }
        if (this.facingRight != Player.getOrientation() && this.canPlayerHit()) {
            if ((Player.getAnimation() == 2 || Player.getAnimation() == 3 || Player.getAnimation() == 4) && Player.getFrame() == 1) {
                this.PushEnemy(2);
            }
            if (Player.getAnimation() == 6) {
                this.PushEnemy(2);
            }
        }
        if (Player.getAnimation() == 15) {
            if (Player.getOrientation()) {
                if (this.getPosY() > Player.getY() - Player.getHeight() && this.getPosY() < Player.getY() + Player.getHeight() && Player.getFrame() > 16 && !this.facingRight) {
                    this.SubstractHealth(10);
                    this.PushEnemy(8);
                    this.hitted = true;
                }
            } else if (this.getPosY() > Player.getY() - Player.getHeight() && this.getPosY() < Player.getY() + Player.getHeight() && Player.getFrame() > 16 && this.facingRight) {
                this.SubstractHealth(10);
                this.PushEnemy(8);
                this.hitted = true;
            }
        }
    }

    public int getAnimation() {
        return this.state;
    }

    public void setAnimation(int animation) {
        this.state = animation;
    }

    public boolean isFacingRight() {
        return this.facingRight;
    }

    public void setFacingRight(boolean facingRight) {
        this.facingRight = facingRight;
    }

    public int getHealth() {
        return this.health;
    }

    public void setHealth(int health) {
        this.health = health;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getMoveSpeed() {
        return this.moveSpeed;
    }

    public void setMoveSpeed(int moveSpeed) {
        this.moveSpeed = moveSpeed;
    }

    public int getPosX() {
        return this.posX;
    }

    public void setPosX(int posX) {
        this.posX = posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public void setPosY(int posY) {
        this.posY = posY;
    }

    public int getStrength() {
        return this.strength;
    }

    public void setStrength(int strength) {
        this.strength = strength;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getState() {
        return this.state;
    }

    public boolean getNear() {
        if (!this.alive) {
            return false;
        }
        return this.bNearPlayer;
    }

    public boolean isNearPlayer() {
        if (!this.alive) {
            return false;
        }
        if (Math.abs(this.posX - Player.getX()) < 240 && Math.abs(this.posY - Player.getY()) < 320 + this.getHeight()) {
            this.bNearPlayer = true;
            return true;
        }
        this.bNearPlayer = false;
        return false;
    }

    public void DeleteMotionWeelderData() {
        try {
            this.enemySprite.unloadPoolImage();
            this.enemySprite.unloadSpriteData();
            this.enemySprite = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void attackPlayer(int _strong) {
        if (this.state == 3 && Math.abs(this.posX - Player.getX()) <= this.attackDistance && Player.getY() + Player.getHeight() > this.posY && Player.getY() < this.posY + this.height) {
            if (Player.getOrientation() != this.facingRight) {
                if (Player.getAnimation() != 2 && Player.getAnimation() != 3 && Player.getAnimation() != 4 && Player.getAnimation() != 6 && Player.getAnimation() != 13 && Player.getAnimation() != 15 && Player.getAnimation() != 5) {
                    Player.lessLife(_strong, this.facingRight, false, false);
                }
            } else {
                Player.lessLife(_strong, this.facingRight, false, false);
            }
        }
    }
}

