/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.finalkombat2;

import com.kitmaker.finalkombat2.ArabicReshaper;
import com.kitmaker.finalkombat2.Define;
import com.kitmaker.finalkombat2.MidletPBSP;
import java.io.DataInputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FntManager {
    static final int FONT_NORMAL = 0;
    static final int FONT_BIG = 1;
    private static final String[] FONT_URL = new String[]{"fnt_normal", "fnt_big"};
    public static final String[] BASE_SIZE = new String[]{"128", "176", "240", "320", "480", "720"};
    public static final byte NUM_FONTS = (byte)FONT_URL.length;
    private static Font[] ms_SystemFont = new Font[NUM_FONTS];
    private static int[][] SYSTEM_FONTS = new int[NUM_FONTS][3];
    private static int[][] SYSTEM_STROKE = new int[NUM_FONTS][];
    private static int[][] SYSTEM_SHADOW = new int[NUM_FONTS][];
    private static final int[] FNTSYS_MASK_SIZE = new int[]{8, 0, 16};
    private static final int[] FNTSYS_MASK_STYLE = new int[]{0, 1, 2};
    private static byte[] FNTSYS_HEIGHT = new byte[NUM_FONTS];
    private static byte[] FNTSYS_BASELI = new byte[NUM_FONTS];
    private static byte[] FNTSYS_MAXHEIGHT = new byte[NUM_FONTS];
    static final byte FNTDATA_X = 0;
    static final byte FNTDATA_W = 1;
    static final byte FNTDATA_Y = 2;
    static final byte FNTDATA_H = 3;
    static final byte FNTDATA_OFFSET_Y = 4;
    static final byte FNTDATA_OFFSET_X = 5;
    static final byte FNTDATA_ADVANCE = 6;
    static final byte NUM_FNTDATA = 7;
    static short[][][] ms_iCharData = new short[NUM_FONTS][][];
    private static byte[][][] FNTGFX_LINE_DATA = new byte[NUM_FONTS][][];
    private static short[][][] FNTGFX_CHARPOS_X = new short[NUM_FONTS][][];
    private static String[] ms_zCharSet = new String[NUM_FONTS];
    private static byte[][] FNTGFX_OFFSET_X = new byte[NUM_FONTS][];
    private static byte[][] FNTGFX_ADVANCE_X = new byte[NUM_FONTS][];
    private static byte[] FNTGFX_HEIGHT = new byte[NUM_FONTS];
    private static byte[] FNTGFX_BASELI = new byte[NUM_FONTS];
    private static byte[] FNTGFX_MAXHEIGHT = new byte[NUM_FONTS];
    private static byte[] FNT_SPACINGX = new byte[NUM_FONTS];
    public static byte[] FNT_HEIGHT = new byte[NUM_FONTS];
    public static byte[] FNT_BASELI = new byte[NUM_FONTS];
    public static byte[] FNT_MAXHEIGHT = new byte[NUM_FONTS];
    public static int FNT_HEIGHT_SYSTEM;
    private static final char[][] APOSTROPHE_LATIN;
    public static final int HCENTER = 1;
    public static final int RIGHT = 8;
    public static final int LEFT = 4;
    public static final int VCENTER = 2;
    public static final int BASELINE = 64;
    public static final int TOP = 16;
    public static final int DELTAMOVE = 128;
    private static Image[][] ms_vFont;
    private static int ms_iApostrophe;
    private static int ms_iApostropheExtraY;
    private static int ms_iApostropheeCaseH;
    private static int[] ms_iLetterHeight;
    private static String textoArabeInvertido;
    static final int SHADOW_PIXELS = 1;
    public static final int FTYPE_SYSTEM = 0;
    public static final int FTYPE_GRAPHIC = 1;
    private static int[] ms_iFontType;
    private static int[] ms_iDefaultFontType;
    private static String[] ms_zDrawRectFontStr;
    public static int ms_iDrawRectFontLines;
    public static int ms_iDrawRectFontLetters;
    private static int ms_iDrawRectChars;
    private static int ms_iDrawRectY;
    private static int arabicSpace;
    private static int lineaInicial;
    private static int altoCajaTexto;
    private static int numeroPagina;
    private static int maxLineas;
    private static int paginasTotales;
    private static boolean checkDFITHTP;
    private static final String ARABIC_TEST1 = "\u0627\u0644\u0645\u0633\u062d!!!!!!!!!!";
    private static final String ARABIC_TEST2 = "!!!!!!!!!!";
    public static final boolean ARABIC_PROPER_SUPPORT;
    public static final boolean ARABIC_SUPPORT;
    public static final boolean BENGAL_SUPPORT;
    public static final boolean RUSSIAN_SUPPORT;

    public static int getNumberLinesInRect(int _iFontID, String[] _iTextArray, int _iBoxWidth) {
        ms_iDrawRectChars = 0;
        ms_iDrawRectFontLines = FntManager.SplitString(_iTextArray, _iBoxWidth, _iFontID);
        int numLinies = 0;
        for (int i = 0; i < ms_zDrawRectFontStr.length && ms_zDrawRectFontStr[i] != null; ++i) {
            ++numLinies;
        }
        return numLinies;
    }

    public static void InitFontManager() {
        for (int i = 0; i < NUM_FONTS; ++i) {
            FntManager.LoadFont(i);
        }
        FntManager.GetHeightSystemFont();
    }

    public static void DeleteFont(int _iIndex) {
        FntManager.ms_vFont[_iIndex][0] = null;
        System.gc();
        FntManager.ms_zCharSet[_iIndex] = null;
        FntManager.FNTGFX_CHARPOS_X[_iIndex] = null;
        FntManager.FNTGFX_LINE_DATA[_iIndex] = null;
        System.gc();
    }

    public static void LoadFont(int _iIndex) {
        int j;
        boolean bGfxFontLoaded = FntManager.LoadGraphicFont(_iIndex);
        FntManager.ms_iFontType[_iIndex] = 1;
        FntManager.ms_iDefaultFontType[_iIndex] = 1;
        if (!bGfxFontLoaded) {
            bGfxFontLoaded = FntManager.LoadSystemFont(_iIndex);
            FntManager.ms_iFontType[_iIndex] = 0;
            FntManager.ms_iDefaultFontType[_iIndex] = 0;
            if (!bGfxFontLoaded) {
                // empty if block
            }
        }
        int iFace = 0;
        FntManager.ms_SystemFont[_iIndex] = Font.getFont((int)iFace, (int)FNTSYS_MASK_STYLE[SYSTEM_FONTS[_iIndex][1]], (int)FNTSYS_MASK_SIZE[SYSTEM_FONTS[_iIndex][0]]);
        FntManager.FNTSYS_MAXHEIGHT[_iIndex] = (byte)ms_SystemFont[_iIndex].getHeight();
        FntManager.FNTSYS_HEIGHT[_iIndex] = (byte)ms_SystemFont[_iIndex].getHeight();
        FntManager.FNTSYS_BASELI[_iIndex] = (byte)ms_SystemFont[_iIndex].getBaselinePosition();
        System.arraycopy(FNTSYS_HEIGHT, 0, FNT_HEIGHT, 0, FNTSYS_HEIGHT.length);
        System.arraycopy(FNTSYS_BASELI, 0, FNT_BASELI, 0, FNTSYS_BASELI.length);
        System.arraycopy(FNTSYS_MAXHEIGHT, 0, FNT_MAXHEIGHT, 0, FNTSYS_MAXHEIGHT.length);
        if (ms_iFontType[_iIndex] == 1) {
            FntManager.FNTGFX_HEIGHT[_iIndex] = FNTGFX_LINE_DATA[_iIndex][0][0];
            FntManager.FNTGFX_BASELI[_iIndex] = FNTGFX_LINE_DATA[_iIndex][0][1];
            FntManager.FNTGFX_MAXHEIGHT[_iIndex] = 0;
            for (j = 0; j < FNTGFX_LINE_DATA[_iIndex].length; ++j) {
                if (FNTGFX_LINE_DATA[_iIndex][j][0] <= FNTGFX_MAXHEIGHT[_iIndex]) continue;
                FntManager.FNTGFX_MAXHEIGHT[_iIndex] = FNTGFX_LINE_DATA[_iIndex][j][0];
            }
            System.arraycopy(FNTGFX_HEIGHT, 0, FNT_HEIGHT, 0, FNT_HEIGHT.length);
            System.arraycopy(FNTGFX_BASELI, 0, FNT_BASELI, 0, FNT_BASELI.length);
            System.arraycopy(FNTGFX_MAXHEIGHT, 0, FNT_MAXHEIGHT, 0, FNT_MAXHEIGHT.length);
        }
        if (ms_iFontType[_iIndex] == 1) {
            try {
                FntManager.ms_iCharData[_iIndex] = new short[ms_zCharSet[_iIndex].length()][7];
                int iGlobalIndex = 0;
                for (j = 0; j < ms_zCharSet[_iIndex].length(); ++j) {
                    int iCharRow;
                    int iCharPosYGfx = 0;
                    int iCharCodeAcum = 0;
                    for (iCharRow = 0; iCharRow < FNTGFX_CHARPOS_X[_iIndex].length && j >= iCharCodeAcum + FNTGFX_CHARPOS_X[_iIndex][iCharRow].length - 1; ++iCharRow) {
                        iCharCodeAcum += FNTGFX_CHARPOS_X[_iIndex][iCharRow].length - 1;
                        iCharPosYGfx += FNTGFX_LINE_DATA[_iIndex][iCharRow][0];
                    }
                    FntManager.ms_iCharData[_iIndex][j][0] = FNTGFX_CHARPOS_X[_iIndex][iCharRow][j - iCharCodeAcum];
                    FntManager.ms_iCharData[_iIndex][j][1] = (short)(FNTGFX_CHARPOS_X[_iIndex][iCharRow][j - iCharCodeAcum + 1] - FNTGFX_CHARPOS_X[_iIndex][iCharRow][j - iCharCodeAcum]);
                    FntManager.ms_iCharData[_iIndex][j][2] = (short)iCharPosYGfx;
                    FntManager.ms_iCharData[_iIndex][j][3] = FNTGFX_LINE_DATA[_iIndex][iCharRow][0];
                    FntManager.ms_iCharData[_iIndex][j][4] = (short)(FNTGFX_BASELI[_iIndex] - FNTGFX_LINE_DATA[_iIndex][iCharRow][1]);
                    FntManager.ms_iCharData[_iIndex][j][5] = FNTGFX_OFFSET_X[_iIndex][iGlobalIndex];
                    FntManager.ms_iCharData[_iIndex][j][6] = FNTGFX_ADVANCE_X[_iIndex][iGlobalIndex];
                    ++iGlobalIndex;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            FntManager.FNTGFX_LINE_DATA[_iIndex] = null;
            FntManager.FNTGFX_CHARPOS_X[_iIndex] = null;
        }
    }

    private static boolean LoadGraphicFont(int _iIndex) {
        try {
            try {
                FntManager.ms_vFont[_iIndex][0] = Image.createImage((String)("/" + FONT_URL[_iIndex] + ".png"));
            }
            catch (Exception ex) {
                // empty catch block
            }
            System.gc();
            DataInputStream vInputS = new DataInputStream(((Object)((Object)MidletPBSP.vMidletInstance)).getClass().getResourceAsStream("/" + FONT_URL[_iIndex] + ".dat"));
            byte iFontNameLenght = vInputS.readByte();
            vInputS.skipBytes(iFontNameLenght * 2);
            FntManager.ms_zCharSet[_iIndex] = "";
            int iCharSetLenght = vInputS.readShort();
            for (int j = 0; j < iCharSetLenght; ++j) {
                int n = _iIndex;
                ms_zCharSet[n] = ms_zCharSet[n] + String.valueOf(vInputS.readChar());
            }
            int iCharXLenght = vInputS.readShort();
            FntManager.FNTGFX_CHARPOS_X[_iIndex] = new short[iCharXLenght][];
            for (int s = 0; s < iCharXLenght; ++s) {
                int iSubCharXLenght = vInputS.readShort();
                FntManager.FNTGFX_CHARPOS_X[_iIndex][s] = new short[iSubCharXLenght];
                for (int t = 0; t < iSubCharXLenght; ++t) {
                    FntManager.FNTGFX_CHARPOS_X[_iIndex][s][t] = vInputS.readShort();
                }
            }
            int iLineDataLenght = vInputS.readShort();
            FntManager.FNTGFX_LINE_DATA[_iIndex] = new byte[iLineDataLenght][];
            for (int s = 0; s < iLineDataLenght; ++s) {
                int iSubLineDataLenght = vInputS.readShort();
                FntManager.FNTGFX_LINE_DATA[_iIndex][s] = new byte[iSubLineDataLenght];
                for (int t = 0; t < iSubLineDataLenght; ++t) {
                    FntManager.FNTGFX_LINE_DATA[_iIndex][s][t] = vInputS.readByte();
                }
            }
            FntManager.FNT_SPACINGX[_iIndex] = vInputS.readByte();
            ms_iApostropheeCaseH = vInputS.readByte();
            FntManager.ms_iLetterHeight[_iIndex] = vInputS.readByte();
            short iSize = vInputS.readShort();
            FntManager.SYSTEM_FONTS[_iIndex][0] = Math.min(2, iSize / 30);
            FntManager.SYSTEM_FONTS[_iIndex][1] = vInputS.readByte();
            FntManager.SYSTEM_FONTS[_iIndex][2] = vInputS.readInt();
            byte iStrokeSize = vInputS.readByte();
            byte iShadowSizeX = vInputS.readByte();
            byte iShadowSizeY = vInputS.readByte();
            int iStrokeColor = vInputS.readInt();
            int iShadowColor = vInputS.readInt();
            if (iStrokeSize > 0) {
                FntManager.SYSTEM_STROKE[_iIndex] = new int[1];
                FntManager.SYSTEM_STROKE[_iIndex][0] = iStrokeColor;
                FntManager.SYSTEM_STROKE[_iIndex][1] = -1;
                FntManager.SYSTEM_STROKE[_iIndex][2] = -1;
            }
            if (iShadowSizeX != 0 && iShadowSizeY != 0) {
                FntManager.SYSTEM_SHADOW[_iIndex] = new int[3];
                FntManager.SYSTEM_SHADOW[_iIndex][0] = iShadowColor;
                FntManager.SYSTEM_SHADOW[_iIndex][1] = iShadowSizeX;
                FntManager.SYSTEM_SHADOW[_iIndex][2] = iShadowSizeY;
            }
            int iNumLetters = vInputS.readShort();
            FntManager.FNTGFX_ADVANCE_X[_iIndex] = new byte[iNumLetters];
            FntManager.FNTGFX_OFFSET_X[_iIndex] = new byte[iNumLetters];
            for (int i = 0; i < iNumLetters; ++i) {
                FntManager.FNTGFX_ADVANCE_X[_iIndex][i] = vInputS.readByte();
                FntManager.FNTGFX_OFFSET_X[_iIndex][i] = vInputS.readByte();
            }
            if (vInputS != null) {
                vInputS.close();
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private static boolean LoadSystemFont(int _iIndex) {
        try {
            DataInputStream vInputS = new DataInputStream(MidletPBSP.ms_vMain.getClass().getResourceAsStream("/" + FONT_URL[_iIndex] + ".syf"));
            short iSize = vInputS.readShort();
            FntManager.SYSTEM_FONTS[_iIndex][0] = Math.min(2, iSize / 40);
            FntManager.SYSTEM_FONTS[_iIndex][1] = vInputS.readByte();
            FntManager.SYSTEM_FONTS[_iIndex][2] = vInputS.readInt();
            byte iStrokeSize = vInputS.readByte();
            byte iShadowSizeX = vInputS.readByte();
            byte iShadowSizeY = vInputS.readByte();
            int iStrokeColor = vInputS.readInt();
            int iShadowColor = vInputS.readInt();
            if (iStrokeSize > 0) {
                FntManager.SYSTEM_STROKE[_iIndex] = new int[1];
                FntManager.SYSTEM_STROKE[_iIndex][0] = iStrokeColor;
            }
            if (iShadowSizeX != 0 && iShadowSizeY != 0) {
                int size = 1;
                FntManager.SYSTEM_SHADOW[_iIndex] = new int[3];
                FntManager.SYSTEM_SHADOW[_iIndex][0] = iShadowColor;
                FntManager.SYSTEM_SHADOW[_iIndex][1] = iShadowSizeX > 0 ? size : -1;
                int n = FntManager.SYSTEM_SHADOW[_iIndex][2] = iShadowSizeY > 0 ? size : -1;
            }
            if (vInputS != null) {
                vInputS.close();
            }
        }
        catch (Exception ex) {
            FntManager.SYSTEM_FONTS[_iIndex][2] = -1;
            return false;
        }
        return true;
    }

    public static int StringWidth(int _iFontID, String _zString) {
        if (Define.iLanguage < 3) {
            int iAnchoFrase = 0;
            int iNumCharsFrase = _zString.length();
            if (iNumCharsFrase == 0) {
                return 0;
            }
            for (int i = 0; i < iNumCharsFrase; ++i) {
                char iChar = _zString.charAt(i);
                int iArrayIndex = FntManager.Font_GetArrayCode(_iFontID, iChar) & 0xFF;
                iAnchoFrase += ms_iCharData[_iFontID][iArrayIndex][6] + FNT_SPACINGX[_iFontID];
            }
            ms_iApostrophe = 0;
            ms_iApostropheExtraY = 0;
            return iAnchoFrase;
        }
        return ms_SystemFont[_iFontID].stringWidth(_zString);
    }

    public static int Font_GetArrayCode(int _iFontID, int _iCharCode) {
        int iFinalArrayCode = ms_zCharSet[_iFontID].indexOf(_iCharCode);
        if (_iCharCode >= 192 && _iCharCode <= 196) {
            iFinalArrayCode = ms_zCharSet[_iFontID].indexOf("A");
            ms_iApostrophe = ms_zCharSet[_iFontID].indexOf(APOSTROPHE_LATIN[0][_iCharCode - 192]);
            ms_iApostropheExtraY = -((ms_iApostropheeCaseH >> 1) - (ms_iApostropheeCaseH >> 2));
        } else if (_iCharCode >= 200 && _iCharCode <= 203) {
            iFinalArrayCode = ms_zCharSet[_iFontID].indexOf("E");
            ms_iApostrophe = ms_zCharSet[_iFontID].indexOf(APOSTROPHE_LATIN[1][_iCharCode - 200]);
            ms_iApostropheExtraY = -((ms_iApostropheeCaseH >> 1) - (ms_iApostropheeCaseH >> 2));
        } else if (_iCharCode >= 204 && _iCharCode <= 207) {
            iFinalArrayCode = ms_zCharSet[_iFontID].indexOf("I");
            ms_iApostrophe = ms_zCharSet[_iFontID].indexOf(APOSTROPHE_LATIN[1][_iCharCode - 204]);
            ms_iApostropheExtraY = -((ms_iApostropheeCaseH >> 1) - (ms_iApostropheeCaseH >> 2));
        } else if (_iCharCode >= 210 && _iCharCode <= 214) {
            iFinalArrayCode = ms_zCharSet[_iFontID].indexOf("O");
            ms_iApostrophe = ms_zCharSet[_iFontID].indexOf(APOSTROPHE_LATIN[0][_iCharCode - 210]);
            ms_iApostropheExtraY = -((ms_iApostropheeCaseH >> 1) - (ms_iApostropheeCaseH >> 2));
        } else if (_iCharCode >= 217 && _iCharCode <= 220) {
            iFinalArrayCode = ms_zCharSet[_iFontID].indexOf("U");
            ms_iApostrophe = ms_zCharSet[_iFontID].indexOf(APOSTROPHE_LATIN[1][_iCharCode - 217]);
            ms_iApostropheExtraY = -((ms_iApostropheeCaseH >> 1) - (ms_iApostropheeCaseH >> 2));
        } else if (_iCharCode >= 224 && _iCharCode <= 228) {
            iFinalArrayCode = ms_zCharSet[_iFontID].indexOf("a");
            ms_iApostrophe = ms_zCharSet[_iFontID].indexOf(APOSTROPHE_LATIN[0][_iCharCode - 224]);
            ms_iApostropheExtraY = -((ms_iApostropheeCaseH >> 1) - (ms_iApostropheeCaseH >> 2));
        } else if (_iCharCode >= 232 && _iCharCode <= 235) {
            iFinalArrayCode = ms_zCharSet[_iFontID].indexOf("e");
            ms_iApostrophe = ms_zCharSet[_iFontID].indexOf(APOSTROPHE_LATIN[1][_iCharCode - 232]);
            ms_iApostropheExtraY = -((ms_iApostropheeCaseH >> 1) - (ms_iApostropheeCaseH >> 2));
        } else if (_iCharCode >= 236 && _iCharCode <= 239) {
            iFinalArrayCode = ms_zCharSet[_iFontID].indexOf(305);
            ms_iApostrophe = ms_zCharSet[_iFontID].indexOf(APOSTROPHE_LATIN[1][_iCharCode - 236]);
            ms_iApostropheExtraY = -((ms_iApostropheeCaseH >> 1) - (ms_iApostropheeCaseH >> 2));
        } else if (_iCharCode >= 242 && _iCharCode <= 246) {
            iFinalArrayCode = ms_zCharSet[_iFontID].indexOf("o");
            ms_iApostrophe = ms_zCharSet[_iFontID].indexOf(APOSTROPHE_LATIN[0][_iCharCode - 242]);
            ms_iApostropheExtraY = -((ms_iApostropheeCaseH >> 1) - (ms_iApostropheeCaseH >> 2));
        } else if (_iCharCode >= 249 && _iCharCode <= 252) {
            iFinalArrayCode = ms_zCharSet[_iFontID].indexOf("u");
            ms_iApostrophe = ms_zCharSet[_iFontID].indexOf(APOSTROPHE_LATIN[1][_iCharCode - 249]);
            ms_iApostropheExtraY = -((ms_iApostropheeCaseH >> 1) - (ms_iApostropheeCaseH >> 2));
        }
        if (iFinalArrayCode == -1) {
            iFinalArrayCode = ms_zCharSet[_iFontID].length() - 1;
        }
        return iFinalArrayCode;
    }

    public static int GetHeight(int _iFontID) {
        if (Define.iLanguage < 3) {
            return FNT_MAXHEIGHT[_iFontID];
        }
        return FNT_HEIGHT_SYSTEM;
    }

    public static void GetHeightSystemFont() {
        Font hFont = Font.getFont((int)0, (int)FNTSYS_MASK_STYLE[SYSTEM_FONTS[0][1]], (int)FNTSYS_MASK_SIZE[SYSTEM_FONTS[0][0]]);
        FNT_HEIGHT_SYSTEM = hFont.getHeight();
    }

    public static int GetBaseline(int _iFontID) {
        return FNT_BASELI[_iFontID];
    }

    public static void DrawFont(Graphics _g, int _iFontID, String _Frase, int _iPosX, int _iPosY, int _iAnchor, int _iChars) {
        if (!ARABIC_PROPER_SUPPORT && Define.iLanguage == 5) {
            textoArabeInvertido = ArabicReshaper.Convert(_Frase);
        }
        if (Define.iLanguage < 3) {
            FntManager.DrawGraphicFont(_g, _iFontID, _Frase, _iPosX, _iPosY, _iAnchor, _iChars);
        } else if (Define.iLanguage != 5) {
            FntManager.DrawSystemFont(_g, _iFontID, _Frase, _iPosX, _iPosY, _iAnchor, _iChars);
        } else if (ARABIC_PROPER_SUPPORT) {
            FntManager.DrawSystemFont(_g, _iFontID, _Frase, _iPosX, _iPosY - (FNT_HEIGHT_SYSTEM >> 3), _iAnchor, _iChars);
        } else {
            FntManager.DrawSystemFont(_g, _iFontID, textoArabeInvertido, _iPosX, _iPosY - (FNT_HEIGHT_SYSTEM >> 3), _iAnchor, _iChars);
        }
    }

    private static void DrawGraphicFont(Graphics _g, int _iFontID, String _Frase, int _iPosX, int _iPosY, int _iAnchor, int _iChars) {
        int iAnchoFraseStr;
        int saveClipX = _g.getClipX();
        int saveClipY = _g.getClipY();
        int saveClipW = _g.getClipWidth();
        int saveClipH = _g.getClipHeight();
        int iPalette = _iAnchor >> 8;
        int iIndex = 0;
        int iPosX = _iPosX;
        int iPosY = _iPosY;
        int n = iAnchoFraseStr = _iChars >= 0 ? Math.min(_iChars, _Frase.length()) : _Frase.length();
        if ((_iAnchor & 1) != 0) {
            iPosX -= FntManager.StringWidth(_iFontID, _Frase) >> 1;
        } else if ((_iAnchor & 8) != 0) {
            iPosX -= FntManager.StringWidth(_iFontID, _Frase);
        }
        if ((_iAnchor & 0x40) != 0) {
            iPosY -= ms_iLetterHeight[_iFontID];
        } else if ((_iAnchor & 2) != 0) {
            iPosY -= ms_iLetterHeight[_iFontID] >> 1;
        }
        while (iIndex < iAnchoFraseStr) {
            char iChar = _Frase.charAt(iIndex);
            int iCurrentChar = FntManager.Font_GetArrayCode(_iFontID, iChar) & 0xFF;
            _g.clipRect(iPosX + ms_iCharData[_iFontID][iCurrentChar][5], iPosY + ms_iCharData[_iFontID][iCurrentChar][4], (int)ms_iCharData[_iFontID][iCurrentChar][1], (int)ms_iCharData[_iFontID][iCurrentChar][3]);
            _g.drawImage(ms_vFont[_iFontID][iPalette], iPosX - ms_iCharData[_iFontID][iCurrentChar][0] + ms_iCharData[_iFontID][iCurrentChar][5], iPosY - ms_iCharData[_iFontID][iCurrentChar][2] + ms_iCharData[_iFontID][iCurrentChar][4], 20);
            _g.setClip(saveClipX, saveClipY, saveClipW, saveClipH);
            if (ms_iApostrophe != 0) {
                int iApostropheX = iPosX + (ms_iCharData[_iFontID][iCurrentChar][1] >> 1) - (ms_iCharData[_iFontID][ms_iApostrophe][1] >> 1);
                _g.clipRect(iApostropheX, iPosY + ms_iCharData[_iFontID][ms_iApostrophe][4] - ms_iApostropheExtraY, (int)ms_iCharData[_iFontID][ms_iApostrophe][1], (int)ms_iCharData[_iFontID][ms_iApostrophe][3]);
                _g.drawImage(ms_vFont[_iFontID][iPalette], iApostropheX - ms_iCharData[_iFontID][ms_iApostrophe][0], iPosY - ms_iCharData[_iFontID][ms_iApostrophe][2] + ms_iCharData[_iFontID][ms_iApostrophe][4] - ms_iApostropheExtraY, 20);
                ms_iApostrophe = 0;
                ms_iApostropheExtraY = 0;
                _g.setClip(saveClipX, saveClipY, saveClipW, saveClipH);
            }
            iPosX += ms_iCharData[_iFontID][iCurrentChar][6] + FNT_SPACINGX[_iFontID];
            ++iIndex;
        }
        _g.setClip(saveClipX, saveClipY, saveClipW, saveClipH);
    }

    private static void DrawSystemFont(Graphics _g, int _iFontID, String _Frase, int _iPosX, int _iPosY, int _iAnchor, int _iChars) {
        int iAnchoFraseStr = _iChars >= 0 ? Math.min(_iChars, _Frase.length()) : _Frase.length();
        _g.setFont(ms_SystemFont[_iFontID]);
        if ((_iAnchor & 1) != 0) {
            _iPosX -= ms_SystemFont[_iFontID].stringWidth(_Frase) >> 1;
        } else if ((_iAnchor & 8) != 0) {
            _iPosX -= ms_SystemFont[_iFontID].stringWidth(_Frase);
        }
        if ((_iAnchor & 2) != 0) {
            _iPosY -= FNTSYS_HEIGHT[_iFontID] >> 1;
        }
        if ((_iAnchor & 0x40) != 0) {
            _iPosY -= FNTSYS_BASELI[_iFontID];
        }
        if (SYSTEM_SHADOW[_iFontID] != null) {
            _g.setColor(SYSTEM_SHADOW[_iFontID][0]);
        }
        if (SYSTEM_STROKE[_iFontID] != null) {
            _g.setColor(SYSTEM_STROKE[_iFontID][0]);
            _g.drawString(_Frase.substring(0, iAnchoFraseStr), _iPosX + 1, _iPosY, 0);
            _g.drawString(_Frase.substring(0, iAnchoFraseStr), _iPosX - 1, _iPosY, 0);
            _g.drawString(_Frase.substring(0, iAnchoFraseStr), _iPosX, _iPosY + 1, 0);
            _g.drawString(_Frase.substring(0, iAnchoFraseStr), _iPosX, _iPosY - 1, 0);
        }
        _g.setColor(SYSTEM_FONTS[_iFontID][2]);
        _g.drawString(_Frase.substring(0, iAnchoFraseStr), _iPosX, _iPosY, 0);
    }

    public static void SetDefaultFontType() {
        System.arraycopy(ms_iDefaultFontType, 0, ms_iFontType, 0, NUM_FONTS);
    }

    public static void SetFontType(int _iIndex, int _iType) {
        FntManager.ms_iFontType[_iIndex] = _iType;
    }

    public static void SetFontType(int _iType) {
        for (int i = 0; i < NUM_FONTS; ++i) {
            FntManager.ms_iFontType[i] = _iType;
        }
    }

    public static void DrawFontInRectangle(Graphics _g, int _iFontID, String[] _iTextArray, int _iPosX, int _iPosY, int _iW, int _iFontSpacingY, int _iFontAnchor, int _iBoxAnchorY, int _iChars, boolean _bCalculateStrings) {
        ms_iDrawRectChars = 0;
        if (_iChars < 0) {
            _iChars = 999;
        }
        ms_iDrawRectY = _iPosY;
        if (_bCalculateStrings) {
            ms_iDrawRectFontLines = FntManager.SplitString(_iTextArray, _iW, _iFontID);
        }
        if ((_iBoxAnchorY & 0x40) != 0) {
            ms_iDrawRectY -= _iFontSpacingY * ms_iDrawRectFontLines;
        } else if ((_iBoxAnchorY & 2) != 0) {
            ms_iDrawRectY -= _iFontSpacingY * ms_iDrawRectFontLines >> 1;
        }
        if (ms_zDrawRectFontStr == null || _iChars == 0) {
            return;
        }
        int iPY = ms_iDrawRectY;
        int centerY = 0;
        for (int i = 0; i < ms_zDrawRectFontStr.length && ms_zDrawRectFontStr[i] != null; ++i) {
            arabicSpace = Define.iLanguage == 5 ? 0 : 0;
            if (_iChars < (ms_iDrawRectChars += ms_zDrawRectFontStr[i].length() - 1)) {
                FntManager.DrawFont(_g, _iFontID, ms_zDrawRectFontStr[i], _iPosX + arabicSpace, iPY - centerY, _iFontAnchor, ms_zDrawRectFontStr[i].length() - 1 - (ms_iDrawRectChars - _iChars));
                break;
            }
            FntManager.DrawFont(_g, _iFontID, ms_zDrawRectFontStr[i], _iPosX + arabicSpace, iPY - centerY, _iFontAnchor, -1);
            iPY += _iFontSpacingY;
        }
    }

    public static void DrawFontInRectangleHotToPlay(Graphics _g, int _iFontID, String[] _iTextArray, int _iPosX, int _iPosY, int _iW, int _iFontSpacingY, int _iFontAnchor, int _iBoxAnchorY, int _iChars, boolean _bCalculateStrings, boolean centerHeight) {
        ms_iDrawRectChars = 0;
        if (_iChars < 0) {
            _iChars = 999;
        }
        if (!checkDFITHTP) {
            checkDFITHTP = true;
            ms_iDrawRectY = _iPosY;
            if (_bCalculateStrings) {
                ms_iDrawRectFontLines = FntManager.SplitString(_iTextArray, _iW, _iFontID);
            }
            altoCajaTexto = _iFontSpacingY * ms_iDrawRectFontLines;
            maxLineas = 120 / _iFontSpacingY;
            if (ms_iDrawRectFontLines > maxLineas) {
                paginasTotales = (ms_iDrawRectFontLines - 1) / maxLineas;
            }
            ms_iDrawRectY -= _iFontSpacingY * maxLineas >> 1;
        }
        if (ms_zDrawRectFontStr == null || _iChars == 0) {
            return;
        }
        int iPY = ms_iDrawRectY;
        for (int i = maxLineas * numeroPagina; i < maxLineas + maxLineas * numeroPagina; ++i) {
            if (ms_zDrawRectFontStr[i] == null) {
                if (iPY != ms_iDrawRectY) break;
                FntManager.prevPagina();
                break;
            }
            ms_iDrawRectChars += ms_zDrawRectFontStr[i].length() - 1;
            FntManager.DrawFont(_g, _iFontID, ms_zDrawRectFontStr[i], _iPosX, iPY, _iFontAnchor, -1);
            if (paginasTotales > 0 && iPY == ms_iDrawRectY) {
                FntManager.DrawFont(_g, _iFontID, numeroPagina + 1 + " / " + (paginasTotales + 1), _iPosX, iPY + (maxLineas + 1) * _iFontSpacingY, _iFontAnchor, -1);
            }
            iPY += _iFontSpacingY;
        }
    }

    public static void nextPagina() {
        if (numeroPagina < paginasTotales) {
            ++numeroPagina;
        }
    }

    public static void prevPagina() {
        if (numeroPagina > 0) {
            --numeroPagina;
        }
    }

    public static void resetTextHowToPlay() {
        lineaInicial = 0;
        altoCajaTexto = 0;
        numeroPagina = 0;
        maxLineas = 0;
        paginasTotales = 0;
        checkDFITHTP = false;
    }

    public static boolean isLongText() {
        return paginasTotales > 0;
    }

    public static int getCurrentPage() {
        return numeroPagina;
    }

    public static int getTotalPages() {
        return paginasTotales;
    }

    private static int SplitString(String[] _iTextArray, int _iWidth, int _iFontID) {
        int i;
        boolean bJapanese = false;
        int iIndex = 0;
        int iInicio = 0;
        int iFinal = 0;
        int iFrase = 0;
        int iWidth = 0;
        int iLineasGuardadas = 0;
        for (i = 0; i < ms_zDrawRectFontStr.length; ++i) {
            FntManager.ms_zDrawRectFontStr[i] = null;
        }
        while (iFrase < _iTextArray.length) {
            String zFrase = _iTextArray[iFrase];
            try {
                while (iIndex < zFrase.length()) {
                    if (iIndex >= 491) {
                        System.out.println("Ahora empieza el error");
                    }
                    if ((zFrase.charAt(iIndex) == ' ' || bJapanese || zFrase.charAt(iIndex) == '/' || iIndex + 1 == zFrase.length()) && iWidth < _iWidth) {
                        iFinal = iIndex + 1;
                    }
                    if ((zFrase.charAt(iIndex) == ' ' || zFrase.charAt(iIndex) == '/') && iWidth >= _iWidth || bJapanese && iWidth >= _iWidth || iIndex + 1 == zFrase.length()) {
                        FntManager.ms_zDrawRectFontStr[iLineasGuardadas] = zFrase.substring(iInicio, iFinal);
                        iWidth = 0;
                        for (i = iFinal; i < iIndex; ++i) {
                            iWidth += FntManager.StringWidth(_iFontID, zFrase.substring(i, i + 1));
                        }
                        ++iLineasGuardadas;
                        iInicio = iFinal;
                        iFinal = iIndex + 1;
                    }
                    if (iIndex < zFrase.length()) {
                        iWidth += FntManager.StringWidth(_iFontID, zFrase.substring(iIndex, iIndex + 1));
                    }
                    if (++iIndex < zFrase.length() || iInicio >= iIndex) continue;
                    FntManager.ms_zDrawRectFontStr[iLineasGuardadas] = zFrase.substring(iInicio, iIndex);
                    ++iLineasGuardadas;
                }
            }
            catch (Exception e) {
                System.out.println("Error en " + iIndex + " en la l\u00ednea " + iLineasGuardadas);
            }
            ++iFrase;
            iIndex = 0;
            iInicio = 0;
            iFinal = 0;
            iWidth = 0;
        }
        ms_iDrawRectFontLines = iLineasGuardadas;
        return iLineasGuardadas;
    }

    public static int getLines(String[] _iTextArray, int _iWidth, int _iFontID) {
        boolean bJapanese = false;
        int iIndex = 0;
        int iInicio = 0;
        int iFinal = 0;
        int iWidth = 0;
        int iLineasGuardadas = 0;
        for (int iFrase = 0; iFrase < _iTextArray.length; ++iFrase) {
            String zFrase = _iTextArray[iFrase];
            while (iIndex < zFrase.length()) {
                if ((zFrase.charAt(iIndex) == ' ' || bJapanese || zFrase.charAt(iIndex) == '/' || iIndex + 1 == zFrase.length()) && iWidth < _iWidth) {
                    iFinal = iIndex + 1;
                }
                if ((zFrase.charAt(iIndex) == ' ' || zFrase.charAt(iIndex) == '/') && iWidth >= _iWidth || bJapanese && iWidth >= _iWidth || iIndex + 1 == zFrase.length()) {
                    iWidth = 0;
                    for (int i = iFinal; i < iIndex; ++i) {
                        iWidth += FntManager.StringWidth(_iFontID, zFrase.substring(i, i + 1));
                    }
                    ++iLineasGuardadas;
                    iInicio = iFinal;
                    iFinal = iIndex + 1;
                }
                if (iIndex < zFrase.length()) {
                    iWidth += FntManager.StringWidth(_iFontID, zFrase.substring(iIndex, iIndex + 1));
                }
                if (++iIndex < zFrase.length() || iInicio >= iIndex) continue;
                ++iLineasGuardadas;
            }
            iIndex = 0;
            iInicio = 0;
            iFinal = 0;
            iWidth = 0;
        }
        return iLineasGuardadas;
    }

    public static boolean LanguageCheckFontSupport(String _zText1, String _zText2) {
        Image vImage1 = Image.createImage((int)Font.getDefaultFont().getHeight(), (int)Font.getDefaultFont().getHeight());
        Image vImage2 = Image.createImage((int)Font.getDefaultFont().getHeight(), (int)Font.getDefaultFont().getHeight());
        Graphics g1 = vImage1.getGraphics();
        g1.drawString(_zText1, 0, 0, 0);
        Graphics g2 = vImage2.getGraphics();
        g2.drawString(_zText2, 0, 0, 0);
        int[] iData1 = new int[vImage1.getWidth() * vImage1.getHeight()];
        int[] iData2 = new int[vImage2.getWidth() * vImage2.getHeight()];
        vImage1.getRGB(iData1, 0, vImage1.getWidth(), 0, 0, vImage1.getWidth(), vImage1.getHeight());
        vImage2.getRGB(iData2, 0, vImage2.getWidth(), 0, 0, vImage2.getWidth(), vImage2.getHeight());
        boolean bEqual = true;
        for (int i = 0; i < iData1.length; ++i) {
            if (iData1[i] == iData2[i]) continue;
            bEqual = false;
            break;
        }
        return bEqual;
    }

    public static boolean checkRussian(String _zText1, String _zText2) {
        boolean resultado = false;
        Image vImage1 = Image.createImage((int)Font.getDefaultFont().getHeight(), (int)Font.getDefaultFont().getHeight());
        Image vImage2 = Image.createImage((int)Font.getDefaultFont().getHeight(), (int)Font.getDefaultFont().getHeight());
        Graphics g1 = vImage1.getGraphics();
        g1.drawString(_zText1, 0, 0, 0);
        Graphics g2 = vImage2.getGraphics();
        g2.drawString(_zText2, 0, 0, 0);
        int[] iData1 = new int[vImage1.getWidth() * vImage1.getHeight()];
        int[] iData2 = new int[vImage2.getWidth() * vImage2.getHeight()];
        vImage1.getRGB(iData1, 0, vImage1.getWidth(), 0, 0, vImage1.getWidth(), vImage1.getHeight());
        vImage2.getRGB(iData2, 0, vImage2.getWidth(), 0, 0, vImage2.getWidth(), vImage2.getHeight());
        for (int i = 0; i < iData1.length; ++i) {
            if (iData1[i] == iData2[i]) continue;
            resultado = true;
            break;
        }
        return resultado;
    }

    static {
        APOSTROPHE_LATIN = new char[][]{{'`', '\u00b4', '\u02c6', '\u02dc', '\u00a8'}, {'`', '\u00b4', '\u02c6', '\u00a8'}};
        ms_vFont = new Image[NUM_FONTS][5];
        ms_iLetterHeight = new int[NUM_FONTS];
        ms_iFontType = new int[NUM_FONTS];
        ms_iDefaultFontType = new int[NUM_FONTS];
        ms_zDrawRectFontStr = new String[50];
        ARABIC_PROPER_SUPPORT = FntManager.LanguageCheckFontSupport(ARABIC_TEST1, ARABIC_TEST2);
        ARABIC_SUPPORT = Font.getDefaultFont().stringWidth(String.valueOf('\u0627')) != Font.getDefaultFont().stringWidth(String.valueOf('\u0628'));
        BENGAL_SUPPORT = Font.getDefaultFont().stringWidth(String.valueOf('\u09f7')) != Font.getDefaultFont().stringWidth(String.valueOf('\u0985'));
        RUSSIAN_SUPPORT = FntManager.checkRussian("\u0434\u0434\u0434\u0434\u0434\u0434", "\u044c\u044c\u044c\u044c\u044c\u044c");
    }
}

