/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.finalkombat2;

import WelderTools.WeeldSprite;
import com.kitmaker.finalkombat2.Game;
import com.kitmaker.finalkombat2.Gfx;
import com.kitmaker.finalkombat2.Player;
import javax.microedition.lcdui.Graphics;

public class Container {
    private int posX;
    private int posY;
    private int width;
    private int height;
    private int hitDistanceX;
    private int hitDistanceY;
    private int pickUpDistanceX;
    private int pickUpDistanceY;
    private int state;
    private final int CLOSED;
    private final int OPENING;
    private final int OPENED;
    private final int PICKED_UP;
    private WeeldSprite containerSprite;
    private String containerPngPath = "/container.png";
    private String containerAnuPath = "/container.anu";

    public Container(int _ID, int _posX, int _posY) {
        this.CLOSED = 0;
        this.OPENING = 1;
        this.OPENED = 2;
        this.PICKED_UP = 3;
        this.posX = _posX;
        this.posY = _posY;
        this.width = 40;
        this.height = 64;
        this.state = 0;
        this.hitDistanceX = this.width;
        this.hitDistanceY = this.height >> 1;
        this.pickUpDistanceX = this.hitDistanceX >> 1;
        this.pickUpDistanceY = this.hitDistanceY >> 1;
        this.containerSprite = new WeeldSprite(_ID, new String[]{this.containerPngPath, "/fx_02.png"}, this.containerAnuPath, _posX, _posY, Gfx.totalWeeldSprite);
        this.containerSprite.loadPoolImage();
    }

    public void Update() {
        this.containerSprite.update();
        this.CheckPlayerPos();
        switch (this.state) {
            case 0: {
                if (this.containerSprite.getAnimation() == 0) break;
                this.containerSprite.setAnimation(0, true);
                break;
            }
            case 1: {
                if (this.containerSprite.getAnimation() != 1) {
                    this.containerSprite.setAnimation(1, true);
                }
                if (!this.containerSprite.loopFinished()) break;
                this.state = 2;
                break;
            }
            case 2: {
                if (this.containerSprite.getAnimation() != 2) {
                    this.containerSprite.setAnimation(2, true);
                }
                if (Math.abs(Player.getX() - this.posX) >= this.pickUpDistanceX || Math.abs(Player.getY() + (Player.getHeight() >> 1) - this.posY) >= this.pickUpDistanceY) break;
                this.state = 3;
                Player.addLife(30);
                break;
            }
            case 3: {
                if (this.containerSprite.getAnimation() == 3) break;
                this.containerSprite.setAnimation(3, true);
            }
        }
    }

    public void Paint(Graphics g) {
        this.containerSprite.setDrawPosition(this.posX + 16 - Game.getScrollX(), this.posY + 32 - Game.getScrollY());
        this.containerSprite.drawFrame(g);
    }

    private void CheckPlayerPos() {
        switch (this.state) {
            case 0: {
                if (!this.canPlayerHit()) break;
                this.state = 1;
            }
        }
    }

    public boolean isNearPlayer() {
        return Math.abs(this.posX - Player.getX()) < 240 && Math.abs(this.posY - Player.getY()) < 320 + this.height;
    }

    public void DeleteMotionWeelderData() {
        try {
            this.containerSprite.unloadPoolImage();
            this.containerSprite.unloadSpriteData();
            this.containerSprite = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean canPlayerHit() {
        int playerPosX = Math.abs(Player.getX() - this.posX);
        int playerPosY = Math.abs(Player.getY() + (Player.getHeight() >> 1) - this.posY);
        if (Player.getX() + (Player.getWidth() >> 1) < this.posX + (this.width >> 1) && Player.getOrientation()) {
            return playerPosX < this.hitDistanceX && playerPosY < this.hitDistanceY && (Player.getAnimation() == 2 || Player.getAnimation() == 3 || Player.getAnimation() == 4 || Player.getAnimation() == 6 || Player.getAnimation() == 13 || Player.getAnimation() == 15);
        }
        if (Player.getX() + (Player.getWidth() >> 1) > this.posX + (this.width >> 1) && !Player.getOrientation()) {
            return playerPosX < this.hitDistanceX && playerPosY < this.hitDistanceY && (Player.getAnimation() == 2 || Player.getAnimation() == 3 || Player.getAnimation() == 4 || Player.getAnimation() == 6 || Player.getAnimation() == 13 || Player.getAnimation() == 15);
        }
        return false;
    }
}

