/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.boss;

import WelderTools.WeeldSprite;
import com.kitmaker.finalkombat2.Game;
import com.kitmaker.finalkombat2.Gfx;
import com.kitmaker.finalkombat2.Player;
import com.kitmaker.finalkombat2.enemigos.Enemy;
import javax.microedition.lcdui.Graphics;

public class LittleBad
extends Enemy {
    private int strength;
    private int width;
    private int height;
    private int initialPosX;
    private int initialPosY;
    private int reactionDistanceXLeft;
    private int reactionDistanceXRight;
    private int reactionDistanceYTop;
    private int reactionDistanceYBottom;
    private boolean facingRight;
    private int moveSpeed;
    private int state = 0;
    private boolean playerHitted = false;
    private final int IDLE;
    private final int WALK;
    private final int STUCK;
    private final int HITTED;
    private final int ATTACK;
    private final int DEAD;
    private final int ATTACK_RECOVER;
    private int attackDistanceX;
    private int attackDistanceY;
    private int actionDelay;
    private int time;
    private int stunnedTime;
    private int stunnedTimer;
    private boolean hitted = false;
    private String littleBadPngPath = "/littleBad.png";
    private String littleBadAnuPath = "/littleBad.anu";

    public LittleBad(int _ID, int _posX, int _posY) {
        this.IDLE = 0;
        this.WALK = 1;
        this.STUCK = 2;
        this.HITTED = 3;
        this.ATTACK = 4;
        this.DEAD = 5;
        this.ATTACK_RECOVER = 6;
        this.health = 60;
        this.strength = 25;
        this.width = 96;
        this.height = 48;
        this.facingRight = true;
        this.moveSpeed = 1;
        this.attackDistanceX = 64 + (Player.getWidth() >> 1);
        this.attackDistanceY = 48;
        this.actionDelay = 2000;
        this.state = 0;
        this.posX = _posX;
        this.posY = _posY;
        this.enemySprite = new WeeldSprite(_ID, new String[]{this.littleBadPngPath, "/fx_01.png", "/fx_03.png"}, this.littleBadAnuPath, _posX, _posY, Gfx.totalWeeldSprite);
        this.enemySprite.loadPoolImage();
        this.stunnedTime = 4000;
        this.enemySprite.setAnimation(this.state, true);
        this.time = (int)System.currentTimeMillis();
        this.initialPosX = this.posX;
        this.initialPosY = this.posY;
        this.reactionDistanceXLeft = this.initialPosX - 352;
        this.reactionDistanceXRight = this.initialPosX + 96;
        this.reactionDistanceYTop = this.initialPosY - 128;
        this.reactionDistanceYBottom = this.initialPosY + 32 + 8;
    }

    public void UpdateIA() {
        this.enemySprite.update();
        if (this.state == 0 || this.state == 1) {
            this.Flip();
        }
        if (!Player.isDead()) {
            this.Behavior();
        } else if (this.enemySprite.getAnimation() != 0) {
            this.enemySprite.setAnimation(0, true);
        }
        this.PlayerHitBoss();
        this.CheckAnimation();
    }

    private void CheckAnimation() {
        switch (this.state) {
            case 0: {
                if (this.enemySprite.getAnimation() == 0) break;
                this.enemySprite.setAnimation(0, true);
                break;
            }
            case 1: {
                if (this.enemySprite.getAnimation() == 1) break;
                this.enemySprite.setAnimation(1, true);
                break;
            }
            case 4: {
                if (this.enemySprite.getAnimation() == 4) break;
                this.enemySprite.setAnimation(4, false);
                break;
            }
            case 2: {
                if (this.enemySprite.getAnimation() == 2) break;
                this.enemySprite.setAnimation(2, true);
                break;
            }
            case 3: {
                if (this.enemySprite.getAnimation() == 3) break;
                this.enemySprite.setAnimation(3, false);
                break;
            }
            case 5: {
                if (this.enemySprite.getAnimation() != 5) {
                    this.enemySprite.setAnimation(5, false);
                }
                if (!this.enemySprite.loopFinished() || (int)System.currentTimeMillis() - this.time <= 0) break;
                Game.isInTheGetho = true;
                break;
            }
            case 6: {
                if (this.enemySprite.getAnimation() == 6) break;
                this.enemySprite.setAnimation(6, false);
            }
        }
    }

    private void Behavior() {
        switch (this.state) {
            case 4: {
                if (this.enemySprite.loopFinished()) {
                    if (this.playerHitted) {
                        this.state = 6;
                    } else {
                        this.state = 2;
                        this.stunnedTimer = (int)System.currentTimeMillis();
                    }
                } else if (this.enemySprite.getCurrentFrame() == 3) {
                    if (this.CheckCollisionWithPlayer() && !this.playerHitted) {
                        if (this.facingRight && Player.getX() + (Player.getWidth() >> 1) > this.GetPivotX()) {
                            Player.lessLife(this.strength, this.facingRight, true, false);
                            this.playerHitted = true;
                        } else if (!this.facingRight && Player.getX() + (Player.getWidth() >> 1) < this.GetPivotX()) {
                            Player.lessLife(this.strength, this.facingRight, true, false);
                            this.playerHitted = true;
                        }
                    }
                    Game.setQuake(20);
                }
                this.time = (int)System.currentTimeMillis();
                break;
            }
            case 0: {
                if ((int)System.currentTimeMillis() - this.time <= this.actionDelay || !this.PlayerIsInBossArea()) break;
                this.state = 1;
                break;
            }
            case 1: {
                if (!this.CheckCollisionWithPlayer()) {
                    if (this.PlayerIsInBossArea()) {
                        this.Walk();
                        break;
                    }
                    this.state = 0;
                    break;
                }
                if ((int)System.currentTimeMillis() - this.time <= this.actionDelay) break;
                this.state = 4;
                this.time = (int)System.currentTimeMillis();
                break;
            }
            case 2: {
                if (this.enemySprite.getAnimation() != 2) {
                    this.enemySprite.setAnimation(2, true);
                }
                if ((int)System.currentTimeMillis() - this.stunnedTimer <= this.stunnedTime) break;
                this.state = 6;
                this.time = (int)System.currentTimeMillis();
                break;
            }
            case 3: {
                if (!this.enemySprite.loopFinished()) break;
                this.state = 2;
                break;
            }
            case 6: {
                if (!this.enemySprite.loopFinished()) break;
                this.state = 0;
                this.time = (int)System.currentTimeMillis();
                this.playerHitted = false;
            }
        }
    }

    private void Walk() {
        this.posX = this.facingRight ? (this.posX += this.moveSpeed) : (this.posX -= this.moveSpeed);
    }

    private void Flip() {
        if (this.state != 2 && this.state != 3 && this.state != 5) {
            if (Player.getX() > this.posX && !this.facingRight) {
                this.enemySprite.setSpriteOrientation((byte)0);
                this.facingRight = true;
            } else if (Player.getX() < this.posX && this.facingRight) {
                this.enemySprite.setSpriteOrientation((byte)1);
                this.facingRight = false;
            }
        }
    }

    public void Paint(Graphics g) {
        this.enemySprite.setDrawPosition(this.posX + 16 - Game.getScrollX() + this.m_iHittedExtraX, this.posY + 32 - Game.getScrollY());
        this.enemySprite.drawFrame(g);
    }

    public void SubstractHealth(int _amount) {
        Player.colisionFist(_amount, true, true);
        if (this.health > 0) {
            this.health -= _amount;
            this.state = 3;
        }
        if (this.health <= 0) {
            this.isDead = true;
            this.health = 0;
            this.state = 5;
            this.time = (int)System.currentTimeMillis();
            Game.time = (int)System.currentTimeMillis();
        }
        Game.setQuake(_amount * 10);
    }

    private boolean CheckCollisionWithPlayer() {
        return Math.abs(this.GetPivotX() - (Player.getX() + (Player.getWidth() >> 1))) < (this.width >> 1) + (this.width >> 2) && Math.abs(this.GetPivotY() - (Player.getY() + (Player.getHeight() >> 1))) < (this.height >> 1) + (this.height >> 2);
    }

    private void PlayerHitBoss() {
        if (this.state == 2 && Math.abs(this.GetPivotX() - Player.getX() + (Player.getWidth() >> 1)) < 96 && Math.abs(this.GetPivotY() - (Player.getY() + (Player.getHeight() >> 1))) < (this.height >> 1) + (this.height >> 2)) {
            if (this.facingRight) {
                if (Player.getX() + (Player.getWidth() >> 1) > this.GetPivotX()) {
                    if (!Player.getOrientation()) {
                        if ((Player.getAnimation() == 2 || Player.getAnimation() == 3 || Player.getAnimation() == 4) && Player.getFrame() == 1) {
                            this.SubstractHealth(1);
                            return;
                        }
                        if (Player.getAnimation() == 6) {
                            this.SubstractHealth(2);
                            return;
                        }
                        if (Player.getAnimation() == 13) {
                            if (Player.getFrame() == 2) {
                                this.SubstractHealth(3);
                            }
                            return;
                        }
                    }
                } else if (Player.getOrientation()) {
                    if ((Player.getAnimation() == 2 || Player.getAnimation() == 3 || Player.getAnimation() == 4) && Player.getFrame() == 1) {
                        this.SubstractHealth(1);
                        return;
                    }
                    if (Player.getAnimation() == 6) {
                        this.SubstractHealth(2);
                        return;
                    }
                    if (Player.getAnimation() == 13) {
                        if (Player.getFrame() == 2) {
                            this.SubstractHealth(3);
                        }
                        return;
                    }
                }
            } else if (Player.getX() + (Player.getWidth() >> 1) < this.GetPivotX()) {
                if (Player.getOrientation()) {
                    if ((Player.getAnimation() == 2 || Player.getAnimation() == 3 || Player.getAnimation() == 4) && Player.getFrame() == 1) {
                        this.SubstractHealth(1);
                        return;
                    }
                    if (Player.getAnimation() == 6) {
                        this.SubstractHealth(2);
                        return;
                    }
                    if (Player.getAnimation() == 13) {
                        if (Player.getFrame() == 2) {
                            this.SubstractHealth(3);
                        }
                        return;
                    }
                }
            } else if (!Player.getOrientation()) {
                if ((Player.getAnimation() == 2 || Player.getAnimation() == 3 || Player.getAnimation() == 4) && Player.getFrame() == 1) {
                    this.SubstractHealth(1);
                    return;
                }
                if (Player.getAnimation() == 6) {
                    this.SubstractHealth(2);
                    return;
                }
                if (Player.getAnimation() == 13) {
                    if (Player.getFrame() == 2) {
                        this.SubstractHealth(3);
                    }
                    return;
                }
            }
        }
        if (Player.getAnimation() == 15 && this.state == 2) {
            if (this.GetPivotX() > Player.getX() + (Player.getWidth() >> 1)) {
                if (Player.getOrientation() && Player.getFrame() > 16 && Player.getFrame() < 25) {
                    this.SubstractHealth(2);
                }
            } else if (!Player.getOrientation() && Player.getFrame() > 16 && Player.getFrame() < 25) {
                this.SubstractHealth(2);
            }
        }
    }

    public void DeleteMotionWeelderData() {
        try {
            this.enemySprite.unloadPoolImage();
            this.enemySprite.unloadSpriteData();
            this.enemySprite = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean PlayerIsInBossArea() {
        return Player.getX() >= this.reactionDistanceXLeft && Player.getX() <= this.reactionDistanceXRight && Player.getY() + Player.getHeight() >= this.reactionDistanceYTop && Player.getY() + Player.getHeight() <= this.reactionDistanceYBottom;
    }

    private int GetPivotX() {
        return this.posX + 16;
    }

    private int GetPivotY() {
        return this.posY;
    }

    public void SetStunTime(int _time) {
        this.stunnedTimer += _time;
    }
}

