/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.exoticasrayosx;

import cocos2d.CCDirector;
import cocos2d.actions.CCAction;
import cocos2d.actions.CCCallFunc;
import cocos2d.actions.CCDelayTime;
import cocos2d.actions.CCMoveBy;
import cocos2d.actions.CCSequence;
import cocos2d.cocos2d;
import cocos2d.extensions.CCLayerColorRounded;
import cocos2d.nodes.CCLabelTTF;
import cocos2d.nodes.CCMenuItemInvisible;
import cocos2d.nodes.CCNode;
import cocos2d.nodes.CCSprite;
import cocos2d.types.CCFunction;
import cocos2d.types.CCPoint;
import com.kitmaker.exoticasrayosx.NotificationDelegate;
import java.util.Stack;
import javax.microedition.lcdui.Font;

public class NotificationManager
extends CCMenuItemInvisible {
    public static final int STATE_VISIBLE = 0;
    public static final int STATE_HIDDEN = 1;
    private static final int TAG_NOTIFICATION = 85674;
    private static final int IMAGE_MARGIN_TO_TEXT = 5;
    private static boolean notificationVisible = false;
    private static final Stack notifImageCache = new Stack();
    private static final Stack notifNameCache = new Stack();
    private static final Stack notifDescriptionCache = new Stack();
    private static final Stack notifTagCache = new Stack();
    public static NotificationDelegate delegate;
    private int notifTag = -1;

    public NotificationManager(int width, int height, int tag) {
        super(width, height, (CCNode)null);
        this.width = width;
        this.height = height;
        this.notifTag = tag;
    }

    public void fireEvent() {
        if (delegate != null) {
            delegate.notificationTouched(this.notifTag);
        }
    }

    public void onEnter() {
        notificationVisible = true;
        super.onEnter();
    }

    public void onExit() {
        notificationVisible = false;
        super.onExit();
    }

    public static void showNotification(String imageName, String name, String description, int tag) {
        if (!notificationVisible && CCDirector.sharedDirector().runningScene != null) {
            notificationVisible = true;
            CCLayerColorRounded layer = CCLayerColorRounded.layer(cocos2d.SCREEN_WIDTH - 10, 40, 0, 15);
            layer.setPosition(5, cocos2d.SCREEN_HEIGHT);
            CCLayerColorRounded insideLayer = CCLayerColorRounded.layer(layer.width - 2, layer.height - 2, 0xFFFFFF, 15);
            insideLayer.setPosition(1, 1);
            layer.addChild(insideLayer);
            CCSprite image = CCSprite.spriteWithFile(imageName);
            image.setAnchorPoint(0, 50);
            image.setPosition(4, 0);
            layer.addChild(image);
            int imageRightBorder = image.position.x + image.width + 5;
            CCLabelTTF nameLabel = CCLabelTTF.labelWithString(name);
            nameLabel.setAnchorPoint(0, 100);
            layer.addChild(nameLabel);
            CCLabelTTF detailsLabel = CCLabelTTF.labelWithString(description, Font.getFont((int)32, (int)2, (int)8));
            detailsLabel.setAnchorPoint(0, 100);
            detailsLabel.setLineSpacing(0);
            detailsLabel.setMaxLineWidth(layer.width - imageRightBorder);
            layer.addChild(detailsLabel);
            layer.height = nameLabel.height + detailsLabel.height + 4;
            insideLayer.height = layer.height - 2;
            image.setPosition(image.position.x, layer.height / 2);
            detailsLabel.setPosition(imageRightBorder, layer.height - nameLabel.height - 2);
            nameLabel.setPosition(imageRightBorder, layer.height - 2);
            layer.addChild(new NotificationManager(layer.width, layer.height, tag));
            CCDirector.sharedDirector().runningScene.addChild(layer, Integer.MAX_VALUE, 85674);
            if (delegate != null) {
                delegate.notificationStateChanged(0, tag);
            }
            CCSequence hide = CCSequence.action(new CCAction[]{CCMoveBy.action(CCPoint.ccp(0, -(layer.height + 5)), 500L), CCDelayTime.action(3000L), CCMoveBy.action(CCPoint.ccp(0, layer.height + 5), 500L), CCCallFunc.action(new CCFunction(){

                public void function() {
                    NotificationManager oldNotification = (NotificationManager)CCDirector.sharedDirector().runningScene.getChildByTag(85674);
                    CCDirector.sharedDirector().runningScene.removeChildByTag(85674, false);
                    if (delegate != null) {
                        delegate.notificationStateChanged(1, oldNotification.notifTag);
                    }
                    if (!notifNameCache.empty()) {
                        NotificationManager.showNotification((String)notifImageCache.pop(), (String)notifNameCache.pop(), (String)notifDescriptionCache.pop(), (Integer)notifTagCache.pop());
                    } else {
                        delegate = null;
                    }
                }
            })});
            layer.runAction(hide);
        } else {
            notifImageCache.push(imageName);
            notifNameCache.push(name);
            notifDescriptionCache.push(description);
            notifTagCache.push(new Integer(tag));
        }
    }
}

