/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.types;

import cocos2d.CCTextureCache;
import cocos2d.cocos2d;
import cocos2d.types.FontCharacter;
import cocos2d.types.MutableInteger;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class BMFont {
    private static final MutableInteger tMyInt = new MutableInteger(0);
    public Hashtable font = null;
    public String filename = null;
    public Image image = null;
    private static Hashtable cache = new Hashtable(3);
    private static final StringBuffer buffer = new StringBuffer(64);

    public BMFont(String filename, Hashtable font) {
        this.font = font;
        this.filename = filename;
        this.image = CCTextureCache.sharedTextureCache().addImage((String)filename).image;
    }

    public String printState() {
        return "cache size:" + cache.size() + "\ncontents:" + cache.toString();
    }

    public static final void purgeFontCache() {
        cache.clear();
    }

    public static String collapseSpaces(String argStr) {
        int stringLength = argStr.length();
        if (stringLength == 0) {
            return "";
        }
        char last = argStr.charAt(0);
        StringBuffer argBuf = new StringBuffer();
        for (int cIdx = 0; cIdx < stringLength; ++cIdx) {
            char ch = argStr.charAt(cIdx);
            if (ch == ' ' && last == ' ') continue;
            argBuf.append(ch);
            last = ch;
        }
        return argBuf.toString();
    }

    public static final BMFont getFont(String filename) {
        if (!cache.containsKey(filename)) {
            Hashtable<MutableInteger, FontCharacter> fontTable = new Hashtable<MutableInteger, FontCharacter>(64);
            String imgName = "";
            Vector pair = new Vector(2, 1);
            InputStream is = tMyInt.getClass().getResourceAsStream("/" + cocos2d.resourceFolder + filename);
            if (is == null) {
                cocos2d.CCLog("BMFont: cannot find font file /" + filename);
                return null;
            }
            Vector splitRes = new Vector(10, 2);
            while (true) {
                String lastLine;
                block10: {
                    try {
                        lastLine = BMFont.readLine(is);
                        if (lastLine.length() == 0) {
                        }
                        break block10;
                    }
                    catch (Exception ex) {
                        cocos2d.CCLog("BMFont: " + ex.toString());
                    }
                    break;
                }
                lastLine = BMFont.collapseSpaces(lastLine);
                cocos2d.splitToVector(lastLine, " ", splitRes);
                String lineType = (String)splitRes.elementAt(0);
                if (lineType.equals("char")) {
                    cocos2d.splitToVector((String)splitRes.elementAt(1), "=", pair);
                    int id = Integer.parseInt((String)pair.elementAt(1));
                    cocos2d.splitToVector((String)splitRes.elementAt(2), "=", pair);
                    int x = Integer.parseInt((String)pair.elementAt(1));
                    cocos2d.splitToVector((String)splitRes.elementAt(3), "=", pair);
                    int y = Integer.parseInt((String)pair.elementAt(1));
                    cocos2d.splitToVector((String)splitRes.elementAt(4), "=", pair);
                    int width = Integer.parseInt((String)pair.elementAt(1));
                    cocos2d.splitToVector((String)splitRes.elementAt(5), "=", pair);
                    int height = Integer.parseInt((String)pair.elementAt(1));
                    cocos2d.splitToVector((String)splitRes.elementAt(6), "=", pair);
                    int xoffset = Integer.parseInt((String)pair.elementAt(1));
                    cocos2d.splitToVector((String)splitRes.elementAt(7), "=", pair);
                    int yoffset = Integer.parseInt((String)pair.elementAt(1));
                    cocos2d.splitToVector((String)splitRes.elementAt(8), "=", pair);
                    int xadvance = Integer.parseInt((String)pair.elementAt(1));
                    fontTable.put(new MutableInteger(id), new FontCharacter(x, y, width, height, xoffset, yoffset, xadvance));
                    continue;
                }
                if (lineType.equals("kernings") || lineType.equals("kerning")) {
                    cocos2d.CCLog("BMFont: delete the kerning information from " + filename);
                    break;
                }
                if (lineType.equals("chars") || !lineType.equals("page")) continue;
                cocos2d.splitToVector((String)splitRes.elementAt(2), "=", pair);
                imgName = (String)pair.elementAt(1);
                imgName = cocos2d.replace(imgName, "\"", "");
            }
            try {
                is.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            pair.removeAllElements();
            cache.put(filename, new BMFont(imgName, fontTable));
        }
        return (BMFont)cache.get(filename);
    }

    public static final void removeFont(String fontName) {
        cache.remove(fontName);
    }

    public int stringWidth(String string) {
        int cursor_x = 0;
        int maxWidth = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                cursor_x = 0;
                continue;
            }
            FontCharacter myChar = (FontCharacter)this.font.get(tMyInt.set(c));
            if (myChar == null) continue;
            int curWidth = cursor_x + myChar.xoffset + myChar.charWidth;
            if (maxWidth < curWidth) {
                maxWidth = curWidth;
            }
            cursor_x += myChar.xadvance;
        }
        return maxWidth;
    }

    static int countLines(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        int lines = 1;
        int len = str.length();
        for (int pos = 0; pos < len; ++pos) {
            char c = str.charAt(pos);
            if (c == '\r') {
                ++lines;
                if (pos + 1 >= len || str.charAt(pos + 1) != '\n') continue;
                ++pos;
                continue;
            }
            if (c != '\n') continue;
            ++lines;
        }
        return lines;
    }

    public int charWidth(char c) {
        FontCharacter myChar = (FontCharacter)this.font.get(tMyInt.set(c));
        if (myChar != null) {
            return myChar.xadvance;
        }
        return 0;
    }

    public int fontHeight(String string) {
        int cursor_y = 0;
        int maxHeight = 0;
        for (int i = 0; i < string.length(); ++i) {
            int curHeight;
            char c = string.charAt(i);
            FontCharacter myChar = (FontCharacter)this.font.get(tMyInt.set(c));
            if (c == '\n' || c == ' ' || myChar == null || maxHeight >= (curHeight = myChar.yoffset + cursor_y + myChar.charHeight)) continue;
            maxHeight = curHeight;
        }
        return maxHeight;
    }

    private static final String readLine(InputStream is) {
        byte[] oneByte = new byte[1];
        buffer.setLength(0);
        try {
            while (is.read(oneByte) != -1 && oneByte[0] != 10) {
                if (oneByte[0] == 13) continue;
                buffer.append((char)oneByte[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buffer.toString();
    }
}

