/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.nodes;

import cocos2d.CCDirector;
import cocos2d.actions.CCAction;
import cocos2d.cocos2d;
import cocos2d.nodes.CCScene;
import cocos2d.nodes.CCSprite;
import cocos2d.types.CCPoint;
import cocos2d.types.CCPointF;
import cocos2d.types.CCTouch;
import java.util.Stack;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class CCNode {
    public Vector children = new Vector(1, 5);
    public int _alphaRaw = -16777216;
    final Stack markedForRemoval = new Stack();
    boolean _markedForRemoval = false;
    boolean _actionsPaused = false;
    final CCPoint drawPosition = CCPoint.zero();
    public int tag = -1;
    public int width;
    public int height;
    public boolean isRelativeParentAnchorPoint = false;
    public boolean isRelativeAnchorPoint = true;
    public int zOrder = -1;
    int rotation = 0;
    public CCPointF scale = CCPointF.ccp(1.0f, 1.0f);
    public CCPoint position = CCPoint.zero();
    public boolean visible = true;
    public boolean isTouchEnabled = true;
    public CCPoint anchorPoint = CCPoint.ccp(50, 50);
    public CCNode parent = null;
    private Vector actions = new Vector(2, 1);

    public static final CCNode node() {
        return new CCNode();
    }

    public static void printNodeStructure(CCNode node) {
        System.out.println("------------------------------------------");
        CCNode.printNodeTree(node, "-");
        System.out.println("------------------------------------------");
    }

    private static void printNodeTree(CCNode node, String depth) {
        String nextDepth = depth + "-";
        String tmpDepth = depth;
        if (node.children.size() > 0) {
            tmpDepth = tmpDepth.substring(0, tmpDepth.length() - 1) + "o";
            nextDepth = nextDepth.substring(depth.length());
            for (int i = 0; i < depth.length(); ++i) {
                nextDepth = "|" + nextDepth;
            }
        }
        try {
            CCSprite tSprite = (CCSprite)node;
            System.out.println(tmpDepth + " " + node.getClass().getName() + " tag: " + node.tag + " filename: " + tSprite.spriteFrame.name + " zOrder:" + node.zOrder);
        }
        catch (Exception e) {
            System.out.println(tmpDepth + " " + node.getClass().getName() + " tag: " + node.tag + " zOrder:" + node.zOrder);
        }
        for (int i = 0; i < node.children.size(); ++i) {
            CCNode.printNodeTree((CCNode)node.children.elementAt(i), nextDepth);
        }
    }

    public void pauseAllActions(boolean withChildren) {
        this._actionsPaused = true;
        int i = this.actions.size();
        while (i-- != 0) {
            ((CCAction)this.actions.elementAt(i)).pause();
        }
        if (withChildren) {
            i = this.children.size();
            while (i-- != 0) {
                ((CCNode)this.children.elementAt(i)).pauseAllActions(withChildren);
            }
        }
    }

    public void resumeAllActions(boolean withChildren) {
        this._actionsPaused = false;
        int i = this.actions.size();
        while (i-- != 0) {
            ((CCAction)this.actions.elementAt(i)).resume();
        }
        if (withChildren) {
            i = this.children.size();
            while (i-- != 0) {
                ((CCNode)this.children.elementAt(i)).resumeAllActions(withChildren);
            }
        }
    }

    public boolean actionsPaused() {
        return this._actionsPaused;
    }

    public void addChild(CCNode node) {
        if (node != null && node != this) {
            if (node.parent == null) {
                node._markedForRemoval = false;
                this.markedForRemoval.removeElement(node);
                if (!this.children.contains(node)) {
                    this.children.addElement(node);
                }
                CCNode parentToCheck = node.parent = this;
                while (parentToCheck != null) {
                    if (CCDirector.sharedDirector().runningScene.equals(parentToCheck)) {
                        node.onEnter();
                        break;
                    }
                    parentToCheck = parentToCheck.parent;
                }
                this.sortChildrenByZOrder();
            } else {
                cocos2d.CCLog("addChild: the CCNode already has a parent");
            }
        } else if (node == null) {
            cocos2d.CCLog("addChild: the CCNode is null");
        } else {
            cocos2d.CCLog("addChild: cannot add a node to itself");
        }
    }

    public void addChild(CCNode child, int zOrder) {
        if (child != null) {
            child.zOrder = zOrder;
            this.addChild(child);
        } else {
            cocos2d.CCLog("addChild: the CCNode is null");
        }
    }

    public void addChild(CCNode child, int zOrder, int tag) {
        if (child != null) {
            child.tag = tag;
            this.addChild(child, zOrder);
        } else {
            cocos2d.CCLog("addChild: the CCNode is null");
        }
    }

    public final void reorderChild(CCNode child, int zOrder) {
        if (this.children.contains(child)) {
            child.zOrder = zOrder;
            this.sortChildrenByZOrder();
        } else {
            cocos2d.CCLog("The parameter CCNode is not a child of this CCNode.");
        }
    }

    public void removeFromParent(boolean cleanup) {
        if (this.parent != null) {
            this.parent.removeChild(this, cleanup);
        } else if (cleanup) {
            this.stopAllActions();
        }
    }

    public void removeChild(CCNode node, boolean cleanup) {
        if (node != null && node.parent == this && !node._markedForRemoval) {
            node.onExit();
            if (cleanup) {
                node.stopAllActions();
            }
            this.markedForRemoval.push(node);
            node.parent = null;
            node._markedForRemoval = true;
        }
    }

    public void removeChildByTag(int tag, boolean cleanup) {
        this.removeChild(this.getChildByTag(tag), cleanup);
    }

    public final CCNode getChildByTag(int tag) {
        int i = this.children.size();
        while (i-- != 0) {
            CCNode tmpChild = (CCNode)this.children.elementAt(i);
            if (tmpChild.tag != tag) continue;
            return tmpChild;
        }
        cocos2d.CCLog("getChildByTag cannot find a child with tag " + tag);
        return null;
    }

    public void removeAllChildren(boolean cleanup) {
        int i = this.children.size();
        while (i-- != 0) {
            this.removeChild((CCNode)this.children.elementAt(i), cleanup);
            ((CCNode)this.children.elementAt((int)i))._markedForRemoval = false;
        }
        this.children.removeAllElements();
        this.markedForRemoval.removeAllElements();
    }

    public void setAnchorPoint(CCPoint anchorPoint) {
        this.setAnchorPoint(anchorPoint.x, anchorPoint.y);
    }

    public void setAnchorPoint(int x, int y) {
        this.anchorPoint.x = x;
        this.anchorPoint.y = y;
    }

    public void setScale(int scale) {
        this.setScale(scale, scale);
    }

    public void setScale(CCPoint scale) {
        this.setScale(scale.x, scale.y);
    }

    public void setScale(int scaleX, int scaleY) {
        this.scale.x = scaleX;
        this.scale.y = scaleY;
    }

    public void setScale(float scaleX, float scaleY) {
        this.scale.x = scaleX;
        this.scale.y = scaleY;
    }

    public void setScale(float newScale) {
        this.scale.x = newScale;
        this.scale.y = newScale;
    }

    public void setScale(CCPointF newScale) {
        this.scale.x = newScale.x;
        this.scale.y = newScale.y;
    }

    public void setAlpha(int newAlpha) {
        this._alphaRaw = newAlpha << 24;
    }

    public int getAlpha() {
        return this._alphaRaw >> 24 & 0xFF;
    }

    public void setPosition(CCPoint position) {
        this.setPosition(position.x, position.y);
    }

    public void setPosition(int x, int y) {
        this.position.x = x;
        this.position.y = y;
    }

    public void setRotation(int angle) {
        this.rotation = angle;
    }

    public int getRotation() {
        return this.rotation;
    }

    public final int numberOfRunningActions() {
        return this.actions.size();
    }

    public final void runAction(CCAction action) {
        if (this._actionsPaused) {
            action.pause();
        }
        this.actions.addElement(action);
    }

    public final void stopAllActions() {
        this.actions.removeAllElements();
    }

    public final void stopActionByTag(int tag) {
        int i = this.actions.size();
        while (i-- != 0) {
            if (((CCAction)this.actions.elementAt((int)i)).tag != tag) continue;
            this.actions.removeElementAt(i);
            break;
        }
    }

    public final CCAction getActionByTag(int tag) {
        int i = this.actions.size();
        while (i-- != 0) {
            if (((CCAction)this.actions.elementAt((int)i)).tag != tag) continue;
            return (CCAction)this.actions.elementAt(i);
        }
        return null;
    }

    public void draw(Graphics g) {
    }

    public void visit(Graphics g, long dt, boolean parentVisible, boolean drawSelf) {
        int childCount;
        boolean ourRealVisibility;
        if (!this._actionsPaused) {
            for (int i = 0; i < this.actions.size(); ++i) {
                CCAction activeAction = null;
                try {
                    activeAction = (CCAction)this.actions.elementAt(i);
                    if (activeAction.isPaused) continue;
                    activeAction.update(this, dt);
                    if (!activeAction.isFinished) continue;
                    this.actions.removeElement(activeAction);
                    continue;
                }
                catch (Exception e) {
                    if (activeAction != null) {
                        cocos2d.CCLog("CCNode: Action update failed " + activeAction.toString() + "(" + e.toString() + ")");
                    }
                    this.actions.removeElement(activeAction);
                    continue;
                }
                catch (Error e) {
                    if (activeAction != null) {
                        cocos2d.CCLog("CCNode: Action update failed " + activeAction.toString() + "(" + e.toString() + ")");
                        this.actions.removeElement(activeAction);
                    }
                    System.gc();
                }
            }
        }
        boolean bl = ourRealVisibility = this.visible && this._alphaRaw != 0 && parentVisible && !this._markedForRemoval;
        if (ourRealVisibility && drawSelf) {
            try {
                this.draw(g);
            }
            catch (Exception e) {
                cocos2d.CCLog("CCNode: Draw self (" + this.toString() + ") failed: " + e.toString());
            }
        }
        if ((childCount = this.children.size()) > 0) {
            for (int i = 0; i < childCount; ++i) {
                CCNode child = null;
                try {
                    child = (CCNode)this.children.elementAt(i);
                    child.visit(g, dt, ourRealVisibility, true);
                    continue;
                }
                catch (Exception e) {
                    if (child == null) break;
                    cocos2d.CCLog("CCNode: Drawing child(" + child.toString() + ") failed: " + e.toString());
                    break;
                }
            }
            while (!this.markedForRemoval.empty()) {
                Object lastElement = this.markedForRemoval.pop();
                this.children.removeElement(lastElement);
                ((CCNode)lastElement)._markedForRemoval = false;
            }
        }
    }

    public void getScreenPosition(CCPoint drawPosition) {
        if (this.isRelativeParentAnchorPoint) {
            this.getScreenPositionWithAP(drawPosition);
        } else {
            drawPosition.x = this.position.x;
            drawPosition.y = this.position.y;
            CCNode node = this;
            CCScene runningScene = CCDirector.sharedDirector().runningScene;
            while (node.parent != null && node.parent != runningScene) {
                drawPosition.x += node.parent.position.x;
                drawPosition.y += node.parent.position.y;
                node = node.parent;
            }
        }
    }

    static final void NOKIA_POS_FIX_HACK(CCPoint drawPosition) {
        if ((cocos2d.settings & 0x20L) != 0L) {
            ++drawPosition.y;
        }
    }

    public void getScreenPositionWithAP(CCPoint drawPosition) {
        drawPosition.x = this.position.x;
        drawPosition.y = this.position.y;
        CCNode node = this;
        CCScene runningScene = CCDirector.sharedDirector().runningScene;
        while (node.parent != null && node.parent != runningScene) {
            drawPosition.x += node.parent.position.x;
            drawPosition.y += node.parent.position.y;
            if (node.parent.anchorPoint.x != 0 || node.parent.anchorPoint.y != 0) {
                if (node.parent.width > 0) {
                    drawPosition.x = drawPosition.x - (node.parent.anchorPoint.x == 0 ? 0 : node.parent.width / (100 / node.parent.anchorPoint.x));
                }
                if (node.parent.height > 0) {
                    drawPosition.y = drawPosition.y - (node.parent.anchorPoint.y == 0 ? 0 : node.parent.height / (100 / node.parent.anchorPoint.y));
                }
            }
            node = node.parent;
        }
    }

    public boolean ccTouchBegan(CCTouch touch) {
        return false;
    }

    public void ccTouchMoved(CCTouch touch) {
    }

    public void ccTouchEnded(CCTouch touch) {
    }

    public boolean ccKeyDown(int keyCode) {
        return false;
    }

    public boolean ccKeyUp(int keyCode) {
        return false;
    }

    public void onEnter() {
        Object[] childrenArray = new CCNode[this.children.size()];
        this.children.copyInto(childrenArray);
        for (int i = 0; i < childrenArray.length; ++i) {
            ((CCNode)childrenArray[i]).onEnter();
        }
    }

    public void onExit() {
        Object[] childrenArray = new CCNode[this.children.size()];
        this.children.copyInto(childrenArray);
        int i = childrenArray.length;
        while (i-- != 0) {
            ((CCNode)childrenArray[i]).onExit();
        }
    }

    public void itemClicked(CCNode node) {
    }

    public final void sortChildrenByZOrder() {
        this.children = CCNode.sort(this.children);
    }

    private static final CCNode[] vectorToArray(Vector vector) {
        Object[] retArray = new CCNode[vector.size()];
        vector.copyInto(retArray);
        return retArray;
    }

    private static final Vector arrayToVector(final CCNode[] array) {
        Vector retVector = new Vector(0){
            {
                this.elementData = array;
                this.elementCount = this.elementData.length;
                this.capacityIncrement = 5;
            }
        };
        return retVector;
    }

    private static final Vector sort(Vector children) {
        if (children.size() < 2) {
            return children;
        }
        return CCNode.arrayToVector(CCNode.sortArray(CCNode.vectorToArray(children)));
    }

    private static final CCNode[] sortArray(CCNode[] a) {
        CCNode[] aux = new CCNode[a.length];
        System.arraycopy(a, 0, aux, 0, aux.length);
        CCNode.mergeSort(aux, a, 0, a.length, 0);
        return a;
    }

    private static final void mergeSort(CCNode[] src, CCNode[] dest, int low, int high, int off) {
        int length = high - low;
        if (length < 10) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && dest[j - 1].zOrder - dest[j].zOrder > 0; --j) {
                    CCNode tmpNode = dest[j];
                    dest[j] = dest[j - 1];
                    dest[j - 1] = tmpNode;
                }
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >>> 1;
        CCNode.mergeSort(dest, src, low, mid, -off);
        CCNode.mergeSort(dest, src, mid, high, -off);
        if (src[mid - 1].zOrder - src[mid].zOrder <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = destLow; i < destHigh; ++i) {
            dest[i] = q >= high || p < mid && src[p].zOrder - src[q].zOrder <= 0 ? src[p++] : src[q++];
        }
    }
}

