/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.nodes;

import cocos2d.cocos2d;
import cocos2d.nodes.CCLayerColor;
import javax.microedition.lcdui.Graphics;

public class CCLayerGradient
extends CCLayerColor {
    int segments = 0;
    public int endColor = 0;
    public int color = 0;

    public static final CCLayerGradient layer(int width, int height, int startColor, int endColor, int segments) {
        return new CCLayerGradient(width, height, startColor, endColor, segments);
    }

    public CCLayerGradient(int width, int height, int startColor, int endColor, int segments) {
        super(width, height, startColor);
        if (segments > height) {
            segments = height;
        }
        if (segments > 255) {
            segments = 255;
        }
        this.color = startColor;
        this.endColor = endColor;
        this.segments = segments;
    }

    public void draw(Graphics g) {
        this.getScreenPosition(this.drawPosition);
        int scaledWidth = (int)((float)this.width * this.scale.x);
        int scaledHeight = (int)((float)this.height * this.scale.y);
        if (this.isRelativeAnchorPoint) {
            this.drawPosition.x = this.drawPosition.x - (this.anchorPoint.x == 0 ? 0 : scaledWidth / (100 / this.anchorPoint.x));
            this.drawPosition.y = this.drawPosition.y - (this.anchorPoint.y == 0 ? 0 : scaledHeight / (100 / this.anchorPoint.y));
        }
        int layerTop = this.drawPosition.y + scaledHeight;
        int layerBottom = this.drawPosition.y;
        cocos2d.setClip(g, this.drawPosition.x, -layerTop, scaledWidth, scaledHeight);
        int segmentSize = scaledHeight / this.segments;
        int extraPadding = scaledHeight - this.segments * segmentSize;
        if (extraPadding > 0 && layerTop - extraPadding < cocos2d.SCREEN_HEIGHT) {
            g.setColor(this.color | this._alphaRaw);
            g.fillRect(this.drawPosition.x, -layerTop, scaledWidth, extraPadding);
        }
        int i = this.segments;
        while (i-- != 0) {
            int segmentBottom = layerBottom + i * segmentSize;
            if (segmentBottom > cocos2d.SCREEN_HEIGHT) continue;
            int segmentTop = segmentBottom + segmentSize;
            if (segmentTop < 0) break;
            g.setColor(CCLayerGradient.midColorNoShift(this.color, this.endColor, i, this.segments) | this._alphaRaw);
            g.fillRect(this.drawPosition.x, -segmentTop, scaledWidth, segmentSize);
        }
    }

    public static int midColorNoShift(int color1, int color2, int first, int max) {
        int remainder = max - first;
        int red = ((color1 & 0xFF0000) * first + (color2 & 0xFF0000) * remainder) / max;
        int green = ((color1 & 0xFF00) * first + (color2 & 0xFF00) * remainder) / max;
        int blue = ((color1 & 0xFF) * first + (color2 & 0xFF) * remainder) / max;
        return red & 0xFF0000 | green & 0xFF00 | blue;
    }
}

