/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.nodes;

import cocos2d.cocos2d;
import cocos2d.nodes.CCLabelTTF;
import cocos2d.nodes.CCNode;
import cocos2d.types.BMFont;
import cocos2d.types.FontCharacter;
import cocos2d.types.MutableInteger;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public final class CCLabelBMFont
extends CCNode {
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int ALIGNMENT_CENTER = 1;
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_DEFAULT = -1;
    public int textAlignment = -1;
    String string = "";
    private final Vector wrappedLines = new Vector(10, 5);
    private BMFont font = null;
    private int lineSpacing = 4;
    private int fontHeight = 0;
    private final MutableInteger tMyInt = new MutableInteger(0);
    private int maxLineWidth = Integer.MAX_VALUE;
    private CCLabelTTF fallbackObject;
    private boolean fallbackEnabled = false;

    public static final CCLabelBMFont labelWithString(String text, String fntFile) {
        return new CCLabelBMFont(text, fntFile);
    }

    public CCLabelBMFont(String string, String fntFile) {
        if (fntFile != null) {
            try {
                this.font = BMFont.getFont(fntFile);
                this.fontHeight = this.font.fontHeight("AOIZX|1aoijx");
            }
            catch (Exception e) {
                this.fallbackTTFFont();
                cocos2d.CCLog("BMFont creation exception: " + e.toString());
            }
        }
        this.maxLineWidth = cocos2d.SCREEN_WIDTH;
        this.setString(string);
    }

    void recalculateDimensions() {
        if (!this.fallbackEnabled) {
            CCLabelBMFont.wrapToLines(this.string, this.font, this.maxLineWidth, this.wrappedLines);
            this.width = Integer.MIN_VALUE;
            for (int i = 0; i < this.wrappedLines.size(); ++i) {
                int tWidth = this.font.stringWidth((String)this.wrappedLines.elementAt(i));
                if (this.width >= tWidth) continue;
                this.width = tWidth;
            }
            this.height = this.wrappedLines.size() * (this.fontHeight + this.lineSpacing) - this.lineSpacing;
        }
    }

    public void setString(String string) {
        if (this.string == null ? string != null : !this.string.equals(string)) {
            this.string = string;
            this.recalculateDimensions();
        }
    }

    public void setLineSpacing(int newSpacing) {
        if (this.lineSpacing != newSpacing) {
            this.lineSpacing = newSpacing;
            this.recalculateDimensions();
        }
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public void setMaxLineWidth(int newWidth) {
        if (this.maxLineWidth != newWidth) {
            this.maxLineWidth = newWidth;
            this.recalculateDimensions();
        }
    }

    public int getMaxLineWidth() {
        return this.maxLineWidth;
    }

    public String getString() {
        return this.string;
    }

    public void setScale(int x, int y) {
        cocos2d.CCLog("WARINING: CCLabelBMFont does not support scale modification");
    }

    public void setRotation(int rotation) {
        cocos2d.CCLog("WARINING: CCLabelBMFont does not support rotation");
    }

    public static void wrapToLines(String text, BMFont f, int maxWidth, Vector lines) {
        lines.removeAllElements();
        if (text == null || f == null) {
            return;
        }
        if (text.indexOf(10) == -1 && f.stringWidth(text) < maxWidth) {
            lines.addElement(text);
        } else {
            char[] chars = text.toCharArray();
            int len = chars.length;
            int charWidth = 0;
            int curLinePosStart = 0;
            for (int count = 0; count < len; ++count) {
                boolean paragraphFormat;
                if (charWidth == 0 && curLinePosStart < count) {
                    charWidth = f.stringWidth(new String(chars, curLinePosStart, count - curLinePosStart));
                }
                if ((charWidth += f.charWidth(chars[count])) <= maxWidth - 4 && chars[count] != '\n' && count != len - 1) continue;
                boolean bl = paragraphFormat = chars[count] != '\n';
                if (count == len - 1) {
                    ++count;
                    paragraphFormat = false;
                }
                String line = new String(chars, curLinePosStart, count - curLinePosStart);
                if (paragraphFormat) {
                    int lastSpacePosition = line.lastIndexOf(32);
                    if (lastSpacePosition == -1) {
                        lines.addElement(line);
                        curLinePosStart = count;
                    } else {
                        String l = new String(chars, curLinePosStart, lastSpacePosition);
                        lines.addElement(l);
                        curLinePosStart = curLinePosStart + lastSpacePosition + 1;
                    }
                } else {
                    lines.addElement(line);
                    curLinePosStart = count < len && chars[count] == '\n' ? count + 1 : count;
                }
                charWidth = 0;
            }
        }
    }

    public void fallbackTTFFont() {
        if (!this.fallbackEnabled) {
            this.fallbackEnabled = true;
            this.fallbackObject = CCLabelTTF.labelWithString(this.string);
            this.fallbackObject.setStrokeEnabled(true);
            this.width = this.fallbackObject.width;
            this.height = this.fallbackObject.height;
        }
    }

    public void draw(Graphics g) {
        if (!this.fallbackEnabled) {
            g.setColor(this._alphaRaw);
            int cursor_x = 0;
            int cursor_y = 0;
            Hashtable charset = this.font.font;
            this.getScreenPosition(this.drawPosition);
            if (this.isRelativeAnchorPoint) {
                this.drawPosition.x = this.drawPosition.x - (this.anchorPoint.x == 0 ? 0 : this.width / (100 / this.anchorPoint.x));
                this.drawPosition.y = -(this.drawPosition.y + (this.anchorPoint.y == 0 ? this.height : this.height - this.height / (100 / this.anchorPoint.y)));
            } else {
                this.drawPosition.y = -this.drawPosition.y;
            }
            int wrappedLinesCount = this.wrappedLines.size();
            for (int k = 0; k < wrappedLinesCount; ++k) {
                String tLine = (String)this.wrappedLines.elementAt(k);
                if (this.textAlignment == 1) {
                    cursor_x = this.width - this.font.stringWidth(tLine) >> 1;
                } else if (this.textAlignment == 2) {
                    cursor_x = this.width - this.font.stringWidth(tLine);
                }
                int lineLength = tLine.length();
                for (int i = 0; i < lineLength; ++i) {
                    char c = tLine.charAt(i);
                    FontCharacter myChar = (FontCharacter)charset.get(this.tMyInt.set(c));
                    if (myChar == null) continue;
                    int posX = this.drawPosition.x + cursor_x + myChar.xoffset;
                    int posY = this.drawPosition.y + cursor_y + myChar.yoffset;
                    cocos2d.setClip(g, posX, posY, myChar.charWidth, myChar.charHeight);
                    g.drawImage(this.font.image, posX - myChar.x, posY - myChar.y, 20);
                    cursor_x += myChar.xadvance;
                }
                cursor_x = 0;
                cursor_y += this.fontHeight + this.lineSpacing;
            }
        } else {
            this.fallbackObject.setString(this.string);
            this.fallbackObject.parent = this.parent;
            this.fallbackObject.position = this.position;
            this.fallbackObject.anchorPoint = this.anchorPoint;
            this.fallbackObject.isRelativeParentAnchorPoint = this.isRelativeParentAnchorPoint;
            this.fallbackObject.isRelativeAnchorPoint = this.isRelativeAnchorPoint;
            this.fallbackObject.textAlignment = this.textAlignment;
            this.fallbackObject.setMaxLineWidth(this.maxLineWidth);
            this.fallbackObject.color = -1;
            this.width = this.fallbackObject.width;
            this.height = this.fallbackObject.height;
            this.fallbackObject.draw(g);
        }
    }
}

