/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.extensions;

import cocos2d.CCDirector;
import cocos2d.CCKeyboardManager;
import cocos2d.CCTouchDispatcher;
import cocos2d.actions.CCAction;
import cocos2d.actions.CCCallFuncND;
import cocos2d.actions.CCMoveTo;
import cocos2d.actions.CCSequence;
import cocos2d.cocos2d;
import cocos2d.extensions.CCScrollLayerDelegate;
import cocos2d.nodes.CCNode;
import cocos2d.types.CCFunctionND;
import cocos2d.types.CCPoint;
import cocos2d.types.CCTouch;
import javax.microedition.lcdui.Graphics;

public class CCScrollLayer
extends CCNode {
    final CCScrollLayerDelegate delegate;
    public int TOUCH_DEADZONE = 15;
    public boolean snapping = false;
    public boolean isKeyboardScrollingEnabled = true;
    public boolean verticalScrolling = false;
    public boolean horizontalScrolling = true;
    private boolean isScrolling = false;
    private boolean touchBegan = true;
    public int screenCount = 1;
    public int currentScreen = 0;
    public final CCPoint indicatorPosition = CCPoint.ccp(cocos2d.SCREEN_WIDTH / 2, cocos2d.SCREEN_HEIGHT - 20);
    public final CCPoint contentSize = CCPoint.zero();
    final CCPoint drawPosition = CCPoint.zero();
    public final CCPoint scrollAmount = CCPoint.zero();
    final CCPoint lastScrollAmount = CCPoint.zero();
    final CCPoint lastTouchPos = CCPoint.ccp(-1, -1);
    long lastDtTimer = -1L;
    private CCPoint clipPosition = null;
    boolean bbScrollDown = false;
    boolean bbScrollUp = false;
    boolean bbScrollLeft = false;
    boolean bbScrollRight = false;

    public CCScrollLayer(int width, int height, boolean snapping, CCScrollLayerDelegate delegate) {
        this.setAnchorPoint(0, 0);
        this.width = width;
        this.height = height;
        this.snapping = snapping;
        this.delegate = delegate;
        this.TOUCH_DEADZONE = cocos2d.SCREEN_WIDTH / 20;
    }

    private boolean isTouchInBounds(CCPoint touch) {
        if (this.isTouchEnabled) {
            int cropW = (int)((float)this.width * this.scale.x);
            int cropH = (int)((float)this.height * this.scale.y);
            this.getScreenPosition(this.drawPosition);
            this.drawPosition.x = this.drawPosition.x - (this.anchorPoint.x == 0 ? 0 : cropW / (100 / this.anchorPoint.x)) - this.lastScrollAmount.x;
            this.drawPosition.y = this.drawPosition.y - (this.anchorPoint.y == 0 ? 0 : cropH / (100 / this.anchorPoint.y)) - this.lastScrollAmount.y;
            return this.drawPosition.x <= touch.x && this.drawPosition.y <= touch.y && this.drawPosition.y + cropH >= touch.y && this.drawPosition.x + cropW >= touch.x;
        }
        return false;
    }

    public boolean ccKeyUp(int keyCode) {
        if (this.delegate != null && (keyCode == CCKeyboardManager.KC_5 || keyCode == CCKeyboardManager.KC_CLICK)) {
            this.delegate.onScrollClicked(this.currentScreen);
            return true;
        }
        if (CCDirector.sharedDirector().platformName.equals("BlackBerry")) {
            if (keyCode == CCKeyboardManager.KC_UP || keyCode == CCKeyboardManager.KC_2) {
                this.bbScrollUp = true;
            } else if (keyCode == CCKeyboardManager.KC_DOWN || keyCode == CCKeyboardManager.KC_8) {
                this.bbScrollDown = true;
            } else if (keyCode == CCKeyboardManager.KC_LEFT || keyCode == CCKeyboardManager.KC_4) {
                this.bbScrollLeft = true;
            } else if (keyCode == CCKeyboardManager.KC_RIGHT || keyCode == CCKeyboardManager.KC_6) {
                this.bbScrollRight = true;
            }
        }
        if (this.isKeyboardScrollingEnabled && (keyCode == CCKeyboardManager.KC_UP || keyCode == CCKeyboardManager.KC_DOWN)) {
            return true;
        }
        if (keyCode == CCKeyboardManager.KC_LEFT || keyCode == CCKeyboardManager.KC_4) {
            if (this.snapping) {
                this.goToScreen(this.currentScreen - 1);
            }
            if (this.snapping || this.isKeyboardScrollingEnabled) {
                return true;
            }
        } else if (keyCode == CCKeyboardManager.KC_RIGHT || keyCode == CCKeyboardManager.KC_6) {
            if (this.snapping) {
                this.goToScreen(this.currentScreen + 1);
            }
            if (this.snapping || this.isKeyboardScrollingEnabled) {
                return true;
            }
        }
        return super.ccKeyUp(keyCode);
    }

    public boolean ccTouchBegan(CCTouch touch) {
        if (this.isTouchInBounds(touch.position)) {
            this.touchBegan = true;
            this.lastTouchPos.set(touch.position);
            return true;
        }
        return false;
    }

    public void ccTouchMoved(CCTouch touch) {
        int touchDistX = touch.position.x - this.lastTouchPos.x + (touch.position.x - this.lastTouchPos.x >> 1);
        int touchDistY = touch.position.y - this.lastTouchPos.y + (touch.position.y - this.lastTouchPos.y >> 1);
        if (this.isTouchInBounds(touch.position) && (this.isScrolling || Math.abs(touchDistX) > this.TOUCH_DEADZONE || Math.abs(touchDistY) > this.TOUCH_DEADZONE)) {
            this.isScrolling = true;
            if (this.horizontalScrolling) {
                this.scrollAmount.x += touchDistX;
            }
            if (this.verticalScrolling) {
                this.scrollAmount.y += touchDistY;
            }
            this.lastTouchPos.set(touch.position);
        }
    }

    public void ccTouchEnded(CCTouch touch) {
        if (this.isScrolling && this.isTouchInBounds(touch.position)) {
            int touchDistX = touch.position.x - this.lastTouchPos.x + (touch.position.x - this.lastTouchPos.x >> 1);
            int touchDistY = touch.position.y - this.lastTouchPos.y + (touch.position.y - this.lastTouchPos.y >> 1);
            if (this.horizontalScrolling) {
                this.scrollAmount.x += touchDistX;
            }
            if (this.verticalScrolling) {
                this.scrollAmount.y += touchDistY;
            }
        } else if (!this.isScrolling && this.touchBegan && this.delegate != null) {
            this.delegate.onScrollClicked(this.currentScreen);
        }
        if (this.snapping) {
            this.goToScreen((-this.lastScrollAmount.x + this.width / 2) / (this.contentSize.x / (this.screenCount << 1)) / 2 + 1);
        }
        this.isScrolling = false;
    }

    public void onEnter() {
        CCTouchDispatcher.sharedDispatcher().addTargetedDelegate(this);
        CCKeyboardManager.sharedManager().addTargetedDelegate(this);
        super.onEnter();
    }

    public void onExit() {
        CCTouchDispatcher.sharedDispatcher().removeDelegate(this);
        CCKeyboardManager.sharedManager().removeDelegate(this);
        super.onExit();
    }

    public void goToScreen(int screenNumber) {
        if (screenNumber > 0 && screenNumber <= this.screenCount) {
            this.currentScreen = screenNumber;
            int newX = (screenNumber - 1) * this.width;
            if (this.scrollAmount.x != -newX) {
                this.stopAllActions();
                CCFunctionND resetCoords = new CCFunctionND(){

                    public void function(CCNode node, Object data) {
                        node.position.x -= ((CCPoint)data).x;
                        ((CCScrollLayer)node).scrollAmount.x = ((CCPoint)data).x;
                        ((CCScrollLayer)node).lastScrollAmount.x = 0;
                    }
                };
                this.runAction(CCSequence.action(new CCAction[]{CCMoveTo.action(CCPoint.ccp(-newX, 0), 200L), CCCallFuncND.action(resetCoords, CCPoint.ccp(-newX, 0))}));
            }
        }
    }

    public void visit(Graphics g, long dt, boolean parentVisible, boolean drawSelf) {
        if (this.clipPosition == null) {
            this.clipPosition = new CCPoint(this.position.x, -(this.position.y + this.height));
        }
        cocos2d.setClip(g, this.clipPosition.x, this.clipPosition.y, this.width, this.height);
        cocos2d.lockClip();
        super.visit(g, dt, parentVisible, drawSelf);
        if (this.snapping && this.horizontalScrolling) {
            int circlesY = -this.indicatorPosition.y;
            int cirlceSize = 8;
            int circleDistance = cirlceSize + 8;
            cocos2d.setClip(g, 0, -cocos2d.SCREEN_HEIGHT, cocos2d.SCREEN_WIDTH, cocos2d.SCREEN_HEIGHT);
            g.setColor(-1);
            int circleStart = this.screenCount / 2 * circleDistance;
            g.fillRoundRect(this.indicatorPosition.x - circleStart + circleDistance * (this.currentScreen - 1) - cirlceSize / 2, circlesY, cirlceSize, cirlceSize, cirlceSize, cirlceSize);
            g.setColor(-16777216);
            for (int i = 0; i < this.screenCount; ++i) {
                g.drawRoundRect(cocos2d.SCREEN_WIDTH / 2 - circleStart + circleDistance * i - cirlceSize / 2, circlesY, cirlceSize, cirlceSize, cirlceSize, cirlceSize);
            }
            g.drawString(" ", 0, 0, 0);
        }
        cocos2d.unlockClip();
    }

    public void draw(Graphics g) {
        if (this.isKeyboardScrollingEnabled) {
            int dt = 1;
            if (this.lastDtTimer != -1L) {
                dt = (int)(CCDirector.deltaTimer - this.lastDtTimer);
            }
            this.lastDtTimer = CCDirector.deltaTimer;
            if (this.lastDtTimer < 10L) {
                this.lastDtTimer = 10L;
            }
            if (CCKeyboardManager.sharedManager().isKeyPressed(CCKeyboardManager.KC_UP) || this.bbScrollUp) {
                this.scrollAmount.y -= dt / 10;
            } else if (CCKeyboardManager.sharedManager().isKeyPressed(CCKeyboardManager.KC_DOWN) || this.bbScrollDown) {
                this.scrollAmount.y += dt / 10;
            }
            if (!this.snapping) {
                if (CCKeyboardManager.sharedManager().isKeyPressed(CCKeyboardManager.KC_LEFT) || this.bbScrollLeft) {
                    this.scrollAmount.x += dt / 10;
                } else if (CCKeyboardManager.sharedManager().isKeyPressed(CCKeyboardManager.KC_RIGHT) || this.bbScrollRight) {
                    this.scrollAmount.x -= dt / 10;
                }
            }
            this.bbScrollRight = false;
            this.bbScrollLeft = false;
            this.bbScrollUp = false;
            this.bbScrollDown = false;
        }
        if (this.scrollAmount.x > 0 || this.contentSize.x <= this.width) {
            this.scrollAmount.x = 0;
        } else if (this.scrollAmount.x < -(this.contentSize.x - this.width)) {
            this.scrollAmount.x = -(this.contentSize.x - this.width);
        }
        if (this.scrollAmount.y < 0 || this.contentSize.y <= this.height) {
            this.scrollAmount.y = 0;
        } else if (this.scrollAmount.y > this.contentSize.y - this.height) {
            this.scrollAmount.y = this.contentSize.y - this.height;
        }
        this.position.set(this.position.x - this.lastScrollAmount.x + this.scrollAmount.x, this.position.y - this.lastScrollAmount.y + this.scrollAmount.y);
        this.lastScrollAmount.set(this.scrollAmount);
        this.currentScreen = (-this.lastScrollAmount.x + this.width / 2) / (this.contentSize.x / (this.screenCount << 1)) / 2 + 1;
        if (this.currentScreen > this.screenCount) {
            this.currentScreen = this.screenCount;
        }
        if (this.currentScreen < 1) {
            this.currentScreen = 1;
        }
    }
}

