/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.extensions;

import cocos2d.cocos2d;
import cocos2d.nodes.CCLayerColor;
import cocos2d.types.CCPoint;
import javax.microedition.lcdui.Graphics;

public class CCLayerGradientRounded
extends CCLayerColor {
    int roundAmount = 0;
    int segments = 0;
    CCPoint drawPosition = CCPoint.zero();
    public int endColor = 0;
    public int color = 0;

    public static final CCLayerGradientRounded layer(int width, int height, int startColor, int endColor, int round, int segments) {
        return new CCLayerGradientRounded(width, height, startColor, endColor, round, segments);
    }

    public CCLayerGradientRounded(int width, int height, int startColor, int endColor, int round, int segments) {
        super(width, height, startColor);
        if (height - round < segments) {
            segments = height - round;
        }
        this.color = startColor;
        this.endColor = endColor;
        this.roundAmount = round;
        this.segments = segments;
    }

    public void draw(Graphics g) {
        this.getScreenPosition(this.drawPosition);
        int scaledWidth = (int)((float)this.width * this.scale.x);
        int scaledHeight = (int)((float)this.height * this.scale.y);
        if (this.isRelativeAnchorPoint) {
            this.drawPosition.x = this.drawPosition.x - (this.anchorPoint.x == 0 ? 0 : scaledWidth / (100 / this.anchorPoint.x));
            this.drawPosition.y = this.drawPosition.y - (this.anchorPoint.y == 0 ? 0 : scaledHeight / (100 / this.anchorPoint.y));
        }
        g.setColor(this.color | this._alphaRaw);
        cocos2d.setClip(g, this.drawPosition.x, -this.drawPosition.y - scaledHeight, scaledWidth, scaledHeight);
        g.fillRoundRect(this.drawPosition.x, -this.drawPosition.y - scaledHeight, scaledWidth, scaledHeight >> 1, this.roundAmount, this.roundAmount);
        g.setColor(this.endColor | this._alphaRaw);
        g.fillRoundRect(this.drawPosition.x, -this.drawPosition.y - scaledHeight + (scaledHeight >> 1), scaledWidth, scaledHeight / 2, this.roundAmount, this.roundAmount);
        g.drawString(" ", 0, 0, 0);
        int segmentSize = (scaledHeight - this.roundAmount) / this.segments;
        segmentSize = (int)((float)segmentSize * this.scale.y);
        int colorDiff = 255 / (this.segments + 2);
        int halfRoundAmount = this.roundAmount >> 1;
        int i = this.segments;
        while (i-- != 0) {
            g.setColor(CCLayerGradientRounded.GetBlendedColor(this.color, this.endColor, colorDiff * (i + 1)) | this._alphaRaw);
            g.fillRect(this.drawPosition.x, -this.drawPosition.y - scaledHeight + halfRoundAmount + segmentSize * i, scaledWidth, segmentSize);
        }
    }

    private static final int GetBlendedColor(int _iColor1, int _iColor2, int _iQuantity) {
        int iFinalColor = 0;
        int iR1 = _iColor1 & 0xFF;
        int iR2 = _iColor2 & 0xFF;
        int iG1 = _iColor1 >> 8 & 0xFF;
        int iG2 = _iColor2 >> 8 & 0xFF;
        int iB1 = _iColor1 >> 16 & 0xFF;
        int iB2 = _iColor2 >> 16 & 0xFF;
        iFinalColor |= iR1 + ((iR2 - iR1) * _iQuantity >> 8);
        iFinalColor |= iG1 + ((iG2 - iG1) * _iQuantity >> 8) << 8;
        return iFinalColor |= iB1 + ((iB2 - iB1) * _iQuantity >> 8) << 16;
    }
}

