/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.extensions;

import cocos2d.cocos2d;
import cocos2d.extensions.AsyncDownloaderDelegate;
import cocos2d.extensions.MyIO;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.ContentConnection;

public class AsyncDownloader
implements Runnable {
    protected String url;
    public static boolean useRmsCache = true;
    protected AsyncDownloaderDelegate delegate;
    protected static final Vector queue = new Vector(5, 5);
    protected static int jobsRunning = 0;
    public static int MAX_CONCURRENT_DOWNLOADS = 1;

    public AsyncDownloader(String url, AsyncDownloaderDelegate delegate) {
        this.url = url;
        this.delegate = delegate;
    }

    public void run() {
        try {
            this.getFile(this.url);
        }
        catch (Exception e) {
            cocos2d.CCLog("AsyncDownloader: " + e.toString());
            if (this.delegate != null) {
                this.delegate.downloadFailed(this);
            }
            this.taskEnded();
        }
    }

    public void startAsynchronous() {
        if (jobsRunning < MAX_CONCURRENT_DOWNLOADS) {
            try {
                new Thread(this).start();
            }
            catch (Exception e) {
                cocos2d.CCLog("AsyncDownloader: " + e.toString());
                if (this.delegate != null) {
                    this.delegate.downloadFailed(this);
                }
                this.taskEnded();
            }
        } else {
            queue.addElement(this);
        }
    }

    public void startSynchronous() {
        try {
            this.getFile(this.url);
        }
        catch (Exception e) {
            cocos2d.CCLog("AsyncDownloader: " + e.toString());
            if (this.delegate != null) {
                this.delegate.downloadFailed(this);
            }
            this.taskEnded();
        }
    }

    private void taskEnded() {
        --jobsRunning;
        this.delegate = null;
        if (!queue.isEmpty()) {
            AsyncDownloader tDown = (AsyncDownloader)queue.elementAt(0);
            tDown.startAsynchronous();
            queue.removeElementAt(0);
        }
    }

    private byte[] getFromCache(String key) {
        return MyIO.loadBytes("cached_" + key.hashCode());
    }

    private void addToCache(String key, byte[] data) {
        MyIO.saveBytes("cached_" + key.hashCode(), data);
    }

    public String getUrl() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFile(String url) throws IOException {
        byte[] byteData = this.getFromCache(url);
        if (byteData != null && byteData.length > 0 && this.delegate != null) {
            this.delegate.downloadFinished(this, byteData);
            this.taskEnded();
            return;
        }
        ++jobsRunning;
        ContentConnection connection = null;
        FilterInputStream iStrm = null;
        ByteArrayOutputStream bStrm = null;
        try {
            connection = (ContentConnection)Connector.open((String)url, (int)1, (boolean)true);
            iStrm = connection.openDataInputStream();
            int length = (int)connection.getLength();
            if (length != -1) {
                byteData = new byte[length];
                ((DataInputStream)iStrm).readFully(byteData);
            } else {
                int ch;
                bStrm = new ByteArrayOutputStream();
                while ((ch = iStrm.read()) != -1) {
                    bStrm.write(ch);
                }
                byteData = bStrm.toByteArray();
                bStrm.close();
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (iStrm != null) {
                iStrm.close();
            }
            if (bStrm != null) {
                bStrm.close();
            }
        }
        try {
            if (this.delegate != null) {
                if (byteData == null) {
                    this.delegate.downloadFailed(this);
                } else {
                    this.addToCache(url, byteData);
                    this.delegate.downloadFinished(this, byteData);
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            this.taskEnded();
        }
    }
}

