/*
 * Decompiled with CFR 0.152.
 */
package cocos2d;

import cocos2d.CCDirector;
import cocos2d.MyListener;
import cocos2d.cocos2d;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public final class SimpleAudioEngine {
    static final String MEDIAID_MIDI = "audio/midi";
    static final String MEDIAID_FX = "audio/x-wav";
    static final String MEDIAID_AMR = "audio/amr";
    static final String MEDIAID_OGG = "audio/ogg";
    private int currentVolumeMusic = 90;
    private int currentVolumeFX = 100;
    private static final Hashtable cache = new Hashtable(3);
    private long lastMusicTime = 0L;
    private static final Hashtable listenerCache = new Hashtable(3);
    private static Player bgPlayer = null;
    private static MyListener bgListener = null;
    private static Player activePlayer = null;
    private static MyListener activeListener = null;
    private boolean isMuted = false;
    private String mutedMusicName = null;
    private boolean mutedMusicLooping = false;
    private boolean shouldResumeMusic = false;
    private boolean forceMuted = false;
    private static SimpleAudioEngine _sharedEngine = null;

    public static final SimpleAudioEngine sharedEngine() {
        if (_sharedEngine == null) {
            _sharedEngine = new SimpleAudioEngine();
        }
        return _sharedEngine;
    }

    public void setVolumeMusic(int volume) {
        this.currentVolumeMusic = volume;
        if (this.isBackgroundMusicPlaying()) {
            try {
                VolumeControl volumeObj = (VolumeControl)bgPlayer.getControl("VolumeControl");
                volumeObj.setLevel(this.currentVolumeMusic);
            }
            catch (Error error) {
                // empty catch block
            }
        }
    }

    public void setVolumeFx(int volume) {
        this.currentVolumeFX = volume;
    }

    public int getVolumeMusic() {
        return this.currentVolumeMusic;
    }

    public int getVolumeFX() {
        return this.currentVolumeFX;
    }

    private SimpleAudioEngine() {
    }

    public void disableAudio() {
        this.forceMuted = true;
        this.isMuted = true;
    }

    public boolean isAudioDisabled() {
        return this.forceMuted;
    }

    public void setMute(boolean mute) {
        if (this.forceMuted) {
            mute = true;
        }
        this.isMuted = mute;
        if (mute) {
            if (this.isBackgroundMusicPlaying()) {
                this.mutedMusicName = SimpleAudioEngine.bgListener.filename;
                this.mutedMusicLooping = SimpleAudioEngine.bgListener.loop;
                try {
                    this.lastMusicTime = bgPlayer.getMediaTime();
                    if (this.lastMusicTime == -1L) {
                        this.lastMusicTime = 0L;
                    }
                }
                catch (Exception e) {
                    this.lastMusicTime = 0L;
                }
            } else {
                this.mutedMusicName = null;
            }
            this.stopBackgroundMusic();
            this.stopAllEffects();
        } else if (this.mutedMusicName != null) {
            this.playBackgroundMusic(this.mutedMusicName, this.mutedMusicLooping);
            this.mutedMusicName = null;
        }
    }

    public boolean isMuted() {
        return this.isMuted;
    }

    private void playEffectDoWork(String filename, boolean clearAfterPlay) {
        if (!this.isMuted) {
            try {
                Player tmpPlayer;
                if ((cocos2d.settings & 0x40L) != 0L && activePlayer != null && activePlayer.getState() == 400) {
                    boolean clear;
                    boolean bl = clear = !filename.equals(SimpleAudioEngine.activeListener.filename);
                    if (activePlayer != bgPlayer) {
                        if (clear) {
                            try {
                                activePlayer.removePlayerListener((PlayerListener)activeListener);
                                activePlayer.stop();
                                activePlayer.close();
                            }
                            catch (MediaException mediaException) {
                                // empty catch block
                            }
                            cache.remove(SimpleAudioEngine.activeListener.filename);
                            listenerCache.remove(SimpleAudioEngine.activeListener.filename);
                        } else {
                            try {
                                activePlayer.stop();
                                activePlayer.setMediaTime(0L);
                            }
                            catch (MediaException mediaException) {
                                activePlayer.removePlayerListener((PlayerListener)activeListener);
                                activePlayer.close();
                                cache.remove(SimpleAudioEngine.activeListener.filename);
                                listenerCache.remove(SimpleAudioEngine.activeListener.filename);
                            }
                        }
                    } else {
                        activePlayer.removePlayerListener((PlayerListener)activeListener);
                        activePlayer.stop();
                        activePlayer.close();
                    }
                    activeListener = null;
                    activePlayer = null;
                }
                if ((tmpPlayer = (Player)cache.get(filename)) == null) {
                    tmpPlayer = this.preloadEffect(filename);
                }
                if (tmpPlayer == null) {
                    return;
                }
                MyListener listener = (MyListener)listenerCache.get(filename);
                listener.unloadAfterPlay = clearAfterPlay;
                try {
                    if (tmpPlayer.getState() != 300) {
                        tmpPlayer.prefetch();
                    }
                    tmpPlayer.setMediaTime(0L);
                }
                catch (MediaException mediaException) {
                    // empty catch block
                }
                try {
                    VolumeControl volumeObj = (VolumeControl)tmpPlayer.getControl("VolumeControl");
                    volumeObj.setLevel(this.currentVolumeMusic);
                }
                catch (Error e) {
                    // empty catch block
                }
                tmpPlayer.start();
                activePlayer = tmpPlayer;
                activeListener = listener;
            }
            catch (Exception ex) {
                cocos2d.CCLog("SAE:Exception: " + ex.toString());
            }
        }
    }

    public void playEffect(String filename) {
        if ((cocos2d.settings & 0x200L) != 0L || CCDirector.sharedDirector().platformName.indexOf("BlackBerry") != -1) {
            this.playEffect(filename, true);
        } else {
            this.playEffect(filename, false);
        }
    }

    public void playEffect(final String filename, final boolean clearAfterPlay) {
        if ((cocos2d.settings & 0x800L) != 0L) {
            return;
        }
        if (!cocos2d.isAndroid && (cocos2d.settings & 0x400L) == 0L) {
            this.playEffectDoWork(filename, clearAfterPlay);
        } else {
            new Thread(new Runnable(){

                public void run() {
                    SimpleAudioEngine.this.playEffectDoWork(filename, clearAfterPlay);
                }
            }).start();
        }
    }

    public void stopEffect(String filename) {
        if (cache.containsKey(filename)) {
            try {
                Player tmpPlayer = (Player)cache.get(filename);
                tmpPlayer.stop();
            }
            catch (MediaException ex) {
            }
            catch (NullPointerException ex) {
                cache.remove(filename);
                listenerCache.remove(filename);
            }
        }
    }

    public void unloadEffect(String filename) {
        if (cache.containsKey(filename)) {
            try {
                Player tmpPlayer = (Player)cache.get(filename);
                tmpPlayer.removePlayerListener((PlayerListener)listenerCache.get(filename));
                tmpPlayer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            cache.remove(filename);
            listenerCache.remove(filename);
        }
    }

    public void stopAllEffects() {
        Enumeration en = cache.keys();
        while (en.hasMoreElements()) {
            try {
                String filename = en.nextElement().toString();
                this.stopEffect(filename);
            }
            catch (Exception exception) {}
        }
    }

    public void unloadAllEffects() {
        Enumeration en = cache.keys();
        while (en.hasMoreElements()) {
            String filename = en.nextElement().toString();
            try {
                Player tmpPlayer = (Player)cache.get(filename);
                tmpPlayer.removePlayerListener((PlayerListener)listenerCache.get(filename));
                tmpPlayer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            cache.remove(filename);
            listenerCache.remove(filename);
        }
        System.gc();
    }

    public Player preloadEffect(String filename) {
        if (!this.isMuted && !cache.containsKey(filename)) {
            try {
                String MEDIA = MEDIAID_FX;
                if (filename.endsWith("mid")) {
                    MEDIA = MEDIAID_MIDI;
                } else if (filename.endsWith("amr")) {
                    MEDIA = MEDIAID_AMR;
                } else if (filename.endsWith("ogg")) {
                    MEDIA = MEDIAID_OGG;
                }
                Player tmpPlayer = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/" + filename), (String)MEDIA);
                tmpPlayer.realize();
                MyListener listener = new MyListener();
                listener.filename = filename;
                tmpPlayer.addPlayerListener((PlayerListener)listener);
                cache.put(filename, tmpPlayer);
                listenerCache.put(filename, listener);
            }
            catch (IOException ex) {
                cocos2d.CCLog("SAE:IOException " + filename + ": " + ex.toString());
            }
            catch (MediaException ex) {
                cocos2d.CCLog("SAE:MediaException " + filename + ": " + ex.toString());
            }
            catch (Exception ex) {
                cocos2d.CCLog("SAE:Exception  " + filename + ": " + ex.toString());
            }
        }
        return (Player)cache.get(filename);
    }

    private void playBgMusicDoWork(String filename, boolean loop) {
        if (!this.isMuted) {
            if (this.isBackgroundMusicPlaying() && SimpleAudioEngine.bgListener.filename.equals(filename)) {
                return;
            }
            this.stopBackgroundMusic();
            if (activePlayer != null && activePlayer != bgPlayer && (cocos2d.settings & 0x40L) != 0L) {
                activePlayer.removePlayerListener((PlayerListener)activeListener);
                activePlayer.close();
                cache.remove(SimpleAudioEngine.activeListener.filename);
                listenerCache.remove(SimpleAudioEngine.activeListener.filename);
                activeListener = null;
                activePlayer = null;
            }
            try {
                if (bgListener == null) {
                    try {
                        String MEDIA = MEDIAID_FX;
                        if (filename.endsWith("mid")) {
                            MEDIA = MEDIAID_MIDI;
                        } else if (filename.endsWith("amr")) {
                            MEDIA = MEDIAID_AMR;
                        } else if (filename.endsWith("ogg")) {
                            MEDIA = MEDIAID_OGG;
                        }
                        bgPlayer = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream("/" + filename), (String)MEDIA);
                        bgPlayer.realize();
                        bgListener = new MyListener();
                        SimpleAudioEngine.bgListener.filename = filename;
                        bgPlayer.addPlayerListener((PlayerListener)bgListener);
                    }
                    catch (IOException ex) {
                        cocos2d.CCLog("SAE:IOException " + filename + ": " + ex.toString());
                    }
                    catch (MediaException ex) {
                        cocos2d.CCLog("SAE:MediaException " + filename + ": " + ex.toString());
                    }
                    catch (Exception ex) {
                        cocos2d.CCLog("SAE:Exception  " + filename + ": " + ex.toString());
                    }
                }
                if (bgPlayer == null) {
                    return;
                }
                SimpleAudioEngine.bgListener.loop = loop;
                try {
                    if (bgPlayer.getState() != 300) {
                        bgPlayer.prefetch();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    bgPlayer.setMediaTime(this.lastMusicTime);
                }
                catch (MediaException e) {
                    // empty catch block
                }
                this.lastMusicTime = 0L;
                try {
                    VolumeControl volumeObj = (VolumeControl)bgPlayer.getControl("VolumeControl");
                    volumeObj.setLevel(this.currentVolumeMusic);
                }
                catch (Error e) {
                    // empty catch block
                }
                bgPlayer.setLoopCount(loop ? -1 : 1);
                bgPlayer.start();
                activePlayer = bgPlayer;
                activeListener = bgListener;
            }
            catch (Exception ex) {
                cocos2d.CCLog("SAE:" + ex.getMessage());
            }
        } else {
            this.mutedMusicName = filename;
            this.mutedMusicLooping = loop;
        }
    }

    public void playBackgroundMusic(final String filename, final boolean loop) {
        if (!cocos2d.isAndroid && (cocos2d.settings & 0x400L) == 0L) {
            this.playBgMusicDoWork(filename, loop);
        } else {
            new Thread(new Runnable(){

                public void run() {
                    SimpleAudioEngine.this.playBgMusicDoWork(filename, loop);
                }
            }).start();
        }
    }

    public void playBackgroundMusic(String filename) {
        this.playBackgroundMusic(filename, true);
    }

    public void stopBackgroundMusic() {
        if (bgPlayer != null) {
            bgPlayer.removePlayerListener((PlayerListener)bgListener);
            bgPlayer.close();
            if (activePlayer == bgPlayer) {
                activePlayer = null;
                activeListener = null;
            }
            bgPlayer = null;
            bgListener = null;
            System.gc();
        }
    }

    public boolean isBackgroundMusicPlaying() {
        return bgPlayer != null && bgPlayer.getState() == 400;
    }

    void pause() {
        if (this.isBackgroundMusicPlaying()) {
            this.shouldResumeMusic = true;
            this.setMute(true);
        }
    }

    void resume() {
        if (this.shouldResumeMusic) {
            this.shouldResumeMusic = false;
            this.setMute(false);
        }
    }

    public void purge() {
        this.stopBackgroundMusic();
        this.unloadAllEffects();
        activePlayer = null;
        activeListener = null;
        System.gc();
    }
}

