/*
 * Decompiled with CFR 0.152.
 */
package cocos2d;

import cocos2d.CCTextureCache;
import cocos2d.cocos2d;
import cocos2d.types.CCRect;
import cocos2d.types.CCSpriteFrame;
import cocos2d.types.CCTexture2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class CCSpriteFrameCache {
    private static final Hashtable cache = new Hashtable(5);
    private static final Vector loadedAlready = new Vector(3, 1);
    private static CCSpriteFrameCache _sharedFrameCache = null;

    public static final CCSpriteFrameCache sharedFrameCache() {
        if (_sharedFrameCache == null) {
            _sharedFrameCache = new CCSpriteFrameCache();
        }
        return _sharedFrameCache;
    }

    public void invalidateSpriteFrameByName(String filename) {
        cache.remove(filename);
    }

    public void invalidateSpriteFrame(CCSpriteFrame frame) {
        cache.remove(frame.name);
    }

    public CCSpriteFrame getSpriteFrame(String filename, boolean flipped) {
        CCSpriteFrame retObj;
        String cacheName = filename;
        if (flipped) {
            cacheName = cacheName + "flip";
        }
        if ((retObj = (CCSpriteFrame)cache.get(cacheName)) == null && cacheName.endsWith(".png")) {
            retObj = (CCSpriteFrame)cache.get(cacheName.substring(0, cacheName.length() - 4));
        }
        if (retObj == null) {
            CCTexture2D texture = CCTextureCache.sharedTextureCache().addImage(filename);
            if (flipped) {
                CCTexture2D flippedTexture = CCTextureCache.sharedTextureCache().textureForKey(cacheName);
                if (flippedTexture == null) {
                    flippedTexture = CCTextureCache.sharedTextureCache().addToCache(CCTexture2D.flipTexture(texture));
                }
                retObj = CCSpriteFrame.frameWithTextureAndFrame(flippedTexture, CCRect.make(0, 0, flippedTexture.width, flippedTexture.height));
            } else {
                retObj = CCSpriteFrame.frameWithTextureAndFrame(texture, CCRect.make(0, 0, texture.width, texture.height));
            }
            retObj.name = cacheName;
            cache.put(cacheName, retObj);
        }
        return retObj;
    }

    public CCSpriteFrame buildSpriteFrame(String filename, Image imageObj, boolean flipped) {
        CCTexture2D texture = CCTextureCache.sharedTextureCache().textureForKey(filename);
        if (texture == null) {
            texture = new CCTexture2D(filename, imageObj);
            CCTextureCache.sharedTextureCache().addToCache(texture);
        }
        CCSpriteFrame retObj = CCSpriteFrame.frameWithTextureAndFrame(texture, CCRect.make(0, 0, texture.width, texture.height));
        if (flipped) {
            cocos2d.CCLog("CCSpriteFrameCache: You cannot flip CCTextures created from images");
        }
        retObj.name = filename;
        return retObj;
    }

    private CCSpriteFrameCache() {
    }

    public String printState() {
        return "cache size:" + cache.size() + "\ncontents:" + cache.toString();
    }

    public void addSpriteFramesWithFile(String filename) {
        if (!loadedAlready.contains(filename)) {
            try {
                KXmlParser parser = new KXmlParser();
                InputStream is = this.getClass().getResourceAsStream("/" + cocos2d.resourceFolder + filename);
                if (is == null) {
                    cocos2d.CCLog("CCSpriteFrameCache: cannot find xml with name " + filename);
                    return;
                }
                InputStreamReader isr = new InputStreamReader(is);
                parser.setInput(isr);
                parser.nextTag();
                parser.require(2, null, "TextureAtlas");
                CCTexture2D texture = CCTextureCache.sharedTextureCache().addImage(parser.getAttributeValue("", "imagePath"));
                while (parser.nextTag() != 3) {
                    parser.require(2, null, "sprite");
                    String name = parser.getAttributeValue("", "n");
                    int x = Integer.parseInt(parser.getAttributeValue("", "x"));
                    int y = Integer.parseInt(parser.getAttributeValue("", "y"));
                    int w = Integer.parseInt(parser.getAttributeValue("", "w"));
                    int h = Integer.parseInt(parser.getAttributeValue("", "h"));
                    String r = parser.getAttributeValue("", "r");
                    CCSpriteFrame newFrame = CCSpriteFrame.frameWithTextureAndFrame(texture, CCRect.make(x, y, w, h));
                    try {
                        newFrame.offsetInPixels.x = Integer.parseInt(parser.getAttributeValue("", "oX"));
                        newFrame.offsetInPixels.y = Integer.parseInt(parser.getAttributeValue("", "oY"));
                        newFrame.originalSizeInPixels.width = Integer.parseInt(parser.getAttributeValue("", "oW"));
                        newFrame.originalSizeInPixels.height = Integer.parseInt(parser.getAttributeValue("", "oH"));
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    newFrame.isRotated = r != null;
                    newFrame.name = name;
                    cache.put(name, newFrame);
                    this.skipSubTree(parser);
                }
                parser.require(3, null, "TextureAtlas");
                parser.next();
                parser.require(1, null, null);
                isr.close();
                is.close();
            }
            catch (XmlPullParserException ex) {
                cocos2d.CCLog("CCSpriteFrameCache: xml parsing error " + ex.toString());
            }
            catch (IOException ex) {
                cocos2d.CCLog("CCSpriteFrameCache: IO error " + ex.toString());
            }
            loadedAlready.addElement(filename);
        }
    }

    public void removeSpriteFramesWithFile(String filename) {
        if (loadedAlready.removeElement(filename)) {
            try {
                KXmlParser parser = new KXmlParser();
                InputStream is = this.getClass().getResourceAsStream("/" + cocos2d.resourceFolder + filename);
                if (is == null) {
                    cocos2d.CCLog("CCSpriteFrameCache: cannot find xml with name " + filename);
                    return;
                }
                InputStreamReader isr = new InputStreamReader(is);
                parser.setInput(isr);
                parser.nextTag();
                parser.require(2, null, "TextureAtlas");
                CCTextureCache.sharedTextureCache().removeTextureForKey(parser.getAttributeValue("", "imagePath"));
                while (parser.nextTag() != 3) {
                    parser.require(2, null, "sprite");
                    String name = parser.getAttributeValue("", "n");
                    this.invalidateSpriteFrameByName(name);
                    this.skipSubTree(parser);
                }
                parser.require(3, null, "TextureAtlas");
                parser.next();
                parser.require(1, null, null);
                isr.close();
                is.close();
            }
            catch (XmlPullParserException ex) {
                cocos2d.CCLog("CCSpriteFrameCache: xml parsing error " + ex.toString());
            }
            catch (IOException ex) {
                cocos2d.CCLog("CCSpriteFrameCache: IO error " + ex.toString());
            }
        }
    }

    public void skipSubTree(XmlPullParser parser) throws XmlPullParserException, IOException {
        parser.require(2, null, null);
        int level = 1;
        while (level > 0) {
            int eventType = parser.next();
            if (eventType == 3) {
                --level;
                continue;
            }
            if (eventType != 2) continue;
            ++level;
        }
    }

    public CCSpriteFrame spriteFrameByName(String name) {
        CCSpriteFrame frame = (CCSpriteFrame)cache.get(name);
        if (frame != null) {
            return frame;
        }
        if (name.endsWith(".png") && (frame = (CCSpriteFrame)cache.get(name.substring(0, name.length() - 4))) != null) {
            return frame;
        }
        cocos2d.CCLog("CCSpriteFrameCache: Cannot find frame with name " + name);
        return null;
    }

    public void purgeSpriteFrameCache() {
        cache.clear();
        loadedAlready.removeAllElements();
    }
}

