/*
 * Decompiled with CFR 0.152.
 */
package cocos2d;

import cocos2d.CCSpriteFrameCache;
import cocos2d.cocos2d;
import cocos2d.nodes.CCLabelBMFont;
import cocos2d.nodes.CCLabelTTF;
import cocos2d.nodes.CCLayerColor;
import cocos2d.nodes.CCLayerGradient;
import cocos2d.nodes.CCMenu;
import cocos2d.nodes.CCMenuItem;
import cocos2d.nodes.CCMenuItemImage;
import cocos2d.nodes.CCNode;
import cocos2d.nodes.CCSprite;
import cocos2d.types.CCPoint;
import cocos2d.types.Real;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class CCBIReader {
    private static InputStream is;
    private static String[] stringCache;
    private static byte currentBit;
    private static byte compressedInt;
    private static CCNode owner;
    public static String relativePath;
    private static final byte[] floatBytes;
    private static final int PROPERTY_POSITION = 0;
    private static final int PROPERTY_SIZE = 1;
    private static final int PROPERTY_POINT = 2;
    private static final int PROPERTY_POINT_LOCK = 3;
    private static final int PROPERTY_SCALE_LOCK = 4;
    private static final int PROPERTY_DEGREES = 5;
    private static final int PROPERTY_INTEGER = 6;
    private static final int PROPERTY_FLOAT = 7;
    private static final int PROPERTY_FLOAT_VAR = 8;
    private static final int PROPERTY_CHECK = 9;
    private static final int PROPERTY_SPRITE_FRAME = 10;
    private static final int PROPERTY_TEXTURE = 11;
    private static final int PROPERTY_BYTE = 12;
    private static final int PROPERTY_COLOR3 = 13;
    private static final int PROPERTY_COLOR4F = 14;
    private static final int PROPERTY_FLIP = 15;
    private static final int PROPERTY_BLENDMODE = 16;
    private static final int PROPERTY_FNT_FILE = 17;
    private static final int PROPERTY_TEXT = 18;
    private static final int PROPERTY_FONT_TTF = 19;
    private static final int PROPERTY_INTEGER_LABELED = 20;
    private static final int PROPERTY_BLOCK = 21;
    static final Boolean YES;
    static final Boolean NO;

    public static final CCNode parseFile(String filename, CCNode owner) {
        CCNode result = null;
        CCBIReader.owner = owner;
        try {
            is = cocos2d.canvas.getClass().getResourceAsStream("/" + cocos2d.resourceFolder + filename);
            cocos2d.CCLog("CCBIReader: Parsing " + filename);
            CCBIReader.readHeader();
            CCBIReader.readStringCache();
            result = CCBIReader.readNode();
            is.close();
            is = null;
        }
        catch (Exception ex) {
            cocos2d.CCLog("CCBIReader: error while parsing " + filename + " : " + ex.toString());
        }
        CCBIReader.owner = null;
        stringCache = null;
        System.gc();
        return result;
    }

    public static final CCNode parseBytes(byte[] file, CCNode owner) {
        CCNode result = null;
        CCBIReader.owner = owner;
        try {
            is = new ByteArrayInputStream(file);
            cocos2d.CCLog("CCBIReader: Parsing byte array");
            CCBIReader.readHeader();
            CCBIReader.readStringCache();
            result = CCBIReader.readNode();
            is.close();
            is = null;
        }
        catch (Exception ex) {
            cocos2d.CCLog("CCBIReader: error while parsing the byte array : " + ex.toString());
        }
        CCBIReader.owner = null;
        stringCache = null;
        System.gc();
        return result;
    }

    private static boolean readBoolean() throws IOException {
        return CCBIReader.readByte() == 1;
    }

    private static byte readByte() throws IOException {
        return (byte)is.read();
    }

    private static Real readFloat() throws IOException {
        boolean kCCBFloat0 = false;
        boolean kCCBFloat1 = true;
        int kCCBFloatMinus1 = 2;
        int kCCBFloat05 = 3;
        int kCCBFloatInteger = 4;
        int kCCBFloatFull = 5;
        byte type = CCBIReader.readByte();
        switch (type) {
            case 0: {
                return new Real();
            }
            case 1: {
                return new Real(Real.ONE);
            }
            case 2: {
                return new Real(Real.ONE_N);
            }
            case 3: {
                return new Real(Real.HALF);
            }
            case 4: {
                return new Real(CCBIReader.readSInt());
            }
            case 5: {
                Real myFloat = new Real();
                myFloat.assignFloatBits(CCBIReader.read4BytesFloat());
                return myFloat;
            }
        }
        cocos2d.CCLog("CCBIReader: unknown float type");
        return new Real();
    }

    private static int read4Bytes() throws IOException {
        is.read(floatBytes);
        return (0xFF & floatBytes[0]) << 24 | (0xFF & floatBytes[1]) << 16 | (0xFF & floatBytes[2]) << 8 | 0xFF & floatBytes[3];
    }

    private static int read4BytesFloat() throws IOException {
        is.read(floatBytes);
        return (0xFF & floatBytes[3]) << 24 | (0xFF & floatBytes[2]) << 16 | (0xFF & floatBytes[1]) << 8 | 0xFF & floatBytes[0];
    }

    private static String readString() throws IOException {
        byte b0 = CCBIReader.readByte();
        byte b1 = CCBIReader.readByte();
        int numBytes = b0 << 8 | b1;
        byte[] utf8Bytes = new byte[numBytes];
        is.read(utf8Bytes);
        return new String(utf8Bytes, "UTF-8");
    }

    private static String readCachedString() throws IOException {
        return stringCache[CCBIReader.readUInt()];
    }

    private static boolean getBit(byte myByte) throws IOException {
        boolean bit = (myByte & 1 << currentBit) != 0;
        if ((currentBit = (byte)(currentBit + 1)) >= 8) {
            currentBit = 0;
            compressedInt = CCBIReader.readByte();
        }
        return bit;
    }

    private static int readInt(boolean sign) throws IOException {
        int s;
        compressedInt = CCBIReader.readByte();
        int numBits = 0;
        while (!CCBIReader.getBit(compressedInt)) {
            ++numBits;
        }
        long current = 0L;
        for (int a = numBits - 1; a >= 0; --a) {
            if (!CCBIReader.getBit(compressedInt)) continue;
            current |= (long)(1 << a);
        }
        int num = sign ? ((s = (int)(current % 2L)) != 0 ? (int)(current / 2L) : (int)(-current / 2L)) : (int)((current |= (long)(1 << numBits)) - 1L);
        currentBit = 0;
        return num;
    }

    private static int readUInt() throws IOException {
        return CCBIReader.readInt(false);
    }

    private static int readSInt() throws IOException {
        return CCBIReader.readInt(true);
    }

    private static void readHeader() throws IOException {
        CCBIReader.read4Bytes();
        int version = CCBIReader.readUInt();
        cocos2d.CCLog("CCBIReader: CCBI file version: " + version);
    }

    private static void readStringCache() throws IOException {
        int numStrings = CCBIReader.readUInt();
        stringCache = new String[numStrings];
        for (int i = 0; i < numStrings; ++i) {
            CCBIReader.stringCache[i] = CCBIReader.readString();
        }
    }

    private static CCNode readNode() throws IOException {
        CCNode retObj = null;
        String nodeClass = CCBIReader.readCachedString();
        Hashtable properties = CCBIReader.getNodeWithProperties();
        int numChildren = CCBIReader.readUInt();
        if (nodeClass.equals("CCSprite")) {
            if ("".equals((String)properties.get("displayFramespriteSheetFile"))) {
                retObj = CCSprite.spriteWithFile((String)properties.get("displayFramespriteFile"));
                if (retObj == null && relativePath.length() != 0) {
                    retObj = CCSprite.spriteWithFile(relativePath.concat((String)properties.get("displayFramespriteFile")));
                }
            } else {
                CCSpriteFrameCache.sharedFrameCache().addSpriteFramesWithFile((String)properties.get("displayFramespriteSheetFile"));
                retObj = CCSprite.spriteWithFrameName((String)properties.get("displayFramespriteFile"));
            }
        } else if (nodeClass.equals("CCMenu")) {
            retObj = new CCMenu();
            ((CCMenu)retObj).keyboardInteractionEnabled = (Boolean)properties.get("isKeyboardEnabled");
        } else if (nodeClass.equals("CCMenuItemImage")) {
            CCSprite dImage;
            CCSprite sImage;
            CCSprite nImage;
            if ("".equals((String)properties.get("normalSpriteFramespriteSheetFile"))) {
                nImage = CCSprite.spriteWithFile((String)properties.get("normalSpriteFramespriteFile"));
                if (nImage == null && relativePath.length() != 0) {
                    nImage = CCSprite.spriteWithFile(relativePath.concat((String)properties.get("normalSpriteFramespriteFile")));
                }
            } else {
                CCSpriteFrameCache.sharedFrameCache().addSpriteFramesWithFile((String)properties.get("normalSpriteFramespriteSheetFile"));
                nImage = CCSprite.spriteWithFrameName((String)properties.get("normalSpriteFramespriteFile"));
            }
            if ("".equals((String)properties.get("selectedSpriteFramespriteSheetFile"))) {
                sImage = CCSprite.spriteWithFile((String)properties.get("selectedSpriteFramespriteFile"));
                if (sImage == null && relativePath.length() != 0) {
                    sImage = CCSprite.spriteWithFile(relativePath.concat((String)properties.get("selectedSpriteFramespriteFile")));
                }
            } else {
                CCSpriteFrameCache.sharedFrameCache().addSpriteFramesWithFile((String)properties.get("selectedSpriteFramespriteSheetFile"));
                sImage = CCSprite.spriteWithFrameName((String)properties.get("selectedSpriteFramespriteFile"));
            }
            if ("".equals((String)properties.get("disabledSpriteFramespriteSheetFile"))) {
                dImage = CCSprite.spriteWithFile((String)properties.get("disabledSpriteFramespriteFile"));
                if (dImage == null && relativePath.length() != 0) {
                    dImage = CCSprite.spriteWithFile(relativePath.concat((String)properties.get("disabledSpriteFramespriteFile")));
                }
            } else {
                CCSpriteFrameCache.sharedFrameCache().addSpriteFramesWithFile((String)properties.get("disabledSpriteFramespriteSheetFile"));
                dImage = CCSprite.spriteWithFrameName((String)properties.get("disabledSpriteFramespriteFile"));
            }
            retObj = CCMenuItemImage.itemWithImages(nImage, sImage, dImage, owner);
            ((CCMenuItem)retObj).isEnabled = (Boolean)properties.get("isEnabled");
        } else if (nodeClass.equals("CCNode") || nodeClass.equals("CCLayer")) {
            retObj = new CCNode();
        } else if (nodeClass.equals("CCLayerColor")) {
            retObj = new CCLayerColor(((CCPoint)properties.get((Object)"contentSize")).x, ((CCPoint)properties.get((Object)"contentSize")).y, (Integer)properties.get("color"));
        } else if (nodeClass.equals("CCLabelBMFont")) {
            retObj = new CCLabelBMFont((String)properties.get("string"), (String)properties.get("fntFile"));
        } else if (nodeClass.equals("CCLabelTTF")) {
            int maxWidth = ((CCPoint)properties.get((Object)"dimensions")).x;
            retObj = CCLabelTTF.labelWithString((String)properties.get("string"));
            ((CCLabelTTF)retObj).color = (Integer)properties.get("color");
            if (maxWidth > 0) {
                ((CCLabelTTF)retObj).setMaxLineWidth(maxWidth);
            }
        } else if (nodeClass.equals("CCLayerGradient")) {
            retObj = new CCLayerGradient(((CCPoint)properties.get((Object)"contentSize")).x, ((CCPoint)properties.get((Object)"contentSize")).y, (Integer)properties.get("startColor"), (Integer)properties.get("endColor"), 10);
        } else if (nodeClass.length() > 0) {
            cocos2d.CCLog("CCBIReader: class not implemented yet - " + nodeClass);
        }
        if (retObj != null) {
            retObj.tag = (Integer)properties.get("tag");
            retObj.setPosition((CCPoint)properties.get("position"));
            retObj.setAnchorPoint((CCPoint)properties.get("anchorPoint"));
            retObj.setAlpha((Integer)properties.get("opacity"));
            retObj.setScale((CCPoint)properties.get("scale"));
            retObj.setRotation((Integer)properties.get("rotation"));
            retObj.isRelativeAnchorPoint = (Boolean)properties.get("isRelativeAnchorPoint");
            retObj.zOrder = (Integer)properties.get("zOrder");
            retObj.visible = (Boolean)properties.get("visible");
            int i = numChildren;
            while (i-- != 0) {
                CCNode child = CCBIReader.readNode();
                if (retObj == null || child == null) continue;
                retObj.addChild(child);
            }
        }
        return retObj;
    }

    private static Hashtable getNodeWithProperties() throws IOException {
        int numProperties;
        Hashtable<String, Object> properties = new Hashtable<String, Object>(10);
        properties.put("zOrder", new Integer(-1));
        properties.put("tag", new Integer(-1));
        properties.put("opacity", new Integer(255));
        properties.put("visible", YES);
        properties.put("isRelativeAnchorPoint", YES);
        properties.put("anchorPoint", CCPoint.ccp(50, 50));
        int memberVarAssignmentType = CCBIReader.readUInt();
        if (memberVarAssignmentType != 0) {
            String memberVarAssignmentName = CCBIReader.readCachedString();
        }
        int i = numProperties = CCBIReader.readUInt();
        while (i-- != 0) {
            Real y;
            Real x;
            int typeID = CCBIReader.readUInt();
            String propertyName = CCBIReader.readCachedString();
            byte platform = CCBIReader.readByte();
            if (propertyName.equals("position")) {
                properties.put(propertyName, CCPoint.ccp(CCBIReader.readFloat().toInteger(), CCBIReader.readFloat().toInteger()));
                continue;
            }
            if (propertyName.equals("anchorPoint")) {
                x = CCBIReader.readFloat();
                x.mul(100);
                y = CCBIReader.readFloat();
                y.mul(100);
                properties.put(propertyName, CCPoint.ccp(x.toInteger(), y.toInteger()));
                continue;
            }
            if (propertyName.equals("scale")) {
                x = CCBIReader.readFloat();
                y = CCBIReader.readFloat();
                x.round();
                y.round();
                properties.put(propertyName, CCPoint.ccp(x.toInteger(), y.toInteger()));
                continue;
            }
            if (propertyName.equals("tag")) {
                properties.put(propertyName, new Integer(CCBIReader.readSInt()));
                continue;
            }
            if (propertyName.equals("rotation")) {
                properties.put(propertyName, new Integer(CCBIReader.readFloat().toInteger()));
                continue;
            }
            if (propertyName.equals("contentSize")) {
                x = CCBIReader.readFloat();
                y = CCBIReader.readFloat();
                x.round();
                y.round();
                properties.put(propertyName, CCPoint.ccp(x.toInteger(), y.toInteger()));
                continue;
            }
            if (propertyName.equals("isRelativeAnchorPoint")) {
                properties.put(propertyName, CCBIReader.readBoolean() ? YES : NO);
                continue;
            }
            if (propertyName.equals("visible")) {
                properties.put(propertyName, CCBIReader.readBoolean() ? YES : NO);
                continue;
            }
            if (propertyName.equals("zOrder")) {
                properties.put(propertyName, new Integer(CCBIReader.readSInt()));
                continue;
            }
            if (propertyName.equals("isTouchEnabled")) {
                properties.put(propertyName, CCBIReader.readBoolean() ? YES : NO);
                continue;
            }
            if (propertyName.equals("isAccelerometerEnabled")) {
                CCBIReader.readBoolean();
                continue;
            }
            if (propertyName.equals("isMouseEnabled")) {
                CCBIReader.readBoolean();
                continue;
            }
            if (propertyName.equals("isKeyboardEnabled")) {
                properties.put(propertyName, CCBIReader.readBoolean() ? YES : NO);
                continue;
            }
            if (propertyName.equals("startColor")) {
                if (typeID == 13) {
                    properties.put(propertyName, new Integer((0xFF & CCBIReader.readByte()) << 16 | (0xFF & CCBIReader.readByte()) << 8 | 0xFF & CCBIReader.readByte()));
                    continue;
                }
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                continue;
            }
            if (propertyName.equals("endColor")) {
                if (typeID == 13) {
                    properties.put(propertyName, new Integer((0xFF & CCBIReader.readByte()) << 16 | (0xFF & CCBIReader.readByte()) << 8 | 0xFF & CCBIReader.readByte()));
                    continue;
                }
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                continue;
            }
            if (propertyName.equals("color")) {
                if (typeID == 13) {
                    properties.put(propertyName, new Integer((0xFF & CCBIReader.readByte()) << 16 | (0xFF & CCBIReader.readByte()) << 8 | 0xFF & CCBIReader.readByte()));
                    continue;
                }
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                continue;
            }
            if (propertyName.equals("startOpacity")) {
                properties.put(propertyName, new Integer(CCBIReader.readByte() & 0xFF));
                continue;
            }
            if (propertyName.equals("endOpacity")) {
                properties.put(propertyName, new Integer(CCBIReader.readByte() & 0xFF));
                continue;
            }
            if (propertyName.equals("opacity")) {
                properties.put(propertyName, new Integer(CCBIReader.readByte() & 0xFF));
                continue;
            }
            if (propertyName.equals("blendFunc")) {
                CCBIReader.readUInt();
                CCBIReader.readUInt();
                continue;
            }
            if (propertyName.equals("displayFrame")) {
                properties.put(propertyName + "spriteSheetFile", CCBIReader.readCachedString());
                properties.put(propertyName + "spriteFile", CCBIReader.readCachedString());
                continue;
            }
            if (propertyName.equals("flip")) {
                CCBIReader.readBoolean();
                CCBIReader.readBoolean();
                continue;
            }
            if (propertyName.equals("emitterMode")) {
                CCBIReader.readSInt();
                continue;
            }
            if (propertyName.equals("posVar")) {
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                continue;
            }
            if (propertyName.equals("emissionRate")) {
                CCBIReader.readFloat();
                continue;
            }
            if (propertyName.equals("duration")) {
                CCBIReader.readFloat();
                continue;
            }
            if (propertyName.equals("totalParticles")) {
                CCBIReader.readSInt();
                continue;
            }
            if (propertyName.equals("life")) {
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                continue;
            }
            if (propertyName.equals("startSize")) {
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                continue;
            }
            if (propertyName.equals("endSize")) {
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                continue;
            }
            if (propertyName.equals("startSpin")) {
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                continue;
            }
            if (propertyName.equals("endSpin")) {
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                continue;
            }
            if (propertyName.equals("angle")) {
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                continue;
            }
            if (propertyName.equals("gravity")) {
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                continue;
            }
            if (propertyName.equals("speed")) {
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                continue;
            }
            if (propertyName.equals("tangentialAccel")) {
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                continue;
            }
            if (propertyName.equals("radialAccel")) {
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                continue;
            }
            if (propertyName.equals("fntFile")) {
                properties.put(propertyName, CCBIReader.readCachedString());
                continue;
            }
            if (propertyName.equals("texture")) {
                properties.put(propertyName, CCBIReader.readCachedString());
                continue;
            }
            if (propertyName.equals("string")) {
                properties.put(propertyName, CCBIReader.readCachedString());
                continue;
            }
            if (propertyName.equals("block")) {
                CCBIReader.readCachedString();
                CCBIReader.readUInt();
                continue;
            }
            if (propertyName.equals("vector")) {
                CCBIReader.readFloat();
                CCBIReader.readFloat();
                continue;
            }
            if (propertyName.equals("isEnabled")) {
                properties.put(propertyName, CCBIReader.readBoolean() ? YES : NO);
                continue;
            }
            if (propertyName.equals("normalSpriteFrame")) {
                properties.put(propertyName + "spriteSheetFile", CCBIReader.readCachedString());
                properties.put(propertyName + "spriteFile", CCBIReader.readCachedString());
                continue;
            }
            if (propertyName.equals("selectedSpriteFrame")) {
                properties.put(propertyName + "spriteSheetFile", CCBIReader.readCachedString());
                properties.put(propertyName + "spriteFile", CCBIReader.readCachedString());
                continue;
            }
            if (propertyName.equals("disabledSpriteFrame")) {
                properties.put(propertyName + "spriteSheetFile", CCBIReader.readCachedString());
                properties.put(propertyName + "spriteFile", CCBIReader.readCachedString());
                continue;
            }
            if (propertyName.equals("fontName")) {
                properties.put(propertyName, CCBIReader.readCachedString());
                continue;
            }
            if (propertyName.equals("horizontalAlignment")) {
                properties.put(propertyName, new Integer(CCBIReader.readSInt()));
                continue;
            }
            if (propertyName.equals("fontSize")) {
                properties.put(propertyName, new Integer(CCBIReader.readFloat().toInteger()));
                continue;
            }
            if (propertyName.equals("verticalAlignment")) {
                properties.put(propertyName, new Integer(CCBIReader.readSInt()));
                continue;
            }
            if (propertyName.equals("dimensions")) {
                x = CCBIReader.readFloat();
                y = CCBIReader.readFloat();
                x.round();
                y.round();
                properties.put(propertyName, CCPoint.ccp(x.toInteger(), y.toInteger()));
                continue;
            }
            System.out.println("unknown property: " + propertyName);
        }
        return properties;
    }

    static {
        stringCache = null;
        currentBit = 0;
        compressedInt = 0;
        owner = null;
        relativePath = "";
        floatBytes = new byte[4];
        YES = new Boolean(true);
        NO = new Boolean(false);
    }
}

