/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.types;

public class Real {
    public static final Real ZERO = new Real(0.0);
    public static final Real ONE = new Real(1.0);
    public static final Real TWO = new Real(2.0);
    public static final Real THREE = new Real(3.0);
    public static final Real FIVE = new Real(5.0);
    public static final Real TEN = new Real(10.0);
    public static final Real HUNDRED = new Real(100.0);
    public static final Real HALF = new Real(0.5);
    public static final Real THIRD = new Real(0.3333333432674408);
    public static final Real TENTH = new Real(0.1f);
    public static final Real PERCENT = new Real(0.01f);
    public static final Real SQRT2 = new Real(Math.sqrt(2.0));
    public static final Real SQRT1_2 = new Real(Math.sqrt(0.5));
    public static final Real PI2 = new Real(Math.PI * 2);
    public static final Real PI = new Real(Math.PI);
    public static final Real PI_2 = new Real(1.5707963267948966);
    public static final Real PI_4 = new Real(0.7853981633974483);
    public static final Real PI_8 = new Real(0.39269908169872414);
    public static final Real _180 = new Real(180.0);
    public static final Real E = new Real(2.7182817459106445);
    public static final Real LN2 = new Real(0.6931471824645996);
    public static final Real LN10 = new Real(2.3025851249694824);
    public static final Real LOG2E = new Real(2.3025851249694824);
    public static final Real LOG10E = new Real(1.442695f);
    public static final Real MAX = new Real(3.4028234663852886E38);
    public static final Real MIN = new Real(1.4E-45f);
    public static final Real NAN = new Real(Double.NaN);
    public static final Real INF = new Real(Double.POSITIVE_INFINITY);
    public static final Real INF_N = new Real(Double.NEGATIVE_INFINITY);
    public static final Real ONE_N = new Real(-1.0);
    public double value = 0.0;
    private static final double zero = 0.0;
    private static final double one = 1.0;
    private static final double two = 2.0;
    private static final double tiny = 1.0E-300;
    private static final double huge = 1.0E300;
    private static final double two53 = 9.007199254740992E15;
    private static final double two54 = 1.8014398509481984E16;
    private static final double twom54 = 5.551115123125783E-17;
    private static final double P1 = 0.16666666666666602;
    private static final double P2 = -0.0027777777777015593;
    private static final double P3 = 6.613756321437934E-5;
    private static final double P4 = -1.6533902205465252E-6;
    private static final double P5 = 4.1381367970572385E-8;
    private static final long HI_MASK = -4294967296L;
    private static final long LO_MASK = 0xFFFFFFFFL;
    private static final int HI_SHIFT = 32;
    private static final double[] bp = new double[]{1.0, 1.5};
    private static final double[] dp_h = new double[]{0.0, 0.5849624872207642};
    private static final double[] dp_l = new double[]{0.0, 1.350039202129749E-8};
    private static final double L1 = 0.5999999999999946;
    private static final double L2 = 0.4285714285785502;
    private static final double L3 = 0.33333332981837743;
    private static final double L4 = 0.272728123808534;
    private static final double L5 = 0.23066074577556175;
    private static final double L6 = 0.20697501780033842;
    private static final double lg2 = 0.6931471805599453;
    private static final double lg2_h = 0.6931471824645996;
    private static final double lg2_l = -1.904654299957768E-9;
    private static final double ovt = 8.008566259537294E-17;
    private static final double cp = 0.9617966939259756;
    private static final double cp_h = 0.9617967009544373;
    private static final double cp_l = -7.028461650952758E-9;
    private static final double ivln2 = 1.4426950408889634;
    private static final double ivln2_h = (double)1.442695f;
    private static final double ivln2_l = 1.9259629911266175E-8;
    private static final float sq2p1 = 2.4142137f;
    private static final float sq2m1 = 0.41421357f;
    private static final float p4 = 16.15364f;
    private static final float p3 = 268.42548f;
    private static final float p2 = 1153.0293f;
    private static final float p1 = 1780.4064f;
    private static final float p0 = 896.78595f;
    private static final float q4 = 58.95697f;
    private static final float q3 = 536.2654f;
    private static final float q2 = 1666.7838f;
    private static final float q1 = 2079.335f;
    private static final float q0 = 896.78595f;
    private static final float PIO2 = 1.5707964f;

    public Real() {
    }

    public Real(double number) {
        this.value = number;
    }

    public Real(Real number) {
        this.value = number.value;
    }

    public Real(String number) {
        this.value = Float.parseFloat(number);
    }

    public void assign(long number) {
        this.value = number;
    }

    public void assign(float number) {
        this.value = number;
    }

    public void assign(double number) {
        this.value = number;
    }

    public void assign(int number) {
        this.value = number;
    }

    public void assign(Real number) {
        this.value = number.value;
    }

    public void ceil() {
        this.value = Math.ceil(this.value);
    }

    public void floor() {
        this.value = Math.floor(this.value);
    }

    public void mul(int number) {
        this.value *= (double)number;
    }

    public void mul(Real number) {
        this.value *= number.value;
    }

    public void mul(double number) {
        this.value *= number;
    }

    public void pow(Real number) {
        this.value = this.pow(this.value, number.value);
    }

    public void pow(double number) {
        this.value = this.pow(this.value, number);
    }

    private double pow(double x, double y) {
        return Real.ieee754_pow(x, y);
    }

    private static final double ieee754_pow(double x, double y) {
        double p_l;
        double p_h;
        double r;
        double t2;
        double t1;
        double v;
        double u;
        double w;
        double t;
        int j;
        int k;
        int hx = (int)(Double.doubleToLongBits(x) >>> 32);
        int lx = (int)(Double.doubleToLongBits(x) & 0xFFFFFFFFL);
        int hy = (int)(Double.doubleToLongBits(y) >>> 32);
        int ly = (int)(Double.doubleToLongBits(y) & 0xFFFFFFFFL);
        int ix = hx & Integer.MAX_VALUE;
        int iy = hy & Integer.MAX_VALUE;
        if ((iy | ly) == 0) {
            return 1.0;
        }
        if (ix > 0x7FF00000 || ix == 0x7FF00000 && lx != 0 || iy > 0x7FF00000 || iy == 0x7FF00000 && ly != 0) {
            return x + y;
        }
        int yisint = 0;
        if (hx < 0) {
            if (iy >= 0x43400000) {
                yisint = 2;
            } else if (iy >= 0x3FF00000) {
                k = (iy >> 20) - 1023;
                if (k > 20) {
                    j = ly >> 52 - k;
                    if (j << 52 - k == ly) {
                        yisint = 2 - (j & 1);
                    }
                } else if (ly == 0 && (j = iy >> 20 - k) << 20 - k == iy) {
                    yisint = 2 - (j & 1);
                }
            }
        }
        if (ly == 0) {
            if (iy == 0x7FF00000) {
                if ((ix - 0x3FF00000 | lx) == 0) {
                    return y - y;
                }
                if (ix >= 0x3FF00000) {
                    return hy >= 0 ? y : 0.0;
                }
                return hy < 0 ? -y : 0.0;
            }
            if (iy == 0x3FF00000) {
                if (hy < 0) {
                    return 1.0 / x;
                }
                return x;
            }
            if (hy == 0x40000000) {
                return x * x;
            }
            if (hy == 1071644672 && hx >= 0) {
                return Math.sqrt(x);
            }
        }
        double ax = Math.abs(x);
        if (lx == 0 && (ix == 0x7FF00000 || ix == 0 || ix == 0x3FF00000)) {
            double z = ax;
            if (hy < 0) {
                z = 1.0 / z;
            }
            if (hx < 0) {
                if ((ix - 0x3FF00000 | yisint) == 0) {
                    z = (z - z) / (z - z);
                } else if (yisint == 1) {
                    z = -z;
                }
            }
            return z;
        }
        int n = (hx >>> 31) + 1;
        if ((n | yisint) == 0) {
            return (x - x) / (x - x);
        }
        double s = 1.0;
        if ((n | yisint - 1) == 0) {
            s = -1.0;
        }
        if (iy > 1105199104) {
            if (iy > 1139802112) {
                if (ix <= 0x3FEFFFFF) {
                    return hy < 0 ? Double.POSITIVE_INFINITY : 0.0;
                }
                if (ix >= 0x3FF00000) {
                    return hy > 0 ? Double.POSITIVE_INFINITY : 0.0;
                }
            }
            if (ix < 0x3FEFFFFF) {
                return hy < 0 ? s * 1.0E300 * 1.0E300 : s * 1.0E-300 * 1.0E-300;
            }
            if (ix > 0x3FF00000) {
                return hy > 0 ? s * 1.0E300 * 1.0E300 : s * 1.0E-300 * 1.0E-300;
            }
            t = x - 1.0;
            w = t * t * (0.5 - t * (0.3333333333333333 - t * 0.25));
            u = (double)1.442695f * t;
            v = t * 1.9259629911266175E-8 - w * 1.4426950408889634;
            t1 = u + v;
            t1 = Double.longBitsToDouble(Double.doubleToLongBits(t1) & 0xFFFFFFFF00000000L);
            t2 = v - (t1 - u);
        } else {
            double ss;
            n = 0;
            if (ix < 0x100000) {
                n -= 53;
                ix = (int)(Double.doubleToLongBits(ax *= 9.007199254740992E15) >>> 32);
            }
            n += (ix >> 20) - 1023;
            j = ix & 0xFFFFF;
            ix = j | 0x3FF00000;
            if (j <= 235662) {
                k = 0;
            } else if (j < 767610) {
                k = 1;
            } else {
                k = 0;
                ++n;
                ix -= 0x100000;
            }
            ax = Double.longBitsToDouble((long)ix << 32 | Double.doubleToLongBits(ax) & 0xFFFFFFFFL);
            u = ax - bp[k];
            v = 1.0 / (ax + bp[k]);
            double s_h = ss = u * v;
            s_h = Double.longBitsToDouble(Double.doubleToLongBits(s_h) & 0xFFFFFFFF00000000L);
            double t_h = 0.0;
            t_h = Double.longBitsToDouble((long)((ix >> 1 | 0x20000000) + 524288 + (k << 18)) << 32 | Double.doubleToLongBits(t_h) & 0xFFFFFFFFL);
            double t_l = ax - (t_h - bp[k]);
            double s_l = v * (u - s_h * t_h - s_h * t_l);
            double s2 = ss * ss;
            r = s2 * s2 * (0.5999999999999946 + s2 * (0.4285714285785502 + s2 * (0.33333332981837743 + s2 * (0.272728123808534 + s2 * (0.23066074577556175 + s2 * 0.20697501780033842)))));
            s2 = s_h * s_h;
            t_h = 3.0 + s2 + (r += s_l * (s_h + ss));
            t_h = Double.longBitsToDouble(Double.doubleToLongBits(t_h) & 0xFFFFFFFF00000000L);
            t_l = r - (t_h - 3.0 - s2);
            u = s_h * t_h;
            v = s_l * t_h + t_l * ss;
            p_h = u + v;
            p_h = Double.longBitsToDouble(Double.doubleToLongBits(p_h) & 0xFFFFFFFF00000000L);
            p_l = v - (p_h - u);
            double z_h = 0.9617967009544373 * p_h;
            double z_l = -7.028461650952758E-9 * p_h + p_l * 0.9617966939259756 + dp_l[k];
            t = n;
            t1 = z_h + z_l + dp_h[k] + t;
            t1 = Double.longBitsToDouble(Double.doubleToLongBits(t1) & 0xFFFFFFFF00000000L);
            t2 = z_l - (t1 - t - dp_h[k] - z_h);
        }
        double y1 = y;
        y1 = Double.longBitsToDouble(Double.doubleToLongBits(y1) & 0xFFFFFFFF00000000L);
        p_l = (y - y1) * t1 + y * t2;
        p_h = y1 * t1;
        double z = p_l + p_h;
        j = (int)(Double.doubleToLongBits(z) >>> 32);
        int i = (int)(Double.doubleToLongBits(z) & 0xFFFFFFFFL);
        if (j >= 0x40900000) {
            if ((j - 0x40900000 | i) != 0) {
                return s * 1.0E300 * 1.0E300;
            }
            if (p_l + 8.008566259537294E-17 > z - p_h) {
                return s * 1.0E300 * 1.0E300;
            }
        } else if ((j & Integer.MAX_VALUE) >= 1083231232) {
            if ((j - -1064252416 | i) != 0) {
                return s * 1.0E-300 * 1.0E-300;
            }
            if (p_l <= z - p_h) {
                return s * 1.0E-300 * 1.0E-300;
            }
        }
        i = j & Integer.MAX_VALUE;
        k = (i >> 20) - 1023;
        n = 0;
        if (i > 1071644672) {
            n = j + (0x100000 >> k + 1);
            k = ((n & Integer.MAX_VALUE) >> 20) - 1023;
            t = 0.0;
            t = Double.longBitsToDouble((long)(n & ~(1048575 >> k)) << 32 | Double.doubleToLongBits(t) & 0xFFFFFFFFL);
            n = (n & 0xFFFFF | 0x100000) >> 20 - k;
            if (j < 0) {
                n = -n;
            }
            p_h -= t;
        }
        t = p_l + p_h;
        t = Double.longBitsToDouble(Double.doubleToLongBits(t) & 0xFFFFFFFF00000000L);
        u = t * 0.6931471824645996;
        v = (p_l - (t - p_h)) * 0.6931471805599453 + t * -1.904654299957768E-9;
        z = u + v;
        w = v - (z - u);
        t = z * z;
        t1 = z - t * (0.16666666666666602 + t * (-0.0027777777777015593 + t * (6.613756321437934E-5 + t * (-1.6533902205465252E-6 + t * 4.1381367970572385E-8))));
        r = z * t1 / (t1 - 2.0) - (w + z * w);
        z = 1.0 - (r - z);
        j = (int)(Double.doubleToLongBits(z) >>> 32);
        z = (j += n << 20) >> 20 <= 0 ? Real.scalbn(z, n) : Double.longBitsToDouble((long)j << 32 | Double.doubleToLongBits(z) & 0xFFFFFFFFL);
        return s * z;
    }

    static final double scalbn(double x, int n) {
        int hx = (int)(Double.doubleToLongBits(x) >>> 32);
        int lx = (int)(Double.doubleToLongBits(x) & 0xFFFFFFFFL);
        int k = (hx & 0x7FF00000) >> 20;
        if (k == 0) {
            if ((lx | hx & Integer.MAX_VALUE) == 0) {
                return x;
            }
            hx = (int)(Double.doubleToLongBits(x *= 1.8014398509481984E16) >>> 32);
            k = ((hx & 0x7FF00000) >> 20) - 54;
            if (n < -50000) {
                return 1.0E-300 * x;
            }
        }
        if (k == 2047) {
            return x + x;
        }
        if ((k += n) > 2046) {
            return 1.0E300 * Real.copysign(1.0E300, x);
        }
        if (k > 0) {
            x = Double.longBitsToDouble((long)(hx & 0x800FFFFF | k << 20) << 32 | Double.doubleToLongBits(x) & 0xFFFFFFFFL);
            return x;
        }
        if (k <= -54) {
            if (n > 50000) {
                return 1.0E300 * Real.copysign(1.0E300, x);
            }
            return 1.0E-300 * Real.copysign(1.0E-300, x);
        }
        x = Double.longBitsToDouble((long)(hx & 0x800FFFFF | (k += 54) << 20) << 32 | Double.doubleToLongBits(x) & 0xFFFFFFFFL);
        return x * 5.551115123125783E-17;
    }

    static final double copysign(double x, double y) {
        return Double.longBitsToDouble(Double.doubleToLongBits(x) & Long.MAX_VALUE | Double.doubleToLongBits(y) & Long.MIN_VALUE);
    }

    public void div(int number) {
        this.value /= (double)number;
    }

    public void div(double number) {
        this.value /= number;
    }

    public void div(Real number) {
        this.value /= number.value;
    }

    public void add(int number) {
        this.value += (double)number;
    }

    public void add(double number) {
        this.value += number;
    }

    public void add(Real number) {
        this.value += number.value;
    }

    public void sub(int number) {
        this.value -= (double)number;
    }

    public void sub(double number) {
        this.value -= number;
    }

    public void sub(Real number) {
        this.value -= number.value;
    }

    public int toInteger() {
        return (int)this.value;
    }

    public void round() {
        this.value = (int)this.value;
    }

    public void recip() {
        if (this.value != 0.0) {
            this.value = 1.0 / this.value;
        }
    }

    public void sqrt() {
        this.value = Math.sqrt(this.value);
    }

    public void sin() {
        this.value = Math.sin(this.value);
    }

    public void cos() {
        this.value = Math.cos(this.value);
    }

    public void atan2(float second) {
        this.value = this.atan2(this.value, second);
    }

    public void atan2(Real second) {
        this.value = this.atan2(this.value, second.value);
    }

    private static float mxatan(float arg) {
        float argsq = arg * arg;
        float value = (((16.15364f * argsq + 268.42548f) * argsq + 1153.0293f) * argsq + 1780.4064f) * argsq + 896.78595f;
        return (value /= ((((argsq + 58.95697f) * argsq + 536.2654f) * argsq + 1666.7838f) * argsq + 2079.335f) * argsq + 896.78595f) * arg;
    }

    private static float msatan(float arg) {
        if (arg < 0.41421357f) {
            return Real.mxatan(arg);
        }
        if (arg > 2.4142137f) {
            return 1.5707964f - Real.mxatan(1.0f / arg);
        }
        return 0.7853982f + Real.mxatan((arg - 1.0f) / (arg + 1.0f));
    }

    private static float atan(float arg) {
        if (arg > 0.0f) {
            return Real.msatan(arg);
        }
        return -Real.msatan(-arg);
    }

    public void atan() {
        this.value = Real.atan((float)this.value);
    }

    public void asin() {
        double x = this.value;
        if (this.value < 0.0) {
            x = -this.value;
        }
        double y = x;
        int n = 0;
        double sn = x;
        while (sn > 1.0E-16) {
            sn = sn * (2.0 + 1.0 / (double)(++n)) * 0.5 * x * x;
            int b = 2 * n + 1;
            y += sn / (double)b / (double)b;
        }
        if (this.value < 0.0) {
            y = -y;
        }
        this.value = y;
    }

    public boolean isZero() {
        return this.value < (double)1.0E-6f && this.value > (double)-1.0E-6f;
    }

    public boolean greaterEqual(Real number) {
        return this.value >= number.value;
    }

    public boolean greaterEqual(int number) {
        return this.value >= (double)number;
    }

    public boolean greaterThan(Real number) {
        return this.value > number.value;
    }

    public boolean greaterThan(int number) {
        return this.value >= (double)number;
    }

    public boolean lessEqual(Real number) {
        return this.value <= number.value;
    }

    public boolean lessEqual(int number) {
        return this.value <= (double)number;
    }

    public boolean lessThan(Real number) {
        return this.value < number.value;
    }

    public boolean lessThan(int number) {
        return this.value < (double)number;
    }

    private double atan2(double y, double x) {
        double angle;
        double r;
        double coeff_1 = 0.7853981633974483;
        double coeff_2 = 3.0 * coeff_1;
        double abs_y = Math.abs(y) + (double)1.0E-10f;
        if (x >= 0.0) {
            r = (x - abs_y) / (x + abs_y);
            angle = coeff_1;
        } else {
            r = (x + abs_y) / (abs_y - x);
            angle = coeff_2;
        }
        return y < 0.0 ? -angle : (angle += ((double)0.1963f * r * r - (double)0.9817f) * r);
    }

    public void neg() {
        this.value = -this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public void assignFloatBits(int bits) {
        this.value = Float.intBitsToFloat(bits);
    }
}

