/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.nodes;

import cocos2d.CCSpriteFrameCache;
import cocos2d.CCTextureCache;
import cocos2d.cocos2d;
import cocos2d.nodes.CCNode;
import cocos2d.nodes.CCSprite;
import cocos2d.types.CCSpriteFrame;
import cocos2d.types.CCTexture2D;
import cocos2d.types.Real;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CCSpritePrecomputed
extends CCNode {
    private static final int extraPrecisionPadding = 20;
    private static final int MyPi = 0xB400000;
    private static final int MyPiMul2 = 377487360;
    private static final int MyPiDiv2 = 0x5A00000;
    private int numImages = 0;
    private int precomputed1 = 0;
    private int precomputed2 = 0;
    private int frameHeight = 0;
    private int frameWidth = 0;
    final Vector multiFrames = new Vector(10);
    public CCSpriteFrame spriteFrame = null;

    public CCSpritePrecomputed(String imageName) {
        this.spriteFrame = CCSpriteFrameCache.sharedFrameCache().getSpriteFrame(imageName, false);
        this.recomputeInternals();
        if ((cocos2d.settings & 0x10L) != 0L) {
            cocos2d.CCLog("CCSpriteRecomputed: Warning, SETTING_NO_DRAW_REGION is enabled and you are using a node that relies on it.");
        }
    }

    public CCSpritePrecomputed(String resultName, String filename, int frames) {
        CCTexture2D texture = CCTextureCache.sharedTextureCache().textureForKey(resultName);
        Image tPrecomputed = texture == null ? CCSpritePrecomputed.buildPrecomputedImage(filename, frames) : texture.image;
        this.numImages = frames;
        this.spriteFrame = CCSpriteFrameCache.sharedFrameCache().buildSpriteFrame(resultName, tPrecomputed, false);
        this.recomputeInternals();
        if ((cocos2d.settings & 0x10L) != 0L) {
            cocos2d.CCLog("CCSpriteRecomputed: Warning, SETTING_NO_DRAW_REGION is enabled and you are using a node that relies on it.");
        }
    }

    public void recomputeInternals() {
        this.frameWidth = this.spriteFrame.texture.image.getWidth() / this.numImages;
        this.frameHeight = this.spriteFrame.texture.image.getHeight();
        this.precomputed1 = 0xB400000 / (this.numImages << 2);
        this.precomputed2 = 0xB400000 / (this.numImages << 1);
    }

    public static CCSpritePrecomputed spriteWithFile(String filename) {
        return CCSpritePrecomputed.spriteWithFile(filename, 6);
    }

    public static CCSpritePrecomputed spriteWithFile(String filename, int frames) {
        CCSpritePrecomputed retObj = new CCSpritePrecomputed(filename + "precomputed" + frames, filename, frames);
        if (retObj.spriteFrame.texture.image == null) {
            return null;
        }
        return retObj;
    }

    private static Image buildPrecomputedImage(String filename, int frames) {
        CCTexture2D original = CCTexture2D.textureWithFile(filename);
        int w = original.width;
        int h = original.height;
        Real tmp = new Real(w * w + h * h);
        tmp.sqrt();
        tmp.ceil();
        int topPixel = Integer.MAX_VALUE;
        int bottomPixel = -1;
        int resultHeightUnoptimized = tmp.toInteger();
        int resultWidth = resultHeightUnoptimized * frames;
        Image resultImage = Image.createImage((int)resultWidth, (int)resultHeightUnoptimized);
        Graphics g = resultImage.getGraphics();
        g.setColor(cocos2d.maskColor);
        g.fillRect(0, 0, resultImage.getWidth(), resultHeightUnoptimized);
        for (int i = 0; i < frames; ++i) {
            tmp.assign(90);
            tmp.div(frames);
            tmp.mul(i);
            int angleInDegrees = tmp.toInteger();
            original = CCTexture2D.textureWithFile(filename);
            CCSprite.rotateTexture(angleInDegrees, original, true);
            g.drawImage(original.image, i * resultHeightUnoptimized + (resultHeightUnoptimized - original.width >> 1), resultHeightUnoptimized - original.height >> 1, 20);
        }
        int[] imgPixels = new int[resultImage.getWidth() * resultHeightUnoptimized];
        resultImage.getRGB(imgPixels, 0, resultImage.getWidth(), 0, 0, resultImage.getWidth(), resultHeightUnoptimized);
        int i = imgPixels.length;
        while (i-- != 0) {
            if (imgPixels[i] == cocos2d.TRANSPARENT_COLOR) {
                imgPixels[i] = 0;
                continue;
            }
            topPixel = Math.min(topPixel, i);
            bottomPixel = Math.max(bottomPixel, i);
        }
        int trimAmount = Math.min(topPixel, imgPixels.length - bottomPixel);
        int lineTop = trimAmount / resultWidth;
        int visiblePixels = imgPixels.length - (trimAmount << 1);
        System.arraycopy(imgPixels, lineTop * resultWidth, imgPixels, 0, visiblePixels);
        return Image.createRGBImage((int[])imgPixels, (int)resultWidth, (int)(visiblePixels / resultWidth), (boolean)true);
    }

    public void setRotation(int angle) {
        if (Math.abs(angle) >= 360) {
            angle -= angle / 360 * 360;
        }
        if (angle < 0) {
            angle += 360;
        }
        this.rotation = angle << 20;
    }

    public int getRotation() {
        return this.rotation >> 20;
    }

    public void draw(Graphics g) throws NullPointerException {
        this.getScreenPosition(this.drawPosition);
        int rotFX = this.rotation + this.precomputed1;
        if (rotFX > 377487360) {
            rotFX -= 377487360;
        }
        int transformIdx = rotFX / 0x5A00000;
        int index = (rotFX - transformIdx * 0x5A00000) / this.precomputed2;
        int transformation = 0;
        switch (transformIdx) {
            case 1: {
                transformation = 5;
                break;
            }
            case 2: {
                transformation = 3;
                break;
            }
            case 3: {
                transformation = 6;
                break;
            }
        }
        cocos2d.setClip(g, 0, -cocos2d.SCREEN_HEIGHT, cocos2d.SCREEN_WIDTH, cocos2d.SCREEN_HEIGHT);
        g.drawRegion(this.spriteFrame.texture.image, index * this.frameWidth, 0, this.frameWidth, this.frameHeight, transformation, this.drawPosition.x, -this.drawPosition.y, 3);
    }
}

