/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.nodes;

import cocos2d.CCSpriteFrameCache;
import cocos2d.CCTextureCache;
import cocos2d.cocos2d;
import cocos2d.extensions.AsyncDownloader;
import cocos2d.extensions.AsyncDownloaderDelegate;
import cocos2d.nodes.CCLayerColor;
import cocos2d.nodes.CCNode;
import cocos2d.types.CCPointF;
import cocos2d.types.CCRect;
import cocos2d.types.CCSpriteFrame;
import cocos2d.types.CCTexture2D;
import cocos2d.types.Real;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CCSprite
extends CCNode
implements AsyncDownloaderDelegate {
    private static final Real tmpSinReal = new Real();
    private static final Real tmpCosReal = new Real();
    private String filename;
    int currentRotation = 0;
    final CCPointF currentScale = CCPointF.ccp(1.0f, 1.0f);
    public boolean flipX = false;
    final CCRect tmpRect = new CCRect();
    public CCSpriteFrame spriteFrame = null;

    public static CCSprite spriteWithFile(String filename) {
        CCSprite retObj = new CCSprite(filename, false);
        if (retObj.spriteFrame.texture.image == null) {
            if (filename.startsWith("http:")) {
                cocos2d.CCLog("download image : " + filename);
                AsyncDownloader tDownloader = new AsyncDownloader(filename, retObj);
                tDownloader.startAsynchronous();
            } else {
                return null;
            }
        }
        return retObj;
    }

    public static CCSprite spriteWithImage(String filename, Image imageObj) {
        CCSprite retObj = new CCSprite(filename, imageObj);
        if (retObj.spriteFrame.texture.image == null) {
            return null;
        }
        return retObj;
    }

    public static CCSprite spriteWithFrameName(String frameName) {
        CCSprite retObj = new CCSprite(frameName, true);
        if (retObj.spriteFrame == null) {
            return null;
        }
        return retObj;
    }

    public CCSprite(String name) {
        this(name, false);
    }

    public CCSprite(String name, boolean usesAtlas) {
        this.filename = name;
        this.spriteFrame = usesAtlas ? CCSpriteFrameCache.sharedFrameCache().spriteFrameByName(name) : CCSpriteFrameCache.sharedFrameCache().getSpriteFrame(name, false);
        this.width = this.spriteFrame.originalSizeInPixels.width;
        this.height = this.spriteFrame.originalSizeInPixels.height;
    }

    public CCSprite(String name, Image imageObject) {
        this.filename = name;
        this.spriteFrame = CCSpriteFrameCache.sharedFrameCache().buildSpriteFrame(this.filename, imageObject, this.flipX);
    }

    public final boolean collidesWith(CCSprite node) {
        int cropW = (int)((float)this.spriteFrame.rect.size.width * this.scale.x);
        int cropH = (int)((float)this.spriteFrame.rect.size.height * this.scale.y);
        this.getScreenPosition(this.drawPosition);
        this.drawPosition.x = this.drawPosition.x - (this.anchorPoint.x == 0 ? 0 : cropW / (100 / this.anchorPoint.x));
        this.drawPosition.y = this.drawPosition.y - (this.anchorPoint.y == 0 ? 0 : cropH / (100 / this.anchorPoint.y));
        this.tmpRect.position.x = this.drawPosition.x;
        this.tmpRect.position.y = -(this.drawPosition.y + cropH);
        this.tmpRect.size.width = cropW;
        this.tmpRect.size.height = cropH;
        cropW = (int)((float)node.spriteFrame.rect.size.width * node.scale.x);
        cropH = (int)((float)node.spriteFrame.rect.size.height * node.scale.y);
        node.getScreenPosition(node.drawPosition);
        node.drawPosition.x = node.drawPosition.x - (node.anchorPoint.x == 0 ? 0 : cropW / (100 / node.anchorPoint.x));
        node.drawPosition.y = node.drawPosition.y - (node.anchorPoint.y == 0 ? 0 : cropH / (100 / node.anchorPoint.y));
        node.tmpRect.position.x = node.drawPosition.x;
        node.tmpRect.position.y = -(node.drawPosition.y + cropH);
        node.tmpRect.size.width = cropW;
        node.tmpRect.size.height = cropH;
        return CCRect.intersectsRect(this.tmpRect, node.tmpRect);
    }

    public final boolean collidesWith(CCLayerColor node) {
        int cropW = (int)((float)this.spriteFrame.rect.size.width * this.scale.x);
        int cropH = (int)((float)this.spriteFrame.rect.size.height * this.scale.y);
        this.getScreenPosition(this.drawPosition);
        this.drawPosition.x = this.drawPosition.x - (this.anchorPoint.x == 0 ? 0 : cropW / (100 / this.anchorPoint.x));
        this.drawPosition.y = this.drawPosition.y - (this.anchorPoint.y == 0 ? 0 : cropH / (100 / this.anchorPoint.y));
        this.tmpRect.position.x = this.drawPosition.x;
        this.tmpRect.position.y = -(this.drawPosition.y + cropH);
        this.tmpRect.size.width = cropW;
        this.tmpRect.size.height = cropH;
        cropW = (int)((float)node.width * node.scale.x);
        cropH = (int)((float)node.height * node.scale.y);
        node.getScreenPosition(node.drawPosition);
        node.drawPosition.x = node.drawPosition.x - (node.anchorPoint.x == 0 ? 0 : cropW / (100 / node.anchorPoint.x));
        node.drawPosition.y = node.drawPosition.y - (node.anchorPoint.y == 0 ? 0 : cropH / (100 / node.anchorPoint.y));
        node.tmpRect.position.x = node.drawPosition.x;
        node.tmpRect.position.y = -(node.drawPosition.y + cropH);
        node.tmpRect.size.width = cropW;
        node.tmpRect.size.height = cropH;
        return CCRect.intersectsRect(this.tmpRect, node.tmpRect);
    }

    static int clamp(int min, int max, int value) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static void drawInt(int[] src, int srcOffset, int srcWidth, int srcHeight, int[] dest, int destX, int destY, int destWidth, int destHeight) {
        int maxWidth = CCSprite.clamp(0, destWidth - destX, srcWidth);
        int maxHeight = destHeight - destY;
        int i = Math.min(Math.min(srcHeight, maxHeight), destHeight);
        while (i-- > 0) {
            System.arraycopy(src, i * srcWidth + srcOffset, dest, destX + (i + destY) * destWidth, maxWidth);
        }
    }

    static final void scaleTexture(CCPointF scale, CCTexture2D texture) {
        if ((cocos2d.settings & 1L) != 0L || scale.x == 1.0f && scale.y == 1.0f) {
            return;
        }
        int width = texture.width;
        int height = texture.height;
        int resizedWidth = (int)((float)width * scale.x);
        int resizedHeight = (int)((float)height * scale.y);
        int[] in = new int[width];
        int[] out = new int[resizedWidth * resizedHeight];
        for (int y = 0; y < resizedHeight; ++y) {
            int dy = y * height / resizedHeight;
            texture.image.getRGB(in, 0, width, 0, dy, width, 1);
            for (int x = 0; x < resizedWidth; ++x) {
                int dx = x * width / resizedWidth;
                out[resizedWidth * y + x] = in[dx];
            }
        }
        texture.image = Image.createRGBImage((int[])out, (int)resizedWidth, (int)resizedHeight, (boolean)true);
        texture.width = resizedWidth;
        texture.height = resizedHeight;
    }

    static final void rotateTexture(int angle, CCTexture2D texture, boolean extendSize) {
        if ((cocos2d.settings & 1L) != 0L || angle == 0 || angle == 360) {
            return;
        }
        int sw = texture.width;
        int sh = texture.height;
        if (extendSize) {
            tmpCosReal.assign(sw * sw + sh * sh);
            tmpCosReal.sqrt();
            tmpCosReal.ceil();
            int size = tmpCosReal.toInteger();
            Image bigImage = Image.createImage((int)size, (int)size);
            Graphics g = bigImage.getGraphics();
            g.setColor(cocos2d.maskColor);
            g.fillRect(0, 0, size, size);
            g.drawImage(texture.image, size - sw >> 1, size - sh >> 1, 20);
            texture.image = bigImage;
            texture.height = size;
            texture.width = size;
            sw = size;
            sh = size;
        }
        int topPixel = Integer.MAX_VALUE;
        int bottomPixel = -1;
        int[] dstData = new int[sw * sh];
        int[] srcData = new int[sw * sh];
        texture.image.getRGB(srcData, 0, sw, 0, 0, sw, sh);
        tmpCosReal.assign(Real.PI);
        tmpCosReal.div(Real._180);
        tmpCosReal.mul(angle);
        tmpSinReal.assign(tmpCosReal);
        tmpSinReal.sin();
        tmpSinReal.mul(256);
        tmpCosReal.cos();
        tmpCosReal.mul(256);
        int isa = tmpSinReal.toInteger();
        int ica = tmpCosReal.toInteger();
        int my = -(sh >> 1);
        int swDiv2 = sw >> 1;
        int precomputed1 = -swDiv2 * ica + (sw >> 1 << 8);
        int precomputed2 = swDiv2 * isa + (sh >> 1 << 8);
        for (int i = 0; i < sh; ++i) {
            int wpos = i * sw;
            int xacc = my * isa + precomputed1;
            int yacc = my * ica + precomputed2;
            for (int j = 0; j < sw; ++j) {
                int srcx = xacc >> 8;
                int srcy = yacc >> 8;
                int pixelPositionInSrc = srcx + srcy * sw;
                if (srcx < 0 || srcy < 0 || srcx >= sw || srcy >= sh || srcData[pixelPositionInSrc] == cocos2d.TRANSPARENT_COLOR) {
                    dstData[wpos++] = 0;
                } else {
                    topPixel = Math.min(topPixel, wpos);
                    bottomPixel = Math.max(bottomPixel, wpos);
                    dstData[wpos++] = srcData[pixelPositionInSrc];
                }
                xacc += ica;
                yacc -= isa;
            }
            ++my;
        }
        int trimAmount = Math.min(topPixel, dstData.length - bottomPixel);
        int lineTop = trimAmount / sw;
        int visiblePixels = dstData.length - (trimAmount << 1);
        System.arraycopy(dstData, lineTop * sw, dstData, 0, visiblePixels);
        texture.height = visiblePixels / sw;
        texture.width = sw;
        texture.image = Image.createRGBImage((int[])dstData, (int)texture.width, (int)texture.height, (boolean)true);
    }

    public void draw(Graphics g) {
        if (this.spriteFrame == null) {
            return;
        }
        g.setColor(this._alphaRaw);
        try {
            if (this.spriteFrame.texture.image != null) {
                if (this.rotation != this.currentRotation || !this.currentScale.isEqual(this.scale)) {
                    this.spriteFrame = CCSpriteFrame.frameWithTextureAndFrame(CCTextureCache.sharedTextureCache().textureForKey(this.spriteFrame.texture.name), this.spriteFrame.rect);
                    this.spriteFrame.texture = new CCTexture2D(this.spriteFrame.texture.name, this.spriteFrame.texture.image);
                    this.currentRotation = this.rotation;
                    this.currentScale.set(this.scale);
                    CCSprite.rotateTexture(this.currentRotation, this.spriteFrame.texture, true);
                    this.spriteFrame.originalSizeInPixels.width = this.spriteFrame.rect.size.width = this.spriteFrame.texture.width;
                    this.spriteFrame.originalSizeInPixels.height = this.spriteFrame.rect.size.height = this.spriteFrame.texture.height;
                    CCSprite.scaleTexture(this.currentScale, this.spriteFrame.texture);
                    this.width = this.spriteFrame.texture.width;
                    this.height = this.spriteFrame.texture.height;
                }
                int atlassCropW = (int)((float)this.spriteFrame.rect.size.width * this.scale.x);
                int atlassCropH = (int)((float)this.spriteFrame.rect.size.height * this.scale.y);
                int atlassOffsetX = (int)((float)this.spriteFrame.rect.position.x * this.scale.x);
                int atlassOffsetYRaw = (int)((float)this.spriteFrame.rect.position.y * this.scale.y);
                int atlassOffsetY = this.spriteFrame.texture.height - atlassOffsetYRaw - atlassCropH;
                int trimOffsetX = (int)((float)this.spriteFrame.offsetInPixels.x * this.scale.x);
                int trimOffsetY = (int)((float)this.spriteFrame.offsetInPixels.y * this.scale.y);
                int originalSizeW = (int)((float)this.spriteFrame.originalSizeInPixels.width * this.scale.x);
                int originalSizeH = (int)((float)this.spriteFrame.originalSizeInPixels.height * this.scale.y);
                this.getScreenPosition(this.drawPosition);
                if (this.isRelativeAnchorPoint) {
                    this.drawPosition.x = this.drawPosition.x - (this.anchorPoint.x == 0 ? 0 : originalSizeW / (100 / this.anchorPoint.x));
                    this.drawPosition.y = this.drawPosition.y - (this.anchorPoint.y == 0 ? 0 : originalSizeH / (100 / this.anchorPoint.y));
                }
                int realOffsetY = originalSizeH - trimOffsetY - atlassCropH;
                if (!this.flipX) {
                    cocos2d.setClip(g, this.drawPosition.x + trimOffsetX, -(this.drawPosition.y + atlassCropH) - realOffsetY, atlassCropW, atlassCropH);
                    CCSprite.NOKIA_POS_FIX_HACK(this.drawPosition);
                    g.drawImage(this.spriteFrame.texture.image, this.drawPosition.x - atlassOffsetX + trimOffsetX, -(this.drawPosition.y - atlassOffsetY + realOffsetY), 36);
                } else {
                    int realOffsetX = originalSizeW - trimOffsetX - atlassCropW;
                    cocos2d.setClip(g, this.drawPosition.x + realOffsetX, -(this.drawPosition.y + atlassCropH) - realOffsetY, atlassCropW, atlassCropH);
                    CCSprite.NOKIA_POS_FIX_HACK(this.drawPosition);
                    if ((cocos2d.settings & 0x10L) == 0L) {
                        g.drawRegion(this.spriteFrame.texture.image, atlassOffsetX, atlassOffsetYRaw, atlassCropW, atlassCropH, 2, this.drawPosition.x + realOffsetX, -this.drawPosition.y - realOffsetY, 36);
                    } else {
                        CCSpriteFrame tmpFrame = CCSpriteFrameCache.sharedFrameCache().getSpriteFrame(this.spriteFrame.texture.name, true);
                        atlassOffsetX = tmpFrame.texture.width - (atlassOffsetX + atlassCropW);
                        g.drawImage(tmpFrame.texture.image, this.drawPosition.x - atlassOffsetX + realOffsetX, -(this.drawPosition.y - atlassOffsetY + realOffsetY), 36);
                    }
                }
            }
        }
        catch (NullPointerException e) {
            if (this.spriteFrame != null && this.spriteFrame.name != null) {
                this.filename = this.spriteFrame.name;
            }
            cocos2d.CCLog("CCSprite: Draw " + this.filename + "(" + this.toString() + ") failed: " + e.toString());
        }
    }

    public void downloadFinished(AsyncDownloader task, byte[] result) {
        cocos2d.CCLog("CCSprite: download finished ".concat(this.filename));
        Image downImage = null;
        try {
            downImage = Image.createImage((InputStream)new ByteArrayInputStream(result));
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.spriteFrame = CCSpriteFrameCache.sharedFrameCache().buildSpriteFrame(this.filename, downImage, this.flipX);
        this.width = this.spriteFrame.originalSizeInPixels.width;
        this.height = this.spriteFrame.originalSizeInPixels.height;
    }

    public void downloadFailed(AsyncDownloader task) {
        cocos2d.CCLog("CCSprite: download failed ".concat(this.filename));
    }
}

