/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.nodes;

import cocos2d.nodes.CCMenuItem;
import cocos2d.nodes.CCNode;
import cocos2d.nodes.CCSprite;
import cocos2d.types.CCFunction;
import cocos2d.types.CCPoint;
import cocos2d.types.CCSpriteFrame;
import cocos2d.types.CCTouch;
import javax.microedition.lcdui.Graphics;

public class CCMenuItemImage
extends CCMenuItem {
    public CCSprite normalImage = null;
    public CCSprite selectedImage = null;
    public CCSprite disabledImage = null;

    public static CCMenuItemImage itemWithImages(CCSprite normalImage, CCSprite selectedImage, CCSprite disabledImage, CCNode delegate) {
        return new CCMenuItemImage(normalImage, selectedImage, disabledImage, delegate);
    }

    public static CCMenuItemImage itemWithImages(CCSprite normalImage, CCSprite selectedImage, CCSprite disabledImage, CCFunction callback) {
        return new CCMenuItemImage(normalImage, selectedImage, disabledImage, callback);
    }

    public CCMenuItemImage(CCSprite normalImage, CCSprite selectedImage, CCSprite disabledImage, CCNode delegate) {
        this.normalImage = normalImage;
        this.selectedImage = selectedImage;
        this.disabledImage = disabledImage;
        this.delegate = delegate;
        this.width = normalImage.width;
        this.height = normalImage.height;
    }

    public CCMenuItemImage(CCSprite normalImage, CCSprite selectedImage, CCSprite disabledImage, CCFunction callback) {
        this.normalImage = normalImage;
        this.selectedImage = selectedImage;
        this.disabledImage = disabledImage;
        this.callback = callback;
        this.width = normalImage.width;
        this.height = normalImage.height;
    }

    private boolean isTouchInBounds(CCPoint touch) {
        CCSpriteFrame spriteFrame = this.selectedImage.spriteFrame;
        int cropW = (int)((float)spriteFrame.rect.size.width * this.scale.x);
        int cropH = (int)((float)spriteFrame.rect.size.height * this.scale.y);
        this.getScreenPosition(this.drawPosition);
        this.drawPosition.x = this.drawPosition.x - (this.anchorPoint.x == 0 ? 0 : cropW / (100 / this.anchorPoint.x));
        this.drawPosition.y = this.drawPosition.y - (this.anchorPoint.y == 0 ? 0 : cropH / (100 / this.anchorPoint.y));
        return this.drawPosition.x <= touch.x && this.drawPosition.y <= touch.y && this.drawPosition.y + cropH >= touch.y && this.drawPosition.x + cropW >= touch.x;
    }

    public boolean ccTouchBegan(CCTouch touch) {
        if (this._actionsPaused) {
            return false;
        }
        if (this.isEnabled && this.visible && this.isTouchInBounds(touch.position)) {
            this.isFocused = true;
            if (this.callbackOnTouchDown) {
                this.fireEvent();
            }
            return true;
        }
        return false;
    }

    public void ccTouchMoved(CCTouch touch) {
        if (!this._actionsPaused) {
            this.isFocused = this.isEnabled && this.visible && this.isTouchInBounds(touch.position);
        }
    }

    public void ccTouchEnded(CCTouch touch) {
        if (!this._actionsPaused && this.isEnabled && this.visible && this.isFocused && !this.callbackOnTouchDown) {
            this.fireEvent();
        }
        this.isFocused = false;
    }

    public void draw(Graphics g) {
        CCSprite activeSprite = !this.isEnabled ? this.disabledImage : (!this.isFocused ? this.normalImage : this.selectedImage);
        this.width = activeSprite.width;
        this.height = activeSprite.height;
        activeSprite.visible = this.visible;
        activeSprite.parent = this.parent;
        activeSprite.setAlpha(this.getAlpha());
        activeSprite.setAnchorPoint(this.anchorPoint);
        activeSprite.setPosition(this.position);
        activeSprite.setRotation(this.rotation);
        activeSprite.setScale(this.scale);
        activeSprite.draw(g);
    }
}

