/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.nodes;

import cocos2d.CCKeyboardManager;
import cocos2d.CCTouchDispatcher;
import cocos2d.cocos2d;
import cocos2d.nodes.CCMenuItem;
import cocos2d.nodes.CCNode;
import cocos2d.types.CCTouch;
import javax.microedition.lcdui.Graphics;

public class CCMenu
extends CCNode {
    CCNode touchDelegate;
    public int focusedButton;
    public boolean keyboardInteractionEnabled;

    public static final CCMenu menuWithItems(CCMenuItem[] items) {
        return new CCMenu(items);
    }

    public CCMenu(CCMenuItem[] items) {
        block3: {
            this.touchDelegate = null;
            this.focusedButton = 0;
            this.keyboardInteractionEnabled = (cocos2d.settings & 4L) != 0L;
            for (int i = 0; i < items.length; ++i) {
                this.addChild(items[i]);
            }
            if (((CCMenuItem)this.children.elementAt((int)this.focusedButton)).isEnabled) break block3;
            int startingButton = this.focusedButton;
            do {
                ++this.focusedButton;
                if (this.focusedButton >= this.children.size()) {
                    this.focusedButton = 0;
                }
                if (this.focusedButton >= 0) continue;
                this.focusedButton = this.children.size() - 1;
            } while ((!((CCNode)this.children.elementAt((int)this.focusedButton)).visible || !((CCMenuItem)this.children.elementAt((int)this.focusedButton)).isEnabled) && this.focusedButton != startingButton);
        }
    }

    public CCMenu() {
        this.touchDelegate = null;
        this.focusedButton = 0;
        this.keyboardInteractionEnabled = (cocos2d.settings & 4L) != 0L;
    }

    public boolean ccTouchBegan(CCTouch touch) {
        this.touchDelegate = null;
        for (int i = 0; i < this.children.size(); ++i) {
            try {
                CCMenuItem node = (CCMenuItem)this.children.elementAt(i);
                node.isFocused = false;
                if (this.touchDelegate != null || !node.ccTouchBegan(touch)) continue;
                this.touchDelegate = node;
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return this.touchDelegate != null;
    }

    public void ccTouchEnded(CCTouch touch) {
        if (this.touchDelegate != null) {
            this.touchDelegate.ccTouchEnded(touch);
        }
        this.touchDelegate = null;
    }

    public void ccTouchMoved(CCTouch touch) {
        this.touchDelegate = null;
        for (int i = 0; i < this.children.size(); ++i) {
            try {
                CCMenuItem node = (CCMenuItem)this.children.elementAt(i);
                node.isFocused = false;
                if (this.touchDelegate != null || !node.ccTouchBegan(touch)) continue;
                this.touchDelegate = node;
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public void onEnter() {
        CCTouchDispatcher.sharedDispatcher().addTargetedDelegate(this);
        CCKeyboardManager.sharedManager().addTargetedDelegate(this);
    }

    public void onExit() {
        CCTouchDispatcher.sharedDispatcher().removeDelegate(this);
        CCKeyboardManager.sharedManager().removeDelegate(this);
    }

    public boolean ccKeyDown(int keyCode) {
        return false;
    }

    public boolean ccKeyUp(int keyCode) {
        if (this._actionsPaused) {
            return false;
        }
        if (this.keyboardInteractionEnabled) {
            int startingButton = this.focusedButton;
            if (keyCode == CCKeyboardManager.KC_DOWN || keyCode == CCKeyboardManager.KC_RIGHT || keyCode == CCKeyboardManager.KC_8 || keyCode == CCKeyboardManager.KC_6) {
                do {
                    ++this.focusedButton;
                    if (this.focusedButton >= this.children.size()) {
                        this.focusedButton = 0;
                    }
                    if (this.focusedButton >= 0) continue;
                    this.focusedButton = this.children.size() - 1;
                } while ((!((CCNode)this.children.elementAt((int)this.focusedButton)).visible || !((CCMenuItem)this.children.elementAt((int)this.focusedButton)).isEnabled) && this.focusedButton != startingButton);
                return true;
            }
            if (keyCode == CCKeyboardManager.KC_UP || keyCode == CCKeyboardManager.KC_LEFT || keyCode == CCKeyboardManager.KC_2 || keyCode == CCKeyboardManager.KC_4) {
                do {
                    --this.focusedButton;
                    if (this.focusedButton >= this.children.size()) {
                        this.focusedButton = 0;
                    }
                    if (this.focusedButton >= 0) continue;
                    this.focusedButton = this.children.size() - 1;
                } while ((!((CCNode)this.children.elementAt((int)this.focusedButton)).visible || !((CCMenuItem)this.children.elementAt((int)this.focusedButton)).isEnabled) && this.focusedButton != startingButton);
                return true;
            }
            if (keyCode == CCKeyboardManager.KC_CLICK || keyCode == CCKeyboardManager.KC_5 || keyCode == CCKeyboardManager.LEFT_SOFT_KEY) {
                ((CCMenuItem)this.children.elementAt(this.focusedButton)).fireEvent();
                return true;
            }
        }
        return false;
    }

    public void visit(Graphics g, long dt, boolean isParentVisible, boolean drawSelf) {
        int menuItemCount;
        int i = menuItemCount = this.children.size();
        while (i-- != 0) {
            ((CCNode)this.children.elementAt((int)i)).isTouchEnabled = this.isTouchEnabled;
        }
        if (this.touchDelegate == null && isParentVisible && this.visible && this.keyboardInteractionEnabled && menuItemCount > 0) {
            if (this.focusedButton >= menuItemCount) {
                this.focusedButton = 0;
            }
            if (this.focusedButton < 0) {
                this.focusedButton = menuItemCount - 1;
            }
            if (!((CCMenuItem)this.children.elementAt((int)this.focusedButton)).isEnabled) {
                ++this.focusedButton;
                if (this.focusedButton >= menuItemCount) {
                    this.focusedButton = 0;
                }
            }
            i = menuItemCount;
            while (i-- != 0) {
                ((CCMenuItem)this.children.elementAt((int)i)).isFocused = false;
            }
            if (((CCMenuItem)this.children.elementAt((int)this.focusedButton)).isEnabled) {
                ((CCMenuItem)this.children.elementAt((int)this.focusedButton)).isFocused = true;
            }
        }
        super.visit(g, dt, isParentVisible, drawSelf);
    }
}

