/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.nodes;

import cocos2d.cocos2d;
import cocos2d.extensions.ArabicReshaper;
import cocos2d.nodes.CCNode;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class CCLabelTTF
extends CCNode {
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int ALIGNMENT_CENTER = 1;
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_DEFAULT = -1;
    public int textAlignment = -1;
    private String string = "";
    private final Vector wrappedLines = new Vector(10, 5);
    private int maxLineWidth = Integer.MAX_VALUE;
    private int lineSpacing = 4;
    private int fontHeight = 0;
    private boolean drawStroke = false;
    public int color = 0;
    public int strokeColor = 0;
    public Font font = Font.getDefaultFont();

    public static final CCLabelTTF labelWithString(String text, Font font) {
        CCLabelTTF retObj = new CCLabelTTF();
        retObj.font = font;
        retObj.maxLineWidth = cocos2d.SCREEN_WIDTH;
        retObj.setString(text);
        return retObj;
    }

    public static final CCLabelTTF labelWithString(String text) {
        CCLabelTTF retObj = new CCLabelTTF();
        retObj.maxLineWidth = cocos2d.SCREEN_WIDTH;
        retObj.setString(text);
        return retObj;
    }

    public void setLineSpacing(int newSpacing) {
        if (this.lineSpacing != newSpacing) {
            this.lineSpacing = newSpacing;
            this.recalculateDimensions();
        }
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public void setStrokeEnabled(boolean enabled) {
        if (this.drawStroke != enabled) {
            this.drawStroke = enabled;
            this.recalculateDimensions();
        }
    }

    public void setMaxLineWidth(int newWidth) {
        if (this.maxLineWidth != newWidth) {
            this.maxLineWidth = newWidth;
            this.recalculateDimensions();
        }
    }

    public int getMaxLineWidth() {
        return this.maxLineWidth;
    }

    private void recalculateDimensions() {
        int i;
        this.fontHeight = this.font.getHeight();
        CCLabelTTF.wrapToLines(this.string, this.font, this.maxLineWidth - (this.drawStroke ? 2 : 0), this.wrappedLines);
        if (cocos2d.textContainsArabic(this.string)) {
            if (!cocos2d.supportsArabicProperly()) {
                i = this.wrappedLines.size();
                while (i-- != 0) {
                    this.wrappedLines.setElementAt(ArabicReshaper.Convert((String)this.wrappedLines.elementAt(i)), i);
                }
            } else {
                i = this.wrappedLines.size();
                while (i-- != 0) {
                    String tLine = (String)this.wrappedLines.elementAt(i);
                    if (tLine.charAt(0) < '\u0621') {
                        tLine = '\u200f' + tLine;
                    }
                    this.wrappedLines.setElementAt(tLine, i);
                }
            }
        }
        this.width = Integer.MIN_VALUE;
        i = this.wrappedLines.size();
        while (i-- != 0) {
            int tWidth = this.font.stringWidth((String)this.wrappedLines.elementAt(i));
            if (this.width >= tWidth) continue;
            this.width = tWidth;
        }
        this.height = (this.fontHeight + this.lineSpacing) * this.wrappedLines.size() - this.lineSpacing;
    }

    public void setString(String string) {
        if (!this.string.equals(string)) {
            this.string = string;
            if (cocos2d.textContainsArabic(this.string) && this.textAlignment == -1) {
                this.textAlignment = 2;
            }
            this.recalculateDimensions();
        }
    }

    public String getString() {
        return this.string;
    }

    public void setScale(int x, int y) {
        cocos2d.CCLog("WARINING: CCLabelTTF does not support scale modification");
    }

    public void setRotation(int rotation) {
        cocos2d.CCLog("WARINING: CCLabelTTF does not support rotation");
    }

    public static void wrapToLines(String text, Font f, int maxWidth, Vector lines) {
        lines.removeAllElements();
        if (text == null || f == null) {
            return;
        }
        if (text.indexOf(10) == -1 && f.stringWidth(text) < maxWidth) {
            lines.addElement(text);
        } else {
            char[] chars = text.toCharArray();
            int len = chars.length;
            int charWidth = 0;
            int curLinePosStart = 0;
            for (int count = 0; count < len; ++count) {
                boolean paragraphFormat;
                if (charWidth == 0 && curLinePosStart < count) {
                    charWidth = f.stringWidth(new String(chars, curLinePosStart, count - curLinePosStart));
                }
                if ((charWidth += f.charWidth(chars[count])) <= maxWidth - 4 && chars[count] != '\n' && count != len - 1) continue;
                boolean bl = paragraphFormat = chars[count] != '\n';
                if (count == len - 1) {
                    ++count;
                    paragraphFormat = false;
                }
                String line = new String(chars, curLinePosStart, count - curLinePosStart);
                if (paragraphFormat) {
                    int lastSpacePosition = line.lastIndexOf(32);
                    if (lastSpacePosition == -1) {
                        lines.addElement(line);
                        curLinePosStart = count;
                    } else {
                        String l = new String(chars, curLinePosStart, lastSpacePosition);
                        lines.addElement(l);
                        curLinePosStart = curLinePosStart + lastSpacePosition + 1;
                    }
                } else {
                    lines.addElement(line);
                    curLinePosStart = count < len && chars[count] == '\n' ? count + 1 : count;
                }
                charWidth = 0;
            }
        }
    }

    public void draw(Graphics g) {
        g.setFont(this.font);
        g.setColor(this.color | this._alphaRaw);
        this.getScreenPosition(this.drawPosition);
        int y = 0;
        int xPos = this.drawPosition.x;
        int yPos = -this.drawPosition.y - this.height;
        if (this.isRelativeAnchorPoint) {
            xPos -= this.anchorPoint.x == 0 ? 0 : this.width / (100 / this.anchorPoint.x);
            yPos += this.anchorPoint.y == 0 ? 0 : this.height / (100 / this.anchorPoint.y);
        }
        int linesCount = this.wrappedLines.size();
        cocos2d.setClip(g, 0, -cocos2d.SCREEN_HEIGHT, cocos2d.SCREEN_WIDTH, cocos2d.SCREEN_HEIGHT);
        for (int i = 0; i < linesCount; ++i) {
            int startMargin;
            int lineWidth;
            int finalDrawX;
            String line = (String)this.wrappedLines.elementAt(i);
            int finalDrawY = yPos + y;
            if (this.textAlignment == -1 || this.textAlignment == 0) {
                finalDrawX = xPos;
            } else if (this.textAlignment == 1) {
                lineWidth = this.font.stringWidth(line);
                startMargin = this.width - lineWidth >> 1;
                finalDrawX = xPos + startMargin;
            } else {
                lineWidth = this.font.stringWidth(line);
                startMargin = this.width - lineWidth;
                finalDrawX = xPos + startMargin;
            }
            if (this.drawStroke) {
                g.setColor(this.strokeColor | this._alphaRaw);
                g.drawString(line, finalDrawX + 1, finalDrawY, 20);
                g.drawString(line, finalDrawX - 1, finalDrawY, 20);
                g.drawString(line, finalDrawX, finalDrawY + 1, 20);
                g.drawString(line, finalDrawX, finalDrawY - 1, 20);
                g.setColor(this.color | this._alphaRaw);
            }
            g.drawString(line, finalDrawX, finalDrawY, 20);
            y += i != linesCount - 1 ? this.fontHeight + this.lineSpacing : 0;
        }
    }
}

