/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.extensions;

import javax.microedition.rms.RecordStore;

public class MyIO {
    private static RecordStore rs;
    private static int nextid;

    public static String load(String rsName) {
        rs = MyIO.openRecordStore(rsName);
        nextid = MyIO.getNextRecordID(rs);
        if ((byte)(nextid == 1 ? -1 : 0) != 0) {
            MyIO.addRecord(rs, "");
        }
        return MyIO.getRecord(rs, 1);
    }

    public static byte[] loadBytes(String rsName) {
        rs = MyIO.openRecordStore(rsName);
        nextid = MyIO.getNextRecordID(rs);
        if ((byte)(nextid == 1 ? -1 : 0) != 0) {
            MyIO.addRecordBytes(rs, new byte[0]);
        }
        return MyIO.getRecordBytes(rs, 1);
    }

    public static void save(String rsName, String data) {
        rs = MyIO.openRecordStore(rsName);
        if (MyIO.getNumRecords(rs) == 0) {
            nextid = MyIO.getNextRecordID(rs);
            MyIO.addRecord(rs, "");
        }
        MyIO.setRecord(rs, data, 1);
    }

    public static void saveBytes(String rsName, byte[] data) {
        rs = MyIO.openRecordStore(rsName);
        if (MyIO.getNumRecords(rs) == 0) {
            nextid = MyIO.getNextRecordID(rs);
            MyIO.addRecordBytes(rs, new byte[0]);
        }
        MyIO.setRecordBytes(rs, data, 1);
    }

    private static RecordStore openRecordStore(String s) {
        try {
            return RecordStore.openRecordStore((String)s, (boolean)true);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void closeRecordStore(RecordStore recordstore) {
        try {
            recordstore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void deleteRecordStore(String s) {
        try {
            RecordStore.deleteRecordStore((String)s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void deleteRecord(RecordStore recordstore, int i) {
        try {
            recordstore.deleteRecord(i);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int addRecordBytes(RecordStore recordstore, byte[] s) {
        try {
            return recordstore.addRecord(s, 0, s.length);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static int addRecord(RecordStore recordstore, String s) {
        try {
            return recordstore.addRecord(s.getBytes(), 0, s.length());
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static void setRecordBytes(RecordStore recordstore, byte[] s, int i) {
        try {
            recordstore.setRecord(i, s, 0, s.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void setRecord(RecordStore recordstore, String s, int i) {
        try {
            recordstore.setRecord(i, s.getBytes(), 0, s.getBytes().length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int getNextRecordID(RecordStore recordstore) {
        try {
            return recordstore.getNextRecordID();
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static byte[] getRecordBytes(RecordStore recordstore, int i) {
        try {
            return recordstore.getRecord(i);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getRecord(RecordStore recordstore, int i) {
        try {
            byte[] abyte0 = recordstore.getRecord(i);
            if (abyte0 == null) {
                return "";
            }
            return new String(abyte0);
        }
        catch (Exception e) {
            return "";
        }
    }

    private static int getNumRecords(RecordStore recordstore) {
        try {
            return recordstore.getNumRecords();
        }
        catch (Exception e) {
            return 0;
        }
    }

    static {
        nextid = 0;
    }
}

