/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.extensions;

import cocos2d.CCTouchDispatcher;
import cocos2d.cocos2d;
import cocos2d.nodes.CCNode;
import cocos2d.types.CCPoint;
import cocos2d.types.CCTouch;
import cocos2d.types.Real;
import javax.microedition.lcdui.Graphics;

public class CCVirtualPad
extends CCNode {
    final CCPoint drawPosition = CCPoint.ccp(0, 0);
    static final Real tmpReal = new Real();
    static final Real tmpReal2 = new Real();
    static final Real percentReal = new Real();
    static final Real angleInDegreesReal = new Real();
    CCPoint lastTouchPos = CCPoint.ccp(0, 0);
    public int nibWidth = 16;
    final int DEADZONE_THRESHOLD;
    boolean touched = false;
    int angle = 0;
    int power = 0;
    int color = 0xFF0000;

    public CCVirtualPad() {
        this.DEADZONE_THRESHOLD = 5;
        this.height = 64;
        this.width = 64;
        percentReal.assign(this.width);
        percentReal.div(2);
        percentReal.mul(Real.PERCENT);
        percentReal.recip();
        angleInDegreesReal.assign(Real._180);
        angleInDegreesReal.div(Real.PI);
    }

    public int getAngle() {
        return this.angle;
    }

    public void onEnter() {
        CCTouchDispatcher.sharedDispatcher().addTargetedDelegate(this);
        super.onEnter();
    }

    public void onExit() {
        super.onExit();
        CCTouchDispatcher.sharedDispatcher().removeDelegate(this);
    }

    public boolean ccTouchBegan(CCTouch touch) {
        if (!this.touched) {
            this.position.set(touch.position);
            this.lastTouchPos.set(touch.position);
            this.touched = true;
            return true;
        }
        return false;
    }

    public void ccTouchMoved(CCTouch touch) {
        this.lastTouchPos.set(touch.position);
    }

    public void ccTouchEnded(CCTouch touch) {
        this.lastTouchPos.set(touch.position);
        this.touched = false;
        this.power = 0;
    }

    public void draw(Graphics g) {
        if (this.touched) {
            int halfWidth = this.width >> 1;
            int cropW = (int)((float)this.width * this.scale.x);
            int cropH = (int)((float)this.width * this.scale.y);
            this.getScreenPosition(this.drawPosition);
            this.drawPosition.x = this.drawPosition.x - (this.anchorPoint.x == 0 ? 0 : cropW / (100 / this.anchorPoint.x));
            this.drawPosition.y = this.drawPosition.y - (this.anchorPoint.y == 0 ? 0 : cropH / (100 / this.anchorPoint.y));
            int nibPosx = this.drawPosition.x + halfWidth - this.lastTouchPos.x;
            int nibPosy = this.drawPosition.y + halfWidth - this.lastTouchPos.y;
            tmpReal.assign(nibPosx * nibPosx + nibPosy * nibPosy);
            tmpReal.sqrt();
            int length = tmpReal.toInteger();
            if (length > halfWidth) {
                tmpReal.assign(nibPosx);
                tmpReal.div(length);
                tmpReal.mul(halfWidth);
                nibPosx = tmpReal.toInteger();
                tmpReal.assign(nibPosy);
                tmpReal.div(length);
                tmpReal.mul(halfWidth);
                nibPosy = tmpReal.toInteger();
                length = halfWidth;
            }
            tmpReal.assign(length);
            tmpReal.mul(percentReal);
            if (length > 5) {
                this.power = tmpReal.toInteger();
                this.angle = this.calcAngle(0, 0, nibPosx, nibPosy).toInteger();
            } else {
                this.power = 0;
            }
            cocos2d.setClip(g, 0, -cocos2d.SCREEN_HEIGHT, cocos2d.SCREEN_WIDTH, cocos2d.SCREEN_HEIGHT);
            g.setColor(this.color | this._alphaRaw);
            g.drawRoundRect(this.drawPosition.x, -this.drawPosition.y - this.width, this.width, this.width, this.width, this.width);
            g.drawRoundRect(this.drawPosition.x - this.nibWidth / 2 + halfWidth - nibPosx, -this.drawPosition.y - this.nibWidth / 2 - this.width + halfWidth + nibPosy, this.nibWidth, this.nibWidth, this.nibWidth, this.nibWidth);
        }
    }

    private Real calcAngle(int x, int y, int x1, int y1) {
        tmpReal.assign(y1 - y);
        tmpReal2.assign(x1 - x);
        tmpReal2.atan2(tmpReal);
        tmpReal2.mul(angleInDegreesReal);
        return tmpReal2;
    }
}

