/*
 * Decompiled with CFR 0.152.
 */
package cocos2d;

import cocos2d.cocos2d;
import cocos2d.extensions.LinkedList;
import cocos2d.nodes.CCNode;
import cocos2d.types.CCPoint;
import cocos2d.types.CCTouch;
import java.util.Vector;

public final class CCTouchDispatcher {
    static final int TOUCH_BEGAN = 1;
    static final int TOUCH_MOVED = 2;
    static final int TOUCH_ENDED = 3;
    private static final Vector delegates = new Vector(5);
    private LinkedList buffer = new LinkedList();
    private static CCTouchDispatcher dispatcher = null;
    private final CCNode[] currentTarget = new CCNode[2];
    private static final boolean[] fingerBegan = new boolean[10];

    public static final CCTouchDispatcher sharedDispatcher() {
        if (dispatcher == null) {
            dispatcher = new CCTouchDispatcher();
        }
        return dispatcher;
    }

    private CCTouchDispatcher() {
    }

    void flushBuffer() {
        this.buffer.removeAllElements();
    }

    public String printState() {
        return "cache size:" + delegates.size() + "\ncontents:" + delegates.toString();
    }

    public void addTargetedDelegate(CCNode delegateObject) {
        if (!delegates.contains(delegateObject)) {
            delegates.addElement(delegateObject);
        }
    }

    public void removeDelegate(CCNode delegateObject) {
        delegates.removeElement(delegateObject);
    }

    public void removeAllDelegates() {
        delegates.removeAllElements();
    }

    void handleTouchEvent(CCPoint touchPos, int touchState, int fingerId) {
        CCTouchDispatcher.touchToWorldCoords(touchPos);
        this.buffer.insertLast(new CCTouch(touchPos, touchState, fingerId));
    }

    void processTouchBuffer(boolean rotated) {
        block6: while (!this.buffer.isEmpty()) {
            CCTouch event = (CCTouch)this.buffer.removeFirst();
            if (rotated) {
                int tmpC = event.position.x;
                event.position.x = event.position.y;
                event.position.y = cocos2d.SCREEN_HEIGHT - tmpC;
            }
            if (event.touchState == 1 && this.currentTarget[event.finger] == null) {
                CCTouchDispatcher.fingerBegan[event.finger] = true;
                int i = delegates.size();
                while (i-- != 0) {
                    try {
                        CCNode node = (CCNode)delegates.elementAt(i);
                        if (!node.isTouchEnabled || !node.ccTouchBegan(event)) continue;
                        this.currentTarget[event.finger] = node;
                        continue block6;
                    }
                    catch (Exception ex) {
                        cocos2d.CCLog(this.currentTarget[event.finger] + ":ccTouchBegan: " + ex);
                    }
                }
                continue;
            }
            if (!(event.touchState != 2 || this.currentTarget[event.finger] == null && fingerBegan[event.finger])) {
                if (!fingerBegan[event.finger]) {
                    event.touchState = 1;
                    this.buffer.insertFirst(event);
                }
                try {
                    this.currentTarget[event.finger].ccTouchMoved(event);
                }
                catch (Exception ex) {
                    cocos2d.CCLog(this.currentTarget[event.finger] + ":ccTouchMoved: " + ex);
                }
                continue;
            }
            if (event.touchState != 3 || this.currentTarget[event.finger] == null) continue;
            CCTouchDispatcher.fingerBegan[event.finger] = false;
            try {
                this.currentTarget[event.finger].ccTouchEnded(event);
            }
            catch (Exception ex) {
                cocos2d.CCLog(this.currentTarget[event.finger] + ":ccTouchEnded: " + ex);
            }
            this.currentTarget[event.finger] = null;
        }
    }

    static final void touchToWorldCoords(CCPoint touch) {
        touch.y = cocos2d.REAL_SCREEN_HEIGHT - touch.y;
    }
}

