/*
 * Decompiled with CFR 0.152.
 */
package cocos2d;

import cocos2d.CCDirector;
import cocos2d.cocos2d;
import cocos2d.extensions.LinkedList;
import cocos2d.keyEvent;
import cocos2d.keyStateObject;
import cocos2d.nodes.CCNode;
import cocos2d.types.MutableInteger;
import java.util.Hashtable;
import java.util.Vector;

public class CCKeyboardManager {
    protected static CCKeyboardManager manager = null;
    protected static final Vector delegates = new Vector(5);
    protected final LinkedList buffer = new LinkedList();
    public static final int KEY_STATE_DOWN = 1;
    public static final int KEY_STATE_UP = 2;
    public static int KC_UP = -1;
    public static int KC_DOWN = -2;
    public static int KC_LEFT = -3;
    public static int KC_RIGHT = -4;
    public static int KC_CLICK = -5;
    public static int KC_CALL = -10;
    public static int KC_CLEAR = -8;
    public static int KC_PEN = -50;
    public static int KC_0 = 48;
    public static int KC_1 = 49;
    public static int KC_2 = 50;
    public static int KC_3 = 51;
    public static int KC_4 = 52;
    public static int KC_5 = 53;
    public static int KC_6 = 54;
    public static int KC_7 = 55;
    public static int KC_8 = 56;
    public static int KC_9 = 57;
    public static int KC_STAR = 42;
    public static int KC_POUND = 35;
    public static int LEFT_SOFT_KEY = 0;
    public static int RIGHT_SOFT_KEY = 0;
    protected static final Hashtable states = new Hashtable(16);
    private static final MutableInteger tIntegerObj = new MutableInteger(0);

    public static final CCKeyboardManager sharedManager() {
        if (manager == null) {
            manager = new CCKeyboardManager();
        }
        return manager;
    }

    public String printState() {
        return "cache size:" + delegates.size() + "\ncontents:" + delegates.toString();
    }

    public final void enableNokiaQuerty() {
        KC_0 = 109;
        KC_1 = 114;
        KC_2 = 116;
        KC_3 = 121;
        KC_4 = 102;
        KC_5 = 103;
        KC_6 = 104;
        KC_7 = 118;
        KC_8 = 98;
        KC_9 = 110;
        KC_STAR = 117;
        KC_POUND = 106;
    }

    public final void enableSamsungQuerty() {
        KC_0 = 63;
        KC_1 = 101;
        KC_2 = 114;
        KC_3 = 116;
        KC_4 = 100;
        KC_5 = 102;
        KC_6 = 103;
        KC_7 = 120;
        KC_8 = 99;
        KC_9 = 118;
        KC_STAR = 115;
        KC_POUND = 98;
    }

    public final void enableAlcatel() {
        KC_UP = -1;
        KC_DOWN = -6;
        KC_LEFT = -2;
        KC_RIGHT = -5;
        KC_CLICK = -20;
        LEFT_SOFT_KEY = -21;
        RIGHT_SOFT_KEY = -22;
    }

    public final void enableAlcatelQuerty() {
        KC_0 = 37;
        KC_1 = 119;
        KC_2 = 101;
        KC_3 = 114;
        KC_4 = 115;
        KC_5 = 100;
        KC_6 = 102;
        KC_7 = 122;
        KC_8 = 120;
        KC_9 = 99;
        KC_STAR = 97;
        KC_POUND = 113;
    }

    public final void enablePantechQuerty() {
        KC_0 = 63;
        KC_1 = 101;
        KC_2 = 114;
        KC_3 = 116;
        KC_4 = 100;
        KC_5 = 102;
        KC_6 = 103;
        KC_7 = 120;
        KC_8 = 99;
        KC_9 = 118;
        KC_STAR = 122;
        KC_POUND = 98;
    }

    public final void enableIdenQuerty() {
        KC_0 = 43;
        KC_1 = 101;
        KC_2 = 114;
        KC_3 = 116;
        KC_4 = 115;
        KC_5 = 100;
        KC_6 = 102;
        KC_7 = 120;
        KC_8 = 99;
        KC_9 = 118;
        KC_STAR = 122;
        KC_POUND = 98;
    }

    void flushBuffer() {
        this.buffer.removeAllElements();
    }

    CCKeyboardManager() {
        this.setDeviceKeys();
    }

    public void addTargetedDelegate(CCNode delegateObject) {
        if (!delegates.contains(delegateObject)) {
            delegates.addElement(delegateObject);
        }
    }

    public void removeDelegate(CCNode delegateObject) {
        delegates.removeElement(delegateObject);
    }

    public void removeAllDelegates() {
        delegates.removeAllElements();
    }

    void handleKeyboardEvent(int keyCode, int keyState) {
        if (keyCode == LEFT_SOFT_KEY || keyCode == RIGHT_SOFT_KEY) {
            if (keyState == 1) {
                this.buffer.insertLast(new keyEvent(keyCode, 1));
                this.buffer.insertLast(new keyEvent(keyCode, 2));
            }
        } else {
            this.buffer.insertLast(new keyEvent(keyCode, keyState));
        }
    }

    private void updateState(int keyCode, int keyState) {
        MutableInteger keyCodeObject = new MutableInteger(keyCode);
        keyStateObject tmpState = (keyStateObject)states.get(keyCodeObject);
        if (tmpState == null) {
            tmpState = new keyStateObject(keyCode, keyState == 1);
            states.put(keyCodeObject, tmpState);
        } else {
            tmpState.pressed = keyState == 1;
        }
    }

    public boolean isKeyPressed(int keyCode) {
        keyStateObject tmpState = (keyStateObject)states.get(tIntegerObj.set(keyCode));
        if (tmpState == null) {
            return false;
        }
        return tmpState.pressed;
    }

    void processKeyBuffer(boolean rotated) {
        while (!this.buffer.isEmpty()) {
            int i;
            keyEvent event = (keyEvent)this.buffer.removeFirst();
            if (rotated) {
                if (event.keyCode == KC_LEFT) {
                    event.keyCode = KC_UP;
                } else if (event.keyCode == KC_RIGHT) {
                    event.keyCode = KC_DOWN;
                } else if (event.keyCode == KC_UP) {
                    event.keyCode = KC_RIGHT;
                } else if (event.keyCode == KC_DOWN) {
                    event.keyCode = KC_LEFT;
                }
            }
            this.updateState(event.keyCode, event.keyState);
            if (event.keyState == 1) {
                i = delegates.size();
                while (i-- != 0 && !((CCNode)delegates.elementAt(i)).ccKeyDown(event.keyCode)) {
                }
                continue;
            }
            if (event.keyState != 2) continue;
            i = delegates.size();
            while (i-- != 0 && !((CCNode)delegates.elementAt(i)).ccKeyUp(event.keyCode)) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setDeviceKeys() {
        LEFT_SOFT_KEY = 0;
        RIGHT_SOFT_KEY = 0;
        String platform = CCDirector.sharedDirector().platformName;
        if (platform.equals("BlackBerry")) {
            KC_UP = 1;
            KC_DOWN = 6;
            KC_LEFT = 2;
            KC_RIGHT = 5;
            KC_CLICK = -8;
            KC_CALL = 0x110000;
            LEFT_SOFT_KEY = 0x110000;
            RIGHT_SOFT_KEY = 0x120000;
            KC_0 = 0x300000;
            KC_1 = 0x570000;
            KC_2 = 0x450000;
            KC_3 = 0x520000;
            KC_4 = 0x530000;
            KC_5 = 0x440000;
            KC_6 = 0x460000;
            KC_7 = 0x5A0000;
            KC_8 = 0x580000;
            KC_9 = 0x430000;
            KC_STAR = 0x410000;
            KC_POUND = 0x510000;
        }
        if (platform.indexOf("Samsung") != -1) {
            LEFT_SOFT_KEY = -6;
            RIGHT_SOFT_KEY = -7;
        }
        if (platform.equals("LG")) {
            try {
                if (cocos2d.canvas.getKeyName(-6).toUpperCase().indexOf("SOFT") >= 0) {
                    LEFT_SOFT_KEY = -6;
                    RIGHT_SOFT_KEY = -7;
                } else if (cocos2d.canvas.getKeyName(-202).toUpperCase().indexOf("SOFT") >= 0) {
                    LEFT_SOFT_KEY = -202;
                    RIGHT_SOFT_KEY = -203;
                }
            }
            catch (Exception e) {
            }
            finally {
                if (LEFT_SOFT_KEY == 0) {
                    LEFT_SOFT_KEY = -202;
                    RIGHT_SOFT_KEY = -203;
                }
            }
        }
        if (platform.indexOf("Moto") != -1) {
            if (!"V8".equals(System.getProperty("device.model"))) {
                KC_UP = -1;
                KC_DOWN = -6;
                KC_LEFT = -2;
                KC_RIGHT = -5;
                KC_CLICK = -20;
            }
            try {
                if (cocos2d.canvas.getKeyName(-21).toUpperCase().indexOf("SOFT") >= 0) {
                    LEFT_SOFT_KEY = -21;
                    RIGHT_SOFT_KEY = -22;
                } else {
                    LEFT_SOFT_KEY = 21;
                    RIGHT_SOFT_KEY = 22;
                }
            }
            catch (Exception e) {
                LEFT_SOFT_KEY = -21;
                RIGHT_SOFT_KEY = -22;
            }
        }
        if (platform.toLowerCase().indexOf("iden") != -1) {
            KC_UP = -10;
            KC_DOWN = -11;
            KC_LEFT = -13;
            KC_RIGHT = -12;
            KC_CLICK = -23;
            LEFT_SOFT_KEY = -20;
            RIGHT_SOFT_KEY = -21;
            KC_STAR = 97;
            KC_POUND = 113;
        }
        if (LEFT_SOFT_KEY == 0) {
            try {
                if (cocos2d.canvas.getKeyName(21).toUpperCase().indexOf("SOFT") >= 0) {
                    LEFT_SOFT_KEY = 21;
                    RIGHT_SOFT_KEY = 22;
                } else if (cocos2d.canvas.getKeyName(-6).toUpperCase().indexOf("SOFT") >= 0) {
                    LEFT_SOFT_KEY = -6;
                    RIGHT_SOFT_KEY = -7;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (LEFT_SOFT_KEY == 0) {
            for (int i = -127; i < 127; ++i) {
                try {
                    if (cocos2d.canvas.getKeyName(i).toUpperCase().indexOf("SOFT") < 0) continue;
                    if (cocos2d.canvas.getKeyName(i).indexOf(49) >= 0) {
                        LEFT_SOFT_KEY = i;
                    }
                    if (cocos2d.canvas.getKeyName(i).indexOf(50) < 0) continue;
                    RIGHT_SOFT_KEY = i;
                    continue;
                }
                catch (Exception e) {
                    LEFT_SOFT_KEY = -6;
                    RIGHT_SOFT_KEY = -7;
                }
            }
        }
    }
}

