/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.types;

import cocos2d.cocos2d;
import javax.microedition.lcdui.Image;

public class CCTexture2D {
    public Image image;
    public String name;
    public int width;
    public int height;

    public static final CCTexture2D textureWithFile(String filename) {
        return new CCTexture2D(filename);
    }

    private CCTexture2D() {
    }

    public CCTexture2D(String filename) {
        if (!filename.startsWith("http:")) {
            try {
                this.image = Image.createImage((String)("/" + filename));
                this.width = this.image.getWidth();
                this.height = this.image.getHeight();
            }
            catch (Exception ex) {
                cocos2d.CCLog("CCTexture2D: cannot load " + filename + " because " + ex.toString());
            }
        }
        this.name = filename;
    }

    public CCTexture2D(String filename, Image imageObj) {
        try {
            this.image = imageObj;
            this.width = this.image.getWidth();
            this.height = this.image.getHeight();
            this.name = filename;
        }
        catch (Exception ex) {
            cocos2d.CCLog("CCTexture2D: cannot load " + filename + " because " + ex.toString());
        }
    }

    public static final CCTexture2D flipTexture(CCTexture2D texture) {
        CCTexture2D retObj = new CCTexture2D();
        try {
            retObj.image = Image.createImage((Image)texture.image, (int)0, (int)0, (int)texture.width, (int)texture.height, (int)2);
            retObj.width = texture.width;
            retObj.height = texture.height;
            retObj.name = texture.name + "flip";
        }
        catch (Exception ex) {
            cocos2d.CCLog("CCTexture2D: flip cannot load " + texture.name + " because " + ex.toString());
        }
        return retObj;
    }
}

