/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.types;

import cocos2d.types.CCPoint;
import cocos2d.types.CCSize;

public class CCRect {
    public CCPoint position;
    public CCSize size;

    public CCRect() {
        this(0, 0, 0, 0);
    }

    private CCRect(CCPoint origin, CCSize size) {
        this(origin.x, origin.y, size.width, size.height);
    }

    public static CCRect make(CCPoint origin, CCSize size) {
        return new CCRect(origin.x, origin.y, size.width, size.height);
    }

    public static CCRect make(int x, int y, int w, int h) {
        return new CCRect(x, y, w, h);
    }

    private CCRect(int x, int y, int w, int h) {
        this.position = CCPoint.ccp(x, y);
        this.size = CCSize.make(w, h);
    }

    public boolean contains(int x, int y) {
        return this.size.width > 0 && this.size.height > 0 && x >= this.position.x && x < this.position.x + this.size.width && y >= this.position.y && y < this.position.y + this.size.height;
    }

    public String toString() {
        return "((" + this.position.x + ", " + this.position.y + "),(" + this.size.width + ", " + this.size.height + "))";
    }

    public static boolean equalToRect(CCRect r1, CCRect r2) {
        return CCPoint.equalToPoint(r1.position, r2.position) && CCSize.equalToSize(r1.size, r2.size);
    }

    public static boolean containsPoint(CCRect aRect, CCPoint aPoint) {
        return aPoint.x >= CCRect.minX(aRect) && aPoint.y >= CCRect.minY(aRect) && aPoint.x < CCRect.maxX(aRect) && aPoint.y < CCRect.maxY(aRect);
    }

    public static boolean containsRect(CCRect aRect, CCRect bRect) {
        return !CCRect.isEmptyRect(bRect) && CCRect.minX(aRect) <= CCRect.minX(bRect) && CCRect.minY(aRect) <= CCRect.minY(bRect) && CCRect.maxX(aRect) >= CCRect.maxX(bRect) && CCRect.maxY(aRect) >= CCRect.maxY(bRect);
    }

    public static int maxX(CCRect aRect) {
        return aRect.position.x + aRect.size.width;
    }

    public static int maxY(CCRect aRect) {
        return aRect.position.y + aRect.size.height;
    }

    public static int midX(CCRect aRect) {
        return aRect.position.x + aRect.size.width / 2;
    }

    public static int midY(CCRect aRect) {
        return aRect.position.y + aRect.size.height / 2;
    }

    public static int minX(CCRect aRect) {
        return aRect.position.x;
    }

    public static int minY(CCRect aRect) {
        return aRect.position.y;
    }

    public static int width(CCRect aRect) {
        return aRect.size.width;
    }

    public static int height(CCRect aRect) {
        return aRect.size.height;
    }

    public static boolean isEmptyRect(CCRect aRect) {
        return aRect.size.width <= 0 || aRect.size.height <= 0;
    }

    public static boolean intersectsRect(CCRect aRect, CCRect bRect) {
        return CCRect.maxX(aRect) > CCRect.minX(bRect) && CCRect.maxX(bRect) > CCRect.minX(aRect) && CCRect.maxY(aRect) > CCRect.minY(bRect) && CCRect.maxY(bRect) > CCRect.minY(aRect);
    }
}

