/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.types;

public class CCPointF {
    public float x;
    public float y;

    public static final CCPointF zero() {
        return new CCPointF(0.0f, 0.0f);
    }

    public CCPointF() {
        this(0.0f, 0.0f);
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(CCPointF pPoint) {
        this.x = pPoint.x;
        this.y = pPoint.y;
    }

    public CCPointF copy() {
        return CCPointF.ccp(this.x, this.y);
    }

    public CCPointF(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public static final boolean equalToPoint(CCPointF p1, CCPointF p2) {
        return p1.x == p2.x && p1.y == p2.y;
    }

    public static final CCPointF ccp(float x, float y) {
        return new CCPointF(x, y);
    }

    public static final CCPointF ccpAdd(CCPointF v1, CCPointF v2) {
        return CCPointF.ccp(v1.x + v2.x, v1.y + v2.y);
    }

    public static final CCPointF ccpSub(CCPointF v1, CCPointF v2) {
        return CCPointF.ccp(v1.x - v2.x, v1.y - v2.y);
    }

    public static final CCPointF ccpMult(CCPointF v, int s) {
        return CCPointF.ccp(v.x * (float)s, v.y * (float)s);
    }

    public boolean isEqual(CCPointF obj) {
        return this.x == obj.x && this.y == obj.y;
    }
}

