/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.nodes;

import cocos2d.cocos2d;
import cocos2d.nodes.CCMenuItem;
import cocos2d.nodes.CCNode;
import cocos2d.types.CCFunction;
import cocos2d.types.CCPoint;
import cocos2d.types.CCTouch;
import javax.microedition.lcdui.Graphics;

public class CCMenuItemInvisible
extends CCMenuItem {
    boolean isTouching = false;

    public static CCMenuItemInvisible itemWithImages(int width, int height, CCFunction callback) {
        return new CCMenuItemInvisible(width, height, callback);
    }

    public static CCMenuItemInvisible itemWithImages(int width, int height, CCNode delegate) {
        return new CCMenuItemInvisible(width, height, delegate);
    }

    public CCMenuItemInvisible(int width, int height, CCNode delegate) {
        this.delegate = delegate;
        this.width = width;
        this.height = height;
        this.zOrder = -999;
    }

    public CCMenuItemInvisible(int width, int height, CCFunction callback) {
        this.callback = callback;
        this.width = width;
        this.height = height;
        this.zOrder = -999;
    }

    private boolean isTouchInBounds(CCPoint touch) {
        int cropW = (int)((float)this.width * this.scale.x);
        int cropH = (int)((float)this.height * this.scale.y);
        this.getScreenPosition(this.drawPosition);
        this.drawPosition.x = this.drawPosition.x - (this.anchorPoint.x == 0 ? 0 : cropW / (100 / this.anchorPoint.x));
        this.drawPosition.y = this.drawPosition.y - (this.anchorPoint.y == 0 ? 0 : cropH / (100 / this.anchorPoint.y));
        return this.drawPosition.x <= touch.x && this.drawPosition.y <= touch.y && this.drawPosition.y + cropH >= touch.y && this.drawPosition.x + cropW >= touch.x;
    }

    public boolean ccTouchBegan(CCTouch touch) {
        if (this._actionsPaused) {
            return false;
        }
        if (this.isEnabled && this.visible && this.isTouchInBounds(touch.position)) {
            this.isTouching = true;
            if (this.callbackOnTouchDown) {
                this.fireEvent();
            }
            return true;
        }
        return false;
    }

    public void ccTouchEnded(CCTouch touch) {
        if (!this._actionsPaused && this.isEnabled && this.visible && this.isTouchInBounds(touch.position) && !this.callbackOnTouchDown) {
            this.fireEvent();
        }
        this.isTouching = false;
    }

    public void draw(Graphics g) {
        if (cocos2d.DEBUG) {
            cocos2d.setClip(g, 0, -cocos2d.SCREEN_HEIGHT, cocos2d.SCREEN_WIDTH, cocos2d.SCREEN_HEIGHT);
            this.getScreenPosition(this.drawPosition);
            this.drawPosition.x = (int)((float)this.drawPosition.x - (this.anchorPoint.x == 0 ? 0.0f : (float)this.width * this.scale.x / (float)(100 / this.anchorPoint.x)));
            this.drawPosition.y = (int)((float)this.drawPosition.y - (this.anchorPoint.y == 0 ? 0.0f : (float)this.height * this.scale.y / (float)(100 / this.anchorPoint.y)));
            g.setColor(0xFF00FF | this._alphaRaw);
            g.drawRect(this.drawPosition.x, -this.drawPosition.y - this.height, this.width, this.height);
        }
    }
}

