/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.extensions;

import cocos2d.CCTextureCache;
import cocos2d.cocos2d;
import cocos2d.nodes.CCNode;
import cocos2d.types.CCPoint;
import cocos2d.types.CCTexture2D;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CCSpriteScale9
extends CCNode {
    private CCTexture2D texture;
    private int leftOffset;
    private int topOffset;
    private String filename;
    private int lastScaledWidth;
    private int lastScaledHeight;
    private static final byte FP_BITS = 13;
    private CCPoint drawPosition = CCPoint.ccp(0, 0);
    public final Vector scaleHistory = new Vector(2, 5);

    public CCSpriteScale9(String resPath, int leftOffset, int topOffset) {
        this.filename = resPath;
        this.leftOffset = leftOffset;
        this.topOffset = topOffset;
    }

    public static CCSpriteScale9 spriteWithFile(String filename, int leftOffset, int topOffset) {
        return new CCSpriteScale9(filename, leftOffset, topOffset);
    }

    private void scaleByStretching() {
        int currOutputOffset;
        int currTextureOffset;
        int scaledWidth = this.width - (this.leftOffset << 1);
        int scaledHeight = this.height - (this.topOffset << 1);
        this.texture = CCTextureCache.sharedTextureCache().textureForKey(this.filename + this.width + this.height);
        if (this.texture != null || scaledWidth < 0 || scaledHeight < 0) {
            return;
        }
        CCTexture2D tmpTexture = CCTextureCache.sharedTextureCache().addImage(this.filename);
        int[] outputRGB = new int[this.width * this.height];
        CCSpriteScale9.intfill(outputRGB, 0xFFFFFF);
        int[] textureRgb = this.getTextureRgb();
        int origWidth = tmpTexture.width - (this.leftOffset << 1);
        int origHeight = tmpTexture.height - (this.topOffset << 1);
        int ratioW = (origWidth << 13) / scaledWidth;
        int ratioH = (origHeight << 13) / scaledHeight;
        int targetDefaultOffset = this.topOffset * this.width + this.leftOffset;
        int commonInitIndex = this.topOffset * tmpTexture.width + this.leftOffset;
        for (int destY = 0; destY < scaledHeight; ++destY) {
            int srcY = destY * ratioH >> 13;
            int iInitialIndex = srcY * tmpTexture.width + commonInitIndex;
            for (int destX = 0; destX < scaledWidth; ++destX) {
                int srcX = destX * ratioW >> 13;
                outputRGB[targetDefaultOffset + destX + destY * this.width] = textureRgb[srcX + iInitialIndex];
            }
        }
        int origDefaultOffset = tmpTexture.width - this.leftOffset;
        targetDefaultOffset = this.width - this.leftOffset;
        int i = this.topOffset;
        while (i-- != 0) {
            currTextureOffset = i * tmpTexture.width;
            currOutputOffset = i * this.width;
            System.arraycopy(textureRgb, currTextureOffset, outputRGB, currOutputOffset, this.leftOffset);
            System.arraycopy(textureRgb, origDefaultOffset + currTextureOffset, outputRGB, targetDefaultOffset + currOutputOffset, this.leftOffset);
        }
        int origDefaultOffsetAlt = (tmpTexture.height - this.topOffset) * tmpTexture.width;
        int targetDefaultOffsetAlt = (this.height - this.topOffset) * this.width;
        origDefaultOffset += origDefaultOffsetAlt;
        targetDefaultOffset += targetDefaultOffsetAlt;
        int i2 = this.topOffset;
        while (i2-- != 0) {
            currTextureOffset = i2 * tmpTexture.width;
            currOutputOffset = i2 * this.width;
            System.arraycopy(textureRgb, origDefaultOffsetAlt + currTextureOffset, outputRGB, targetDefaultOffsetAlt + currOutputOffset, this.leftOffset);
            System.arraycopy(textureRgb, origDefaultOffset + currTextureOffset, outputRGB, targetDefaultOffset + currOutputOffset, this.leftOffset);
        }
        this.stretchBorder(outputRGB, textureRgb, this.leftOffset, origHeight, this.leftOffset, scaledHeight, this.topOffset * this.width, this.topOffset * tmpTexture.width);
        this.stretchBorder(outputRGB, textureRgb, this.leftOffset, origHeight, this.leftOffset, scaledHeight, (this.topOffset + 1) * this.width - this.leftOffset, (this.topOffset + 1) * tmpTexture.width - this.leftOffset);
        this.stretchBorder(outputRGB, textureRgb, origWidth, this.topOffset, scaledWidth, this.topOffset, this.leftOffset, this.leftOffset);
        this.stretchBorder(outputRGB, textureRgb, origWidth, this.topOffset, scaledWidth, this.topOffset, (this.height - this.topOffset) * this.width + this.leftOffset, (tmpTexture.height - this.topOffset) * tmpTexture.width + this.leftOffset);
        CCTexture2D newTexture = new CCTexture2D(this.filename + this.width + this.height, Image.createRGBImage((int[])outputRGB, (int)this.width, (int)this.height, (boolean)true));
        CCTextureCache.sharedTextureCache().addToCache(newTexture);
        this.texture = newTexture;
        this.scaleHistory.addElement(this.texture.name);
    }

    private void stretchBorder(int[] outputRGB, int[] textureRgb, int origWidth, int origHeight, int scaledWidth, int scaledHeight, int targetDefaultOffset, int origDefaultOffset) {
        int ratioW = (origWidth << 13) / scaledWidth;
        int ratioH = (origHeight << 13) / scaledHeight;
        for (int destY = 0; destY < scaledHeight; ++destY) {
            int srcY = destY * ratioH >> 13;
            int iInitialIndex = srcY * this.texture.width + origDefaultOffset;
            int commonOffset = destY * this.width + targetDefaultOffset;
            for (int destX = 0; destX < scaledWidth; ++destX) {
                int srcX = destX * ratioW >> 13;
                outputRGB[destX + commonOffset] = textureRgb[srcX + iInitialIndex];
            }
        }
    }

    private int[] getTextureRgb() {
        if (this.texture == null) {
            this.texture = CCTextureCache.sharedTextureCache().addImage(this.filename);
        }
        int tWidth = this.texture.width;
        int tHeight = this.texture.height;
        int[] rgb = new int[tWidth * tHeight];
        this.texture.image.getRGB(rgb, 0, tWidth, 0, 0, tWidth, tHeight);
        return rgb;
    }

    private static final void intfill(int[] array, int value) {
        int len = array.length;
        if (len > 0) {
            array[0] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, 0, array, i, len - i < i ? len - i : i);
        }
    }

    public void onExit() {
        super.onExit();
        while (!this.scaleHistory.isEmpty()) {
            String tName = (String)this.scaleHistory.lastElement();
            CCTextureCache.sharedTextureCache().removeTextureForKey(tName);
            this.scaleHistory.removeElement(tName);
        }
    }

    public void draw(Graphics g) {
        g.setColor(this._alphaRaw);
        cocos2d.setClip(g, 0, -cocos2d.SCREEN_HEIGHT, cocos2d.SCREEN_WIDTH, cocos2d.SCREEN_HEIGHT);
        int scaledWidth = (int)((float)this.width * this.scale.x);
        int scaledHeight = (int)((float)this.height * this.scale.y);
        if (this.lastScaledWidth != scaledWidth || this.lastScaledHeight != scaledHeight) {
            this.scaleByStretching();
            this.lastScaledWidth = scaledWidth;
            this.lastScaledHeight = scaledHeight;
        }
        this.getScreenPosition(this.drawPosition);
        if (this.isRelativeAnchorPoint) {
            this.drawPosition.x = this.drawPosition.x - (this.anchorPoint.x == 0 ? 0 : scaledWidth / (100 / this.anchorPoint.x));
            this.drawPosition.y = this.drawPosition.y - (this.anchorPoint.y == 0 ? 0 : scaledHeight / (100 / this.anchorPoint.y));
        }
        g.drawImage(this.texture.image, this.drawPosition.x, -this.drawPosition.y, 36);
    }
}

