/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.actions;

import cocos2d.actions.CCAction;
import cocos2d.actions.CCRepeatForever;
import cocos2d.nodes.CCNode;

public class CCRepeat
extends CCRepeatForever {
    int remainingTimes = 0;
    int originalTimes = 0;

    public CCRepeat(CCAction action, int count) {
        super(action);
        this.originalTimes = count;
        this.remainingTimes = count;
    }

    public long getDuration() {
        return this.action.getDuration() * (long)this.originalTimes;
    }

    public static final CCRepeat actionWithAction(CCAction action, int times) {
        return new CCRepeat(action, times);
    }

    public void update(CCNode target, long dt) {
        if (this.isFinished) {
            this.isFinished = false;
            this.remainingTimes = this.originalTimes;
        } else if (this.action.isFinished) {
            --this.remainingTimes;
        }
        if (this.remainingTimes > 0) {
            super.update(target, dt);
        } else {
            this.isFinished = true;
        }
    }

    public CCAction copy() {
        return CCRepeat.actionWithAction(this.action.copy(), this.originalTimes);
    }

    public CCAction reverse() {
        return CCRepeat.actionWithAction(this.action.reverse(), this.originalTimes);
    }
}

