/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.actions;

import cocos2d.actions.CCAction;
import cocos2d.nodes.CCNode;
import cocos2d.nodes.CCProgressTimer;

public class CCProgressFromTo
extends CCAction {
    int from;
    int to;

    public static CCProgressFromTo action(int from, int to, long duration) {
        return new CCProgressFromTo(from, to, duration);
    }

    public CCProgressFromTo(int from, int to, long duration) {
        this.from = from;
        this.to = to;
        this.duration = duration;
    }

    public void update(CCNode target, long dt) {
        if (this.isFinished || !this.isStarted) {
            this.isStarted = true;
            this.isFinished = false;
            this.elapsedTime = 0L;
        } else {
            this.elapsedTime += dt;
        }
        if (this.elapsedTime > this.duration) {
            this.elapsedTime = this.duration;
            ((CCProgressTimer)target).setPercentage(this.to);
        } else {
            ((CCProgressTimer)target).setPercentage(this.from + (int)(this.elapsedTime / (this.duration / (long)(this.to - this.from))));
        }
        super.update(target, dt);
    }

    public CCAction copy() {
        return CCProgressFromTo.action(this.from, this.to, this.duration);
    }

    public CCAction reverse() {
        return CCProgressFromTo.action(this.to, this.from, this.duration);
    }
}

