/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.actions;

import cocos2d.actions.CCAction;
import cocos2d.nodes.CCNode;
import cocos2d.types.CCPoint;
import cocos2d.types.Real;

public class CCMoveTo
extends CCAction {
    CCPoint targetPosition = null;
    public CCPoint startPosition = CCPoint.zero();
    final Real step = new Real();
    final Real posCalc = new Real();

    public static final CCMoveTo action(CCPoint position, long duration) {
        return new CCMoveTo(position, duration);
    }

    public CCMoveTo(CCPoint position, long duration) {
        this.targetPosition = position;
        this.setDuration(duration);
    }

    public void setDuration(long duration) {
        this.duration = duration;
        this.step.assign(duration);
        this.step.mul(Real.PERCENT);
        this.step.recip();
    }

    public void update(CCNode target, long dt) {
        if (this.isFinished || !this.isStarted) {
            this.isStarted = true;
            this.isFinished = false;
            this.startPosition.set(target.position);
            this.elapsedTime = 0L;
        } else {
            this.elapsedTime += dt;
        }
        if (this.elapsedTime < this.duration) {
            this.posCalc.assign(this.elapsedTime);
            this.posCalc.mul(this.step);
            this.posCalc.mul(this.targetPosition.x - this.startPosition.x);
            this.posCalc.mul(Real.PERCENT);
            target.position.x = this.startPosition.x + this.posCalc.toInteger();
            this.posCalc.assign(this.elapsedTime);
            this.posCalc.mul(this.step);
            this.posCalc.mul(this.targetPosition.y - this.startPosition.y);
            this.posCalc.mul(Real.PERCENT);
            target.position.y = this.startPosition.y + this.posCalc.toInteger();
        } else {
            target.setPosition(this.targetPosition);
        }
        super.update(target, dt);
    }

    public CCAction copy() {
        return new CCMoveTo(this.targetPosition.copy(), this.duration);
    }

    public CCAction reverse() {
        return new CCMoveTo(this.startPosition.copy(), this.duration);
    }
}

