/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.actions;

import cocos2d.actions.CCAction;
import cocos2d.nodes.CCNode;
import cocos2d.types.CCPoint;
import cocos2d.types.Real;

public class CCMoveBy
extends CCAction {
    CCPoint targetPosition = null;
    CCPoint offset = null;
    CCPoint startPosition = CCPoint.zero();
    final Real step = new Real();
    final Real posCalc = new Real();

    public static final CCMoveBy action(CCPoint position, long duration) {
        return new CCMoveBy(position, duration);
    }

    public CCMoveBy(CCPoint position, long duration) {
        this.duration = duration;
        this.offset = position;
        this.step.assign(duration);
        this.step.mul(Real.PERCENT);
        this.step.recip();
    }

    public void update(CCNode target, long dt) {
        if (this.isFinished || !this.isStarted) {
            this.isStarted = true;
            this.isFinished = false;
            this.startPosition.set(target.position);
            this.targetPosition = CCPoint.ccpAdd(this.startPosition, this.offset);
            this.elapsedTime = 0L;
        } else {
            this.elapsedTime += dt;
        }
        if (this.elapsedTime < this.duration) {
            this.posCalc.assign(this.elapsedTime);
            this.posCalc.mul(this.step);
            this.posCalc.mul(this.targetPosition.x - this.startPosition.x);
            this.posCalc.mul(Real.PERCENT);
            target.position.x = this.startPosition.x + this.posCalc.toInteger();
            this.posCalc.assign(this.elapsedTime);
            this.posCalc.mul(this.step);
            this.posCalc.mul(this.targetPosition.y - this.startPosition.y);
            this.posCalc.mul(Real.PERCENT);
            target.position.y = this.startPosition.y + this.posCalc.toInteger();
        } else {
            this.isFinished = true;
            target.setPosition(this.targetPosition);
        }
        super.update(target, dt);
    }

    public CCAction copy() {
        return new CCMoveBy(this.offset.copy(), this.duration);
    }

    public CCAction reverse() {
        return new CCMoveBy(CCPoint.ccp(-this.offset.x, -this.offset.y), this.duration);
    }
}

