/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.actions;

import cocos2d.actions.CCAction;
import cocos2d.actions.CCFadeIn;
import cocos2d.cocos2d;
import cocos2d.nodes.CCNode;
import cocos2d.types.Real;

public class CCFadeOut
extends CCAction {
    private int startAlpha = 0;
    private int targetAlpha = 0;
    final Real step = new Real();
    final Real posCalc = new Real();

    public static final CCFadeOut action(long duration) {
        return new CCFadeOut(duration);
    }

    public CCFadeOut(long duration) {
        if (!cocos2d.isAndroid) {
            duration = 0L;
        }
        this.setDuration(duration);
    }

    public void setDuration(long duration) {
        this.duration = duration;
        this.step.assign(duration);
        this.step.mul(Real.PERCENT);
        this.step.recip();
    }

    public void update(CCNode target, long dt) {
        if (this.isFinished || !this.isStarted) {
            this.isStarted = true;
            this.isFinished = false;
            this.startAlpha = target.getAlpha();
            this.elapsedTime = 0L;
        } else {
            this.elapsedTime += dt;
        }
        if (this.elapsedTime < this.duration) {
            this.posCalc.assign(this.elapsedTime);
            this.posCalc.mul(this.step);
            this.posCalc.mul(this.targetAlpha - this.startAlpha);
            this.posCalc.mul(Real.PERCENT);
            target.setAlpha(this.startAlpha + this.posCalc.toInteger());
        } else {
            target.setAlpha(this.targetAlpha);
        }
        super.update(target, dt);
    }

    public CCAction copy() {
        return CCFadeOut.action(this.duration);
    }

    public CCAction reverse() {
        return CCFadeIn.action(this.duration);
    }
}

