/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.actions;

import cocos2d.actions.CCAction;
import cocos2d.actions.CCEaseIn;
import cocos2d.nodes.CCNode;
import cocos2d.types.Real;

public class CCEaseOut
extends CCAction {
    CCAction action;
    long totalTime = 0L;
    public final Real rate = new Real(Real.ONE);
    static final Real tmpReal = new Real();

    public static final CCEaseOut action(CCAction action, Real rate) {
        return new CCEaseOut(action, rate);
    }

    public CCEaseOut(CCAction action, Real speed) {
        this.action = action;
        this.duration = action.duration;
        this.setRate(speed);
    }

    public void setRate(Real speed) {
        this.rate.assign(speed);
        this.rate.recip();
    }

    public void pause() {
        if (!this.isPaused) {
            this.isPaused = true;
            this.action.pause();
        }
    }

    public void resume() {
        if (this.isPaused) {
            this.isPaused = false;
            this.action.resume();
        }
    }

    public void update(CCNode target, long dt) {
        this.totalTime = this.isFinished ? 0L : (this.totalTime += dt);
        int remainingTime = (int)(this.action.duration - this.totalTime);
        tmpReal.assign(remainingTime);
        tmpReal.div((int)this.action.duration);
        tmpReal.sub(Real.ONE);
        tmpReal.neg();
        tmpReal.pow(this.rate);
        tmpReal.mul((int)this.action.duration);
        this.action.elapsedTime = tmpReal.toInteger();
        this.action.update(target, 0L);
        this.isFinished = this.action.isFinished;
    }

    public CCAction copy() {
        CCEaseOut tAction = CCEaseOut.action(this.action.copy(), this.rate);
        tAction.rate.assign(this.rate);
        return tAction;
    }

    public CCAction reverse() {
        CCEaseIn tAction = CCEaseIn.action(this.action.reverse(), this.rate);
        tAction.rate.recip();
        return tAction;
    }
}

