/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.actions;

import cocos2d.actions.CCAction;
import cocos2d.nodes.CCNode;
import cocos2d.types.CCBezierConfig;
import cocos2d.types.CCPoint;
import cocos2d.types.Real;

public class CCBezierBy
extends CCAction {
    protected CCBezierConfig config;
    CCPoint startPosition = CCPoint.zero();
    final Real step = new Real();
    final Real posCalc = new Real();

    public static final CCBezierBy action(CCBezierConfig config, long duration) {
        return new CCBezierBy(config, duration);
    }

    public CCBezierBy(CCBezierConfig config, long duration) {
        this.config = config;
        this.duration = duration;
        this.step.assign(duration);
        this.step.mul(Real.PERCENT);
        this.step.recip();
        this.step.mul(Real.PERCENT);
    }

    public void update(CCNode target, long dt) {
        if (this.isFinished || !this.isStarted) {
            this.isStarted = true;
            this.isFinished = false;
            this.startPosition.set(target.position);
            this.config.controlPoint_1.x -= this.startPosition.x;
            this.config.controlPoint_1.y -= this.startPosition.y;
            this.config.controlPoint_2.x -= this.startPosition.x;
            this.config.controlPoint_2.y -= this.startPosition.y;
            this.config.endPosition.x -= this.startPosition.x;
            this.config.endPosition.y -= this.startPosition.y;
            this.elapsedTime = 0L;
        } else {
            this.elapsedTime += dt;
        }
        if (this.elapsedTime < this.duration) {
            this.posCalc.assign(this.elapsedTime);
            this.posCalc.mul(this.step);
            int xa = 0;
            int xb = this.config.controlPoint_1.x;
            int xc = this.config.controlPoint_2.x;
            int xd = this.config.endPosition.x;
            int ya = 0;
            int yb = this.config.controlPoint_1.y;
            int yc = this.config.controlPoint_2.y;
            int yd = this.config.endPosition.y;
            int x = CCBezierConfig.bezierAt(xa, xb, xc, xd, this.posCalc);
            int y = CCBezierConfig.bezierAt(ya, yb, yc, yd, this.posCalc);
            target.setPosition(this.startPosition.x + x, this.startPosition.y + y);
        } else {
            this.isFinished = true;
            this.config.controlPoint_1.x += this.startPosition.x;
            this.config.controlPoint_1.y += this.startPosition.y;
            this.config.controlPoint_2.x += this.startPosition.x;
            this.config.controlPoint_2.y += this.startPosition.y;
            this.config.endPosition.x += this.startPosition.x;
            this.config.endPosition.y += this.startPosition.y;
            target.setPosition(this.config.endPosition);
        }
        super.update(target, dt);
    }

    public CCAction copy() {
        return new CCBezierBy(this.config.copy(), this.duration);
    }

    public CCAction reverse() {
        return this.copy();
    }
}

