/*
 * Decompiled with CFR 0.152.
 */
package cocos2d.actions;

import cocos2d.CCSpriteFrameCache;
import cocos2d.actions.CCAction;
import cocos2d.nodes.CCNode;
import cocos2d.nodes.CCSprite;
import cocos2d.types.CCAnimation;
import cocos2d.types.CCSpriteFrame;

public class CCAnimate
extends CCAction {
    int currentFrame = 0;
    int lastFrame = -1;
    boolean restoreOriginalFrame = true;
    CCAnimation animation = null;
    CCSpriteFrame originalFrame = null;
    long lastUpdateTime = -1L;

    public static final CCAnimate actionWithAnimation(CCAnimation animation, boolean restoreOriginalFrame) {
        return new CCAnimate(animation, restoreOriginalFrame);
    }

    public CCAnimate(CCAnimation animation, boolean restoreOriginalFrame) {
        this.animation = animation;
        this.restoreOriginalFrame = restoreOriginalFrame;
        this.duration = this.animation.delay * this.animation.frames.length;
    }

    public void update(CCNode target, long dt) {
        CCSprite targetSprite = (CCSprite)target;
        if (this.isFinished || !this.isStarted) {
            this.isStarted = true;
            this.isFinished = false;
            this.elapsedTime = 0L;
            this.currentFrame = 0;
            this.lastFrame = -1;
            if (this.restoreOriginalFrame && this.originalFrame == null) {
                this.originalFrame = targetSprite.spriteFrame;
            }
        } else {
            this.elapsedTime += dt;
        }
        if (this.elapsedTime >= (long)this.animation.delay) {
            this.elapsedTime = 0L;
            if (this.restoreOriginalFrame && this.currentFrame >= this.animation.frames.length) {
                if (this.originalFrame != null) {
                    targetSprite.spriteFrame = this.originalFrame;
                }
                this.isFinished = true;
            } else {
                if (this.currentFrame != this.lastFrame) {
                    targetSprite.spriteFrame = CCSpriteFrameCache.sharedFrameCache().spriteFrameByName(this.animation.frames[this.currentFrame]);
                    this.lastFrame = this.currentFrame;
                }
                ++this.currentFrame;
                if (!this.restoreOriginalFrame && this.currentFrame >= this.animation.frames.length) {
                    this.isFinished = true;
                }
            }
        }
    }

    public CCAction copy() {
        return CCAnimate.actionWithAnimation(this.animation, this.restoreOriginalFrame);
    }

    public CCAction reverse() {
        String[] reversedFrames = new String[this.animation.frames.length];
        int i = this.animation.frames.length;
        int j = 0;
        while (i-- != 0) {
            reversedFrames[i] = this.animation.frames[j++];
        }
        CCAnimation reversedAnimation = CCAnimation.animationWithFramesAndDelay(reversedFrames, this.animation.delay);
        return CCAnimate.actionWithAnimation(reversedAnimation, this.restoreOriginalFrame);
    }
}

