/*
 * Decompiled with CFR 0.152.
 */
package cocos2d;

import cocos2d.cocos2d;
import cocos2d.types.CCTexture2D;
import java.util.Hashtable;

public final class CCTextureCache {
    private static final Hashtable cache = new Hashtable(5);
    private static CCTextureCache _sharedTextureCache = null;

    public static final CCTextureCache sharedTextureCache() {
        if (_sharedTextureCache == null) {
            _sharedTextureCache = new CCTextureCache();
        }
        return _sharedTextureCache;
    }

    public String printState() {
        return "cache size:" + cache.size() + "\ncontents:" + cache.toString();
    }

    private CCTextureCache() {
    }

    public CCTexture2D addImage(String filename) {
        CCTexture2D retObj = this.textureForKey(filename);
        if (retObj == null) {
            retObj = CCTexture2D.textureWithFile(filename);
            if (retObj.image != null) {
                cache.put(filename, retObj);
            }
        }
        return retObj;
    }

    public CCTexture2D addToCache(CCTexture2D image) {
        cache.put(image.name, image);
        return image;
    }

    public CCTexture2D textureForKey(String filename) {
        return (CCTexture2D)cache.get(filename);
    }

    public void removeTexture(CCTexture2D texture) {
        if (cache.remove(texture.name) != null) {
            cocos2d.CCLog("CCTextureCache: removed " + texture.name + " from texture cache");
        }
    }

    public void removeTextureForKey(String key) {
        if (cache.remove(key) != null) {
            cocos2d.CCLog("CCTextureCache: removed " + key + " from texture cache");
        }
    }

    public void purgeSharedTextureCache() {
        cache.clear();
    }
}

