/*
 * Decompiled with CFR 0.152.
 */
package cocos2d;

import cocos2d.CCKeyboardManager;
import cocos2d.CCSpriteFrameCache;
import cocos2d.CCTextureCache;
import cocos2d.CCTouchDispatcher;
import cocos2d.SimpleAudioEngine;
import cocos2d.cocos2d;
import cocos2d.nodes.CCLabelBMFont;
import cocos2d.nodes.CCScene;
import cocos2d.types.BMFont;
import cocos2d.types.CCFunction;
import cocos2d.types.CCPoint;
import java.util.Stack;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class CCDirector {
    private static boolean resolutionLocked = false;
    static boolean isDoubleBuffered = true;
    private static int lockedWidth = 0;
    private static int lockedHeight = 0;
    static final int STATE_INITIALIZING = -1;
    static final int STATE_RUNNING = 0;
    static final int STATE_PAUSED = 1;
    static final int STATE_QUITTING = 2;
    private static int UID;
    private static final Vector scheduledFunctions;
    public static int CURRENT_LOG_OFFSET;
    static final int MAX_LOG_HISTORY_LENGTH = 6;
    private static final StringBuffer cclogBuffer;
    public static final Vector logHistory;
    int engineState = -1;
    public CCScene runningScene = null;
    public final String platformName = CCDirector.getPlatformName();
    private Graphics drawingTarget = null;
    public static long deltaTimer;
    private int fpsCounter = 0;
    private int lastFps = 0;
    private long fpsTimer = System.currentTimeMillis();
    Image backBuffer = null;
    private Graphics backBufferTarget = null;
    private final CCPoint backBufferSize = CCPoint.ccp(1, 1);
    private static final CCDirector director;
    private static final Stack sceneStack;
    private final CCLabelBMFont debugLabel;

    public static final CCDirector sharedDirector() {
        return director;
    }

    private CCDirector() {
        this.runningScene = new CCScene();
        this.runningScene.isActive = false;
        this.debugLabel = CCLabelBMFont.labelWithString("", "debugFont.fnt");
        this.debugLabel.setLineSpacing(0);
        this.debugLabel.setPosition(0, 0);
        this.debugLabel.setAnchorPoint(0, 0);
    }

    public void forceResolution(int width, int height) {
        resolutionLocked = true;
        lockedWidth = cocos2d.SCREEN_WIDTH = width;
        lockedHeight = cocos2d.SCREEN_HEIGHT = height;
    }

    private void forceOrientation(boolean enable) {
        isDoubleBuffered = enable ? false : (cocos2d.canvas != null ? cocos2d.isDeviceDoubleBuffered : true);
    }

    public int schedule(CCFunction func, int time, boolean repeat) {
        scheduledAction tmpAction = new scheduledAction(func, UID++);
        tmpAction.nextExecutionTime = deltaTimer + (long)time;
        tmpAction.resetTime = time;
        tmpAction.repeat = repeat;
        scheduledFunctions.addElement(tmpAction);
        return tmpAction.uid;
    }

    public void cancelSchedule(int scheduleUid) {
        int i = scheduledFunctions.size();
        while (i-- != 0) {
            scheduledAction tmpAction = (scheduledAction)scheduledFunctions.elementAt(i);
            if (tmpAction.uid != scheduleUid) continue;
            scheduledFunctions.removeElementAt(i);
            break;
        }
    }

    final void setupCoordinateSystem(Graphics drawingTarget, int width, int height) {
        boolean orientationWasChanged = false;
        this.drawingTarget = drawingTarget;
        cocos2d.REAL_SCREEN_HEIGHT = height;
        if (resolutionLocked) {
            width = lockedWidth;
            height = lockedHeight;
        } else {
            lockedWidth = width;
            lockedHeight = height;
        }
        cocos2d.SCREEN_WIDTH = width;
        cocos2d.SCREEN_HEIGHT = height;
        if (cocos2d.SCREEN_WIDTH > cocos2d.SCREEN_HEIGHT) {
            if (cocos2d.orientation != 1) {
                orientationWasChanged = true;
                cocos2d.orientation = 1;
            }
            this.forceOrientation((cocos2d.settings & 0x80L) != 0L);
        } else {
            if (cocos2d.orientation != 0) {
                orientationWasChanged = true;
                cocos2d.orientation = 0;
            }
            this.forceOrientation((cocos2d.settings & 0x100L) != 0L);
        }
        if (!isDoubleBuffered) {
            boolean needToRotate;
            boolean bl = needToRotate = (cocos2d.settings & 0x80L) != 0L && cocos2d.orientation == 1 || (cocos2d.settings & 0x100L) != 0L && cocos2d.orientation == 0;
            if (needToRotate) {
                int rH = cocos2d.SCREEN_HEIGHT;
                cocos2d.SCREEN_HEIGHT = cocos2d.SCREEN_WIDTH;
                cocos2d.SCREEN_WIDTH = rH;
            }
            if (this.backBufferSize.x != cocos2d.SCREEN_WIDTH || this.backBufferSize.y != cocos2d.SCREEN_HEIGHT) {
                this.backBuffer = Image.createImage((int)cocos2d.SCREEN_WIDTH, (int)cocos2d.SCREEN_HEIGHT);
                this.backBufferSize.x = cocos2d.SCREEN_WIDTH;
                this.backBufferSize.y = cocos2d.SCREEN_HEIGHT;
                this.backBufferTarget = this.backBuffer.getGraphics();
                System.gc();
            }
            this.backBufferTarget.translate(0, cocos2d.SCREEN_HEIGHT - this.backBufferTarget.getTranslateY());
            if (orientationWasChanged) {
                CCDirector.director.runningScene.orientationChanged(cocos2d.orientation);
            }
        } else if (orientationWasChanged) {
            CCDirector.director.runningScene.orientationChanged(cocos2d.orientation);
        }
        if (drawingTarget != null) {
            drawingTarget.translate(0, height - drawingTarget.getTranslateY());
        }
    }

    public final void pause() {
        this.engineState = 1;
    }

    public final void resume() {
        this.engineState = 0;
    }

    public final void runWithScene(CCScene scene) {
        if (this.engineState == -1) {
            this.engineState = 0;
            CCTouchDispatcher.sharedDispatcher().flushBuffer();
            CCKeyboardManager.sharedManager().flushBuffer();
            this.runningScene = scene;
            this.runningScene.onEnter();
            cocos2d.thread = new Thread(cocos2d.canvas);
            cocos2d.thread.start();
        } else {
            cocos2d.CCLog("CCDirector: runWithScene should be called only once.");
        }
    }

    public final void pushScene(CCScene scene) {
        if ((cocos2d.settings & 2L) != 0L) {
            cocos2d.CCLog("CCDirector: Low memory scene change is not compatible with pushScene");
        } else {
            CCTouchDispatcher.sharedDispatcher().flushBuffer();
            CCKeyboardManager.sharedManager().flushBuffer();
            this.runningScene.onExit();
            sceneStack.push(this.runningScene);
            this.runningScene = scene;
            this.runningScene.onEnter();
            deltaTimer = System.currentTimeMillis();
        }
    }

    public final void popScene() {
        if ((cocos2d.settings & 2L) != 0L) {
            cocos2d.CCLog("CCDirector: Low memory scene change is not compatible with popScene");
        } else if (!sceneStack.isEmpty()) {
            this.runningScene.onExit();
            this.runningScene = (CCScene)sceneStack.pop();
            this.runningScene.onEnter();
            deltaTimer = System.currentTimeMillis();
        } else {
            cocos2d.CCLog("CCDirector: popScene underrun");
        }
    }

    public final void replaceScene(CCScene scene) {
        if (scene != this.runningScene) {
            CCTouchDispatcher.sharedDispatcher().flushBuffer();
            CCKeyboardManager.sharedManager().flushBuffer();
            if (this.runningScene != null) {
                this.runningScene.onExit();
                this.runningScene.removeAllChildren(true);
                this.runningScene.stopAllActions();
                this.runningScene = null;
                System.gc();
            }
            this.runningScene = scene;
            this.runningScene.onEnter();
            deltaTimer = System.currentTimeMillis();
            System.gc();
        }
    }

    public final void clearRunningScene() {
        if (this.runningScene != null) {
            this.runningScene.onExit();
            this.runningScene.removeAllChildren(true);
            this.runningScene = null;
            System.gc();
        }
        this.runningScene = new CCScene();
        while (!sceneStack.isEmpty()) {
            CCScene scene = (CCScene)sceneStack.pop();
            scene.onExit();
            scene.removeAllChildren(true);
        }
        CCTextureCache.sharedTextureCache().purgeSharedTextureCache();
        CCSpriteFrameCache.sharedFrameCache().purgeSpriteFrameCache();
        SimpleAudioEngine.sharedEngine().purge();
        CCKeyboardManager.sharedManager().removeAllDelegates();
        CCTouchDispatcher.sharedDispatcher().removeAllDelegates();
        CCTouchDispatcher.sharedDispatcher().flushBuffer();
        CCKeyboardManager.sharedManager().flushBuffer();
        BMFont.purgeFontCache();
        System.gc();
    }

    final long update() {
        boolean needToRotate = (cocos2d.settings & 0x80L) != 0L && cocos2d.orientation == 1 || (cocos2d.settings & 0x100L) != 0L && cocos2d.orientation == 0;
        Graphics buffer = isDoubleBuffered ? this.drawingTarget : this.backBufferTarget;
        long newTime = System.currentTimeMillis();
        long dt = newTime - deltaTimer + 1L;
        deltaTimer = newTime;
        int i = scheduledFunctions.size();
        while (i-- != 0) {
            scheduledAction tmpAction = (scheduledAction)scheduledFunctions.elementAt(i);
            if (deltaTimer < tmpAction.nextExecutionTime) continue;
            tmpAction.callback.function();
            if (tmpAction.repeat) {
                tmpAction.nextExecutionTime = deltaTimer + (long)tmpAction.resetTime;
                continue;
            }
            scheduledFunctions.removeElementAt(i);
        }
        if (this.runningScene != null && this.runningScene.isActive) {
            block11: {
                if ((cocos2d.settings & 8L) != 0L) {
                    buffer.setColor(-1);
                    buffer.setClip(0, -cocos2d.SCREEN_HEIGHT, cocos2d.SCREEN_WIDTH, cocos2d.SCREEN_HEIGHT);
                    buffer.fillRect(0, -cocos2d.SCREEN_HEIGHT, cocos2d.SCREEN_WIDTH, cocos2d.SCREEN_HEIGHT);
                }
                CCKeyboardManager.sharedManager().processKeyBuffer(needToRotate);
                CCTouchDispatcher.sharedDispatcher().processTouchBuffer(needToRotate);
                try {
                    this.runningScene.update(dt);
                    this.runningScene.visit(buffer, dt, true, false);
                    buffer.setClip(0, -cocos2d.SCREEN_HEIGHT, cocos2d.SCREEN_WIDTH, cocos2d.SCREEN_HEIGHT);
                    this.runningScene.draw(buffer);
                }
                catch (Exception e) {
                    System.gc();
                    cocos2d.CCLog("CCDirector: update(): " + e.toString());
                    if (!cocos2d.DEBUG) break block11;
                    e.printStackTrace();
                }
            }
            if (cocos2d.DEBUG) {
                this.debugLabel.setMaxLineWidth(cocos2d.SCREEN_WIDTH);
                this.debugLabel.setString(this.getLogHistoryString());
                this.debugLabel.draw(buffer);
            }
        } else {
            buffer.setColor(-16777216);
            buffer.setClip(0, -cocos2d.SCREEN_HEIGHT, cocos2d.SCREEN_WIDTH, cocos2d.SCREEN_HEIGHT);
            buffer.fillRect(0, -cocos2d.SCREEN_HEIGHT, cocos2d.SCREEN_WIDTH, cocos2d.SCREEN_HEIGHT);
            this.debugLabel.setMaxLineWidth(cocos2d.SCREEN_WIDTH);
            this.debugLabel.setString(this.getLogHistoryString());
            this.debugLabel.draw(buffer);
        }
        if (!isDoubleBuffered) {
            if (needToRotate) {
                int forcedTranslateY = cocos2d.REAL_SCREEN_HEIGHT - lockedHeight;
                this.drawingTarget.translate(0, -this.drawingTarget.getTranslateY());
                this.drawingTarget.setClip(0, forcedTranslateY, cocos2d.SCREEN_HEIGHT, cocos2d.SCREEN_WIDTH);
                this.drawingTarget.drawRegion(this.backBuffer, 0, 0, cocos2d.SCREEN_WIDTH, cocos2d.SCREEN_HEIGHT, 6, 0, forcedTranslateY, 20);
            } else {
                this.drawingTarget.drawImage(this.backBuffer, 0, 0, 36);
            }
        }
        return dt;
    }

    private String getLogHistoryString() {
        cclogBuffer.setLength(0);
        if (CURRENT_LOG_OFFSET < 0) {
            CURRENT_LOG_OFFSET = 0;
        } else if (CURRENT_LOG_OFFSET >= 6) {
            CURRENT_LOG_OFFSET = 5;
        }
        int i = logHistory.size();
        while (i-- > CURRENT_LOG_OFFSET) {
            cclogBuffer.append("> ").append(logHistory.elementAt(i)).append("\n");
        }
        if (cocos2d.DRAW_FPS) {
            ++this.fpsCounter;
            if (deltaTimer - this.fpsTimer >= 1000L) {
                this.fpsTimer = deltaTimer;
                this.lastFps = this.fpsCounter;
                this.fpsCounter = 0;
            }
            cclogBuffer.append("FPS: ").append(this.lastFps);
        }
        return cclogBuffer.toString();
    }

    private static final String getPlatformName() {
        String platformName = System.getProperty("microedition.platform");
        String sonyJava = System.getProperty("com.sonyericsson.java.platform");
        if (sonyJava != null) {
            platformName = platformName + "/" + sonyJava;
        }
        String device = System.getProperty("device.model");
        String firmware = System.getProperty("device.software.version");
        try {
            Class.forName("com.samsung.util.AudioClip");
            platformName = "Samsung-generic";
        }
        catch (ClassNotFoundException t0) {
            try {
                Class.forName("com.samsung.util.Vibration");
                platformName = "Samsung-generic";
            }
            catch (ClassNotFoundException t1) {
                // empty catch block
            }
        }
        try {
            Class.forName("com.mot.iden.customercare.CustomerCare");
            platformName = "iden";
        }
        catch (ClassNotFoundException t0) {
            try {
                Class.forName("com.mot.iden.util.Base64");
                platformName = "iden";
            }
            catch (ClassNotFoundException t1) {
                // empty catch block
            }
        }
        if (platformName == null) {
            platformName = "Motorola";
        }
        if (platformName.startsWith("j2me")) {
            if (device != null && device.startsWith("wtk-emulator")) {
                platformName = device;
                return platformName;
            }
            if (device != null && firmware != null) {
                platformName = "Motorola";
            } else {
                String hostname = System.getProperty("microedition.hostname");
                if (hostname != null) {
                    platformName = "Motorola-EZX";
                    if (device != null) {
                        hostname = device;
                    }
                    if (hostname.indexOf("(none)") < 0) {
                        platformName = platformName + "/" + hostname;
                    }
                    return platformName;
                }
            }
        }
        if (platformName.startsWith("Moto")) {
            String devicesoftware;
            if (device == null) {
                device = System.getProperty("funlights.product");
            }
            if (device != null) {
                platformName = "Motorola-" + device;
            }
            if ((devicesoftware = System.getProperty("device.software.version")) != null) {
                platformName = platformName + "//" + devicesoftware;
            }
        }
        try {
            Class.forName("mmpp.media.MediaPlayer");
            platformName = "LG";
        }
        catch (ClassNotFoundException ex) {
            try {
                Class.forName("mmpp.phone.Phone");
                platformName = "LG";
            }
            catch (ClassNotFoundException ex1) {
                try {
                    Class.forName("mmpp.lang.MathFP");
                    platformName = "LG";
                }
                catch (ClassNotFoundException ex2) {
                    try {
                        Class.forName("mmpp.media.BackLight");
                        platformName = "LG";
                    }
                    catch (ClassNotFoundException ex3) {
                        // empty catch block
                    }
                }
            }
        }
        if (platformName.indexOf("BlackBerry") != -1 || platformName.indexOf("RIM Wireless") != -1) {
            platformName = "BlackBerry";
        }
        return platformName;
    }

    static {
        scheduledFunctions = new Vector(2);
        CURRENT_LOG_OFFSET = 0;
        cclogBuffer = new StringBuffer();
        logHistory = new Vector(6, 6);
        deltaTimer = 0L;
        director = new CCDirector();
        sceneStack = new Stack();
    }

    private final class scheduledAction {
        final CCFunction callback;
        long nextExecutionTime;
        final int uid;
        int resetTime;
        boolean repeat;

        public scheduledAction(CCFunction pCallback, int pUid) {
            this.callback = pCallback;
            this.uid = pUid;
        }
    }
}

