/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.system;

import baltorogames.core.ApplicationData;
import baltorogames.core.LanguagePack;
import baltorogames.core_gui.UIScreen;
import baltorogames.project_gameplay.CGAchievements;
import baltorogames.project_gameplay.CGSoundSystem;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.EventScreen;
import baltorogames.project_gui.InGameMainMenu;
import baltorogames.project_gui.MainListAnimated;
import baltorogames.project_gui.MainMenu;
import baltorogames.project_gui.ResetAppDataTB;
import baltorogames.system.BGStore;
import baltorogames.system.ObjectsCache;
import baltorogames.system.SoundEngine;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Options
extends MainListAnimated {
    public static int OPTION_LANGID = -1;
    public static int OPTION_MUSIC = 0;
    public static int OPTION_RESETAPP = 1;
    public static boolean GfxOnOff = false;
    public static boolean Vibration = false;
    public static int languageID = 0;
    public static String netResultsURL = new String();
    private static String[] languageNames = new String[]{"TID_LANGUAGE_ENGLISH", "TID_LANGUAGE_GERMAN", "TID_LANGUAGE_SPANISH", "TID_LANGUAGE_ITALIAN", "TID_LANGUAGE_FRENCH", "TID_LANGUAGE_PORTUGUESE", "TID_LANGUAGE_BRASIL"};

    public Options() {
        this.drawTop = true;
        this.drawTitle = false;
        this.setCaption(ApplicationData.lp.getTranslatedString(languageID, "TID_MAIN_MENU_OPTIONS"));
        this.refreshList();
        this.setInitPos();
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
    }

    public static void reset() {
        int currlanguage = languageID;
        Options.readDefaults();
        if (currlanguage != languageID) {
            ApplicationData.lp = LanguagePack.create("/gameTexts.EEE", languageID);
        }
        CGAchievements.Reset();
        CGUserCareer.Reset();
        CGUserCareer.ResetAll();
        EventScreen.medalEvents[0] = 0;
        EventScreen.medalEvents[1] = 0;
        EventScreen.medalEvents[2] = 0;
        EventScreen.medalEvents[3] = 0;
    }

    public static void readDefaults() {
    }

    public static boolean readConfigurationFromStore() {
        BGStore store = BGStore.openStoreToRead("Configuration");
        try {
            DataInputStream inputStream = store.getInStream();
            if (inputStream != null && inputStream.available() > 0) {
                boolean bS = inputStream.readBoolean();
                Vibration = inputStream.readBoolean();
                SoundEngine.soundVolume = inputStream.readInt();
                netResultsURL = inputStream.readUTF();
                ApplicationData.demoTimeLeft = inputStream.readInt();
                ApplicationData.demoLevelsLeft = inputStream.readInt();
            }
            store.close();
        }
        catch (Exception e) {
            Options.readDefaults();
            return false;
        }
        return true;
    }

    public static void writeConfigurationToStore() {
        BGStore store = BGStore.openStoreToWrite("Configuration");
        try {
            DataOutputStream outputStream = store.getOutStream();
            outputStream.writeBoolean(GfxOnOff);
            outputStream.writeBoolean(Vibration);
            outputStream.writeInt(SoundEngine.soundVolume);
            outputStream.writeUTF(netResultsURL);
            outputStream.writeInt(ApplicationData.demoTimeLeft);
            outputStream.writeInt(ApplicationData.demoLevelsLeft);
            store.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void refreshList() {
        this.clearList();
        if (languageID != LanguagePack.currentLanguageID) {
            ApplicationData.lp = LanguagePack.create("/gameTexts.EEE", languageID);
            this.setCaption(ApplicationData.lp.getTranslatedString(languageID, "TID_SETTINGS"));
            this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, ObjectsCache.menuSbBACK, ObjectsCache.menuSbBACK_a);
        }
        if (ApplicationData.soundEngine.isSoundEnabled()) {
            this.append(ApplicationData.lp.getTranslatedString(languageID, "OPTIONS_SOUND_ON"), 0);
        } else {
            this.append(ApplicationData.lp.getTranslatedString(languageID, "OPTIONS_SOUND_OFF"), 0);
        }
        if (ApplicationData.generalGameMode != 4) {
            this.append(ApplicationData.lp.getTranslatedString(languageID, "OPTIONS_RESETAPP_DATA"), 6);
        }
    }

    public void currentItemSelected(int currentItemId) {
        if (currentItemId == OPTION_MUSIC) {
            if (GfxOnOff) {
                ApplicationData.soundEngine.stopMID();
            }
            boolean bl = GfxOnOff = !GfxOnOff;
            if (GfxOnOff) {
                ApplicationData.soundEngine.enableSound();
            } else {
                ApplicationData.soundEngine.disableSound();
            }
            if (GfxOnOff && ApplicationData.isMainMenuMode()) {
                if (ApplicationData.isMainMenuMode()) {
                    CGSoundSystem.PlayMusic("/mainmenu.mid");
                } else {
                    CGSoundSystem.PlayMusic("/skijump.mid");
                }
            }
        } else {
            if (currentItemId == OPTION_RESETAPP) {
                UIScreen.SetCurrentScreen(new ResetAppDataTB());
                return;
            }
            if (currentItemId == OPTION_LANGID) {
                // empty if block
            }
        }
        this.refreshList();
    }

    public boolean rightSoftButton() {
        if (ApplicationData.generalGameMode != 3) {
            UIScreen.SetCurrentScreen(new InGameMainMenu());
        } else {
            UIScreen.SetCurrentScreen(new MainMenu());
        }
        return true;
    }

    public boolean leftSoftButton() {
        this.currentItemSelected(this.currentItem);
        return true;
    }

    public boolean actionSoftButton(int nID, boolean pressed) {
        if (pressed) {
            return super.actionSoftButton(nID, pressed);
        }
        this.currentItemSelected(nID - 1000);
        return true;
    }
}

