/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gui;

import baltorogames.core.ApplicationData;
import baltorogames.core.SortVector;
import baltorogames.core_gui.UIListColumn;
import baltorogames.core_gui.UIScreen;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGUserCareer;
import baltorogames.project_gui.CareerScreen;
import baltorogames.project_gui.EditChampionshipsUserName;
import baltorogames.project_gui.EndOfCareerScreen;
import baltorogames.project_gui.EventScreen;
import baltorogames.project_gui.MainList;
import baltorogames.system.ObjectsCache;
import baltorogames.system.Options;
import java.util.Vector;

public class GeneralListScreen
extends MainList {
    private Vector resultsColumnNicks = new Vector();
    private Vector resultsColumnTotal = new Vector();
    public static SortVector players = null;

    public GeneralListScreen() {
        super(0, false, 0);
        this.columns = new Vector();
        this.columns.addElement(new UIListColumn(12, 8));
        this.columns.addElement(new UIListColumn(43, 4));
        this.columns.addElement(new UIListColumn(45, 1));
        this.headers.addElement(ApplicationData.defaultFont.encodeDynamicString(""));
        this.headers.addElement(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_RESULTS_NICK"));
        this.headers.addElement(ApplicationData.lp.getTranslatedString(Options.languageID, "ID_RESULTS_CREDITS"));
        this.showHeaders = true;
        this.showScrollbars = CGEngine.selectedGameMode == 2 || CGEngine.selectedGameMode == 1;
        this.setSoftButtonImage(ObjectsCache.menuSbOK, ObjectsCache.menuSbOK_a, null, null);
        this.setCaption(ApplicationData.lp.getTranslatedString(Options.languageID, "TID_RACE_RESULTS"));
        this.Init();
    }

    public void unlockMaps() {
        System.out.println("unlockMaps():" + CGUserCareer.m_nRaceID);
        if (!CGUserCareer.tracksUnlocked[CGUserCareer.m_nRaceID]) {
            CGUserCareer.tracksUnlocked[CGUserCareer.m_nRaceID] = true;
        }
    }

    public void Init() {
        int[] nTimes = new int[6];
        for (int i = 0; i < 6; ++i) {
            nTimes[i] = CGUserCareer.generalClasification[i];
        }
        int[] nIndexes = new int[6];
        for (int k = 0; k < 6; ++k) {
            int nMax = -1000000;
            int nI = -1;
            for (int i = 0; i < 6; ++i) {
                if (nTimes[i] <= nMax) continue;
                nMax = nTimes[i];
                nI = i;
            }
            if (nI < 0) continue;
            nTimes[nI] = -1000000;
            nIndexes[k] = nI;
        }
        this.resultsColumnNicks.removeAllElements();
        this.resultsColumnTotal.removeAllElements();
        for (int i = 0; i < 6; ++i) {
            int nIndex = nIndexes[i];
            try {
                String str = ApplicationData.lp.getTranslatedString(Options.languageID, "ID_SHORT_NAME_1_" + nIndex);
                if (nIndex == 0) {
                    str = EditChampionshipsUserName.playerNick;
                }
                this.resultsColumnNicks.addElement(str);
                this.resultsColumnTotal.addElement(ApplicationData.defaultFont.encodeDynamicString("" + CGUserCareer.generalClasification[nIndex]));
            }
            catch (Exception e) {
                this.resultsColumnNicks.addElement(ApplicationData.defaultFont.encodeDynamicString("--empty--"));
                this.resultsColumnTotal.addElement(ApplicationData.defaultFont.encodeDynamicString("0"));
            }
            if (nIndexes[i] != 0) continue;
        }
        this.updateList(this.resultsColumnNicks, this.resultsColumnTotal);
    }

    public void updateList(Vector nicks, Vector results) {
        this.clearList();
        for (int i = 0; i < nicks.size(); ++i) {
            this.append(ApplicationData.defaultFont.encodeDynamicString(i + 1 + ". "), 0);
            this.append((String)nicks.elementAt(i), 1);
            this.append((String)results.elementAt(i), 2);
        }
    }

    public boolean leftSoftButton() {
        try {
            if (CGEngine.selectedGameMode == 2) {
                this.unlockMaps();
                ++CGUserCareer.m_nRaceID;
                if (++CareerScreen.nextEvent >= EventScreen.currentEventArray.length) {
                    UIScreen.SetCurrentScreen(new EndOfCareerScreen(CGUserCareer.FindHumanPosition()));
                } else {
                    UIScreen.SetCurrentScreen(new CareerScreen());
                }
            } else {
                ApplicationData.goToMainMenu();
            }
        }
        catch (Exception e) {
            System.out.println("Error --> " + e.getMessage());
            e.printStackTrace();
        }
        return true;
    }

    public boolean onFireAction() {
        return this.leftSoftButton();
    }

    public boolean rightSoftButton() {
        return false;
    }
}

